<?php
// Get the request body and decode JSON data
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody);
$order_id = $data->order_id ?? '';
$status = $data->status ?? '';
$order_no = $data->order_no ?? '';
$phone = $data->phone ?? '';
$mobile = $data->mobile ?? '';
if(empty($phone)){
    $phone = $mobile;
}
$phone = intval($phone);
// Read token from file
$token = file_get_contents('ageasy_token.txt');
if ($token === false) {
    die("Failed to read the token file.");
}

// Function to make a cURL request
function makeCurlRequest($url, $method, $token, $payload = null) {
    $curl = curl_init();

    $options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => array(
            'orgId: 60031797391',
            'Authorization: Zoho-oauthtoken ' . $token,
            'featureFlags: lookUp',
            'Content-Type: application/json'
        ),
    );

    if ($payload) {
        $options[CURLOPT_POSTFIELDS] = json_encode($payload);
    }

    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    curl_close($curl);

    return $response;
}
// echo $token;
$searchContactUrl = 'https://desk.zoho.in/api/v1/contacts/search?phone='.$phone;
$searchContactResponse = makeCurlRequest($searchContactUrl, 'GET', $token);
$searchContactData = json_decode($searchContactResponse, true);
$contact_id = $searchContactData['data'][0]['id'];

echo "contct". $contact_id;

// Step 1: Search for the order by order number
$searchUrl = 'https://desk.zoho.in/api/v1/cm_orders/search?field1=name%3A'.$order_no;
$searchResponse = makeCurlRequest($searchUrl, 'GET', $token);
$searchData = json_decode($searchResponse, true);
// print_r($searchData);

// Step 2: Check if the order exists or create a new one
if (empty($searchData['data'])) {
    // Order does not exist; create a new order
    $createPayload = [
        'name' => $order_no,
        'owner' => "161263000000064001",
        'cf' => [
            'cf_order_no' => $order_no,
            'cf_order_id' => $order_id,
            'cf_status' => $status,
            'cf_contact' => intval($contact_id),
            'cf_phone_2' => $phone
                            
        ],
    ];

    // print_r($createPayload);
    $createUrl = 'https://desk.zoho.in/api/v1/cm_orders';
    $createResponse = makeCurlRequest($createUrl, 'POST', $token, $createPayload);
    echo $createResponse;
} else {
    // Order exists; update the order
    $deskOrderId = $searchData['data'][0]['id'];
    $updatePayload = [
        'name' => $order_no,
        'owner' => "161263000000064001",
        'cf' => [
            // 'cf_order_no' => $order_no,
            // 'cf_order_id' => $order_id,
            'cf_status' => $status,
            'cf_contact' => intval($contact_id),
            'cf_phone_2' => $phone
        ],
    ];
    // print_r($updatePayload);
    $updateUrl = 'https://desk.zoho.in/api/v1/cm_orders/' . $deskOrderId;
    $updateResponse = makeCurlRequest($updateUrl, 'PATCH', $token, $updatePayload);
    echo $updateResponse;
}
