<?php
// Get the request body and decode JSON data
$requestBody = file_get_contents('php://input');
$data = json_decode($requestBody);
$app_name = $data->app_name ?? '';
$status = $data->status ?? '';
$app_no = $data->app_no ?? '';
if($app_no == "0013596"){
    exit;
}
$phone = $data->phone ?? '';
$mobile = $data->mobile ?? '';
$cphone = $data->cphone ?? '';
$cmobile = $data->cmobile ?? '';
if(empty($phone)){
    $phone = $mobile;
     if(empty($phone)){
         $phone = $cphone;
     }
      if(empty($phone)){
           $phone = $cmobile;
      }
}
$phone = intval($phone);

// Read token from file
$token = file_get_contents('ageasy_token.txt');
if ($token === false) {
    die("Failed to read the token file.");
}

// Function to make a cURL request
function makeCurlRequest($url, $method, $token, $payload = null) {
    $curl = curl_init();

    $options = array(
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_ENCODING => '',
        CURLOPT_MAXREDIRS => 10,
        CURLOPT_TIMEOUT => 0,
        CURLOPT_FOLLOWLOCATION => true,
        CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
        CURLOPT_CUSTOMREQUEST => $method,
        CURLOPT_HTTPHEADER => array(
            'orgId: 60031797391',
            'Authorization: Zoho-oauthtoken ' . $token,
            'featureFlags: lookUp',
            'Content-Type: application/json',
        ),
    );

    if ($payload) {
        $options[CURLOPT_POSTFIELDS] = json_encode($payload);
    }

    curl_setopt_array($curl, $options);
    $response = curl_exec($curl);
    curl_close($curl);

    return $response;
}

$searchContactUrl = 'https://desk.zoho.in/api/v1/contacts/search?phone='.$phone;
$searchContactResponse = makeCurlRequest($searchContactUrl, 'GET', $token);
$searchContactData = json_decode($searchContactResponse, true);

$contact_id = $searchContactData['data'][0]['id'];

echo "contct". $contact_id;

// Step 1: Search for the Appointment by Appointment number
$searchUrl = 'https://desk.zoho.in/api/v1/cm_meetings/search?field1=cf_appointment_number%3A' . $app_no;
$searchResponse = makeCurlRequest($searchUrl, 'GET', $token);
$searchData = json_decode($searchResponse, true);
// print_r($searchData); die;

// Step 2: Check if the Appointment exists or create a new one
if (empty($searchData)) {
    // Appointment does not exist; create a new Appointment
    $createPayload = [
        'name' => $app_no,
        'owner' => "161263000000064001",
        'cf' => [
            'cf_appointment_number' => $app_name,
            'cf_status' => $status,
            'cf_contact' => $contact_id,
            'cf_phone' => $phone
        ],
    ];
    $createUrl = 'https://desk.zoho.in/api/v1/cm_meetings';
    $createResponse = makeCurlRequest($createUrl, 'POST', $token, $createPayload);
    echo $createResponse;
} else {
    // Appointment exists; update the Appointment
    $deskAppId = $searchData['data'][0]['id'];
    $updatePayload = [
        'name' => $app_no,
        'cf' => [
            'cf_appointment_number' => $app_name,
            'cf_status' => $status,
            'cf_contact' => $contact_id,
            'cf_phone' => $phone
        ],
    ];
    $updateUrl = 'https://desk.zoho.in/api/v1/cm_meetings/' . $deskAppId;
    $updateResponse = makeCurlRequest($updateUrl, 'PATCH', $token, $updatePayload);
    echo $updateResponse;
}
