<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($page->title); ?></title>
    
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/bootstrap-grid-min.css">
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">

</head>
<body>
   <div class="fix-header">
      <div class="top-bar d-flex justify-content-center align-items-center">
        <div>For queries & other course or career related discussions</div>
        <a href="tel:+911234567890" class="btn">Get FREE COUNSELLING CALL <i class="fa fa-angle-right" aria-hidden="true"></i>
</a>
      </div>
     <div class="navbox">
  <div class="container m-header">
    <div class="row align-items-center">
      <div class=" col-sm-4">
        <img src="images/aaftlogo.png" class="lplogo" alt="AAFT Logo" width="155" height="53" />
      </div>
      <div class=" col-sm-8 text-end d-sm-none">
        <!-- Mobile menu toggle button -->
        <button class="menu-toggle" id="menuToggle">
          <span></span>
        <span></span>
      <span></span>
    </button>
      </div>

      <!-- Nav links (shared for all screen sizes) -->
      <div class="col-12 col-sm-8">
        <div class="nav-buttons" id="navButtons">
          <a href="#" class="btn btn-dark">Programme Info.</a>
          <a href="#" class="btn btn-outline-dark">Infrastructure</a>
          <a href="#" class="btn btn-outline-dark">Steps to Apply</a>
          <a href="#" class="btn btn-outline-dark">FAQ</a>
          <a href="#" class="btn btn-outline-dark">Free Resources</a>
        </div>
      </div>
    </div>
  </div>
</div>

      </div>
      <section class="banner-area relative">
        <div class="container">
          <div class="row b-sec">
            <img
              src="images/new-landingpage-banner.webp"
              width={1300}
              height={600}
              alt="logo"
              class="banner hidden-xs"
            />
            <img
              src="images/mobile-banner.png"
              width={1300}
              height={600}
              alt="logo"
              class="banner visible-xs"
            />
            
          </div>
        </div>
        <div class="absolutediv">
          <div class="container">
            <div class="row b-sec">
              <div class="col-sm-6">
                <div class="left-area">
                  <p>On-Campus : <br /><span>Delhi-NCR</span></p>
                  <div class="hr2">
                    <a href="" ><button class="squre">B.Sc in Cinema</button></a>
                  </div>
                  <h3>Specialisation in <br /><span>CINEMATOGRAPHY</span></h3>
                  <a href="" class="downloadbtn"><img
              src="images/mailicon.png" alt="logo" class="img-fluid"
            /> Download Brochure </a>
                  
                </div>
              </div>
              <div class="col-sm-1 hide1366"></div>
              <div class="col-sm-4">
                <div id="enquire"></div>
                <div class="right-area">
                  <!-- <hr class="d-block d-sm-none" /> -->
                  <div id="enquire-cta">
                    <h3>Receive a call from our <br /><span>COUNSELORS</span></h3>

                    <span>FILL IN THE DETAILS TO RECEIVE A CALL</span>
                   <form class="m-t-30" method="post" action ="<?php echo e(url('store_lead')); ?>">
                      <?php echo csrf_field(); ?>  
                      <div class="form-group">
                        <label>NAME*</label>
                        <input type="text" class="register-input-box" required placeholder="Name*" maxLength="50" name="name" /><span class="landing-form-error"></span></div>
                      <div class="form-group">
                        <label>EMAIL*</label>
                        <input type="email" class="register-input-box" required placeholder="Email*" name="email" /><span class="landing-form-error"></span></div>
                      <div class="form-group">
                        <label>CONTACT*</label>
                        <input type="text" minLength="10" maxLength="10" required class="register-input-box" placeholder="Contact Number*" name="phone" /><span class="landing-form-error"></span></div>


                      <div class="form-group">
                        <div class="checkbox">
                          <p>
                            <input type="checkbox" name="checkbox" required /> I acknowledge and agree to the Terms and Conditions of AAFT, including the admission policies, privacy, and code of conduct.</p>
                        </div><span class="landing-form-error"></span></div>
                      <div class="form-btn-wrap">
                        <input type="hidden" name="page" value="<?php echo e($page->title); ?>">
                        <button type="submit" class="form-btn"><i class="fa fa-phone" aria-hidden="true"></i> Get 1:1 COUNSELLING CALL!</button>
                      </div>

                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="duration1">
        <div class="container">
          <div class="duration-content">
            <div class="row notice1">
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item1">
                  <p>Duration</p>
                  <h3>03 Years</h3>
                </div>
              </div>
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item2">
                  <p>Class Schedule</p>
                  <h3>05 Days/Week</h3>
                </div>
              </div>
              <!-- <hr class="d-block d-sm-none" /> -->
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item4">
                  <p>Financial Aid</p>
                  <h3>Easy EMI Option</h3>
                </div>
              </div>
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item5">
                  <p>Placements</p>
                  <h3>100% Assistance</h3>
                </div>
              </div>
              
            </div>
          </div>
          <div id="about"></div>
        </div>
      </section>
      <section class="highlight-section">

        <div class="container">
          <div class="row b-sec">
            <h1>
              The paramount of cinema studies is the<br />
              <span class="red-highlight">practical application of your vision for</span>
              creating cinematic masterpieces.
            </h1>
            </div>
        </div>
      </section>

      <section class="about-section aboutaaft">
        <div class="container">
          <h3>About <span>AAFT</span></h3>
          <p class="about-subtext">Access to state of the art equipment and industry-centric curriculum, shaping future success.</p>

          <div class="row justify-content-center">
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon1.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">Education<br /> Legacy</div>
              <div class="stats-number">33 Years</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon2.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">Alumni<br /> Network</div>
              <div class="stats-number">35000+</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon3.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">World<br /> Ranking</div>
              <div class="stats-number">10<sup>th</sup>*</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon4.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">State of the<br /> Art Campus</div>
              <div class="stats-number">100 ACRES</div>
            </div>
          </div>
        </div>
      </section>

      <section class="about-section mpading0">
    <div class="container">
        <div class="row">
            <h3>Our <span> Collaborations</span></h3>

            <div class="row justify-content-center">
                <div id="six-item" class="owl-carousel owl-theme">
                    <div class="item">
                        <div>
                            <Image src="images/col-1.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-2.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-3.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-4.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-5.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-6.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-7.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-8.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-9.png" alt="" />
                        </div>
                    </div>
                </div>

            </div>
        </div>

    </div>
</section>
      <section class="about-section">
        <div class="container">
          <div class="row">
            <div class="offset-md-1 col-md-10">
              <h3>The <span> Course</span> is Designed For</h3>
              <p class="about-subtext">The <b>B.Sc. (Cinematography)</b> pathway is designed for students who aspire to deepen their understanding of the film and television industry. It emphasizes the development of advanced cinematography skills while strengthening core filmmaking abilities, enabling students to master the craft of visual storytelling and content creation.</p>
            </div>
            <div class="row justify-content-center">
              <div class="col-md-6">
                <div class="career-card">
                  <img src="images/career1.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <div class="card-title">Career Trajectory</div>
                    <ul>
                      <li>Director of Photography</li>
                      <li>Camera Operator</li>
                      <li>Freelance/ Commercial Asst. Director</li>
                      <li>Digital Imaging Technician (DIT)</li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="career-card">
                  <img src="images/career2.png" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <div class="card-title">Skills Acquisition</div>
                    <ul>
                      <li>Camera & Lighting Techniques</li>
                      <li>Digital Proficiency</li>
                      <li>Latest Software & Technical Equipment</li>
                      <li>Project & Crew Collaboration</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="about-section course-highlights">
    <div class="container">

        <h3>Course Highlights</h3>
        <ul class="nav nav-tabs">
            <li class="nav-item"><a class="nav-link " data-bs-toggle="tab" href="#tabs-1" role="tab">How You’ll Learn at AAFT</a></li>
            <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#tabs-2" role="tab">Academic Staff</a></li>
            <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#tabs-3" role="tab">Career &amp; Placements</a></li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane " aria-labelledby="tabs-1" id="tabs-1" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>Academic Staff</h3>
                            <p>In the B.Sc. (Cinematography) program at AAFT, learning is immersive and hands-on. You’ll engage through unorthodox blends of seminars, on-site workshops, interactive lectures, 1:1 tutorials, studio visits, and exclusive masterclasses
                                delivered by seasoned professionals from the film and television industry.</p>
                            <p> We emphasize industry-standard assessments that follow a 70:30 structure—with 70% focused on practical production work and live project briefs and 30% dedicated to written reflections and critical analysis, ensuring a well-rounded
                                development of both technical skills and creative thinkingojo.</p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/tabimage.png" alt="Skills Acquisition" class="img-fluid"></div>
                </div>
            </div>
            <div class="tab-pane active" aria-labelledby="tabs-2" id="tabs-2" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>Academic Staff adad</h3>
                            <p>In the B.Sc. (Cinematography) program at AAFT, learning is immersive and hands-on. You’ll engage through unorthodox blends of seminars, on-site workshops, interactive lectures, 1:1 tutorials, studio visits, and exclusive masterclasses
                                delivered by seasoned professionals from the film and television industry.</p>
                            <p> We emphasize industry-standard assessments that follow a 70:30 structure—with 70% focused on practical production work and live project briefs and 30% dedicated to written reflections and critical analysis, ensuring a well-rounded
                                development of both technical skills and creative thinkingojo.</p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/tabimage.png" alt="Skills Acquisition" class="img-fluid"></div>
                </div>
            </div>
            <div class="tab-pane " aria-labelledby="tabs-3" id="tabs-3" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>Academic Staff</h3>
                            <p>In the B.Sc. (Cinematography) program at AAFT, learning is immersive and hands-on. You’ll engage through unorthodox blends of seminars, on-site workshops, interactive lectures, 1:1 tutorials, studio visits, and exclusive masterclasses
                                delivered by seasoned professionals from the film and television industry.</p>
                            <p> We emphasize industry-standard assessments that follow a 70:30 structure—with 70% focused on practical production work and live project briefs and 30% dedicated to written reflections and critical analysis, ensuring a well-rounded
                                development of both technical skills and creative thinkingojo.</p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/tabimage.png" alt="Skills Acquisition" class="img-fluid"></div>
                </div>
            </div>
        </div>

    </div>

</section>
      <section class="about-section pading-top">
    <div class="container">
        <div class="row">
            <div class="faqnewdesign">
                <h3>Curriculum <span>Breakdown</span></h3>
                <div class="accordion" id="accordionExample">

                    <!-- Item 1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
        <button class="accordion-button" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
          Semester 1: Foundations of Media & Film Production
          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                            </div>
                        </div>
                    </div>

                    <!-- Item 2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
          Semester 2: Cinematography & Advanced Directing
          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                            </div>
                        </div>
                    </div>

                    <!-- Item 3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
          Semester 3: Specialized Cinematography Techniques
          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section mob-pad">
        <div class="container">
          <div class="row">
            <div class="faqnewdesign second-design">
            <h3>Specialization Curriculum Breakdown:  <span>Cinematography Focus</span></h3>
            <div class="accordion" id="accordionExample1">

              <!-- Item 1 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingOne1">
                  <button class="accordion-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseOne1" aria-expanded="true" aria-controls="collapseOne1">
                    Semester 1: Foundations of Media & Film Production
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseOne1" class="accordion-collapse collapse show" aria-labelledby="headingOne1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                  </div>
                </div>
              </div>

              <!-- Item 2 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingTwo1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseTwo1" aria-expanded="false" aria-controls="collapseTwo1">
                    Semester 2: Cinematography & Advanced Directing
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseTwo1" class="accordion-collapse collapse" aria-labelledby="headingTwo1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                  </div>
                </div>
              </div>

              <!-- Item 3 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingThree1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseThree1" aria-expanded="false" aria-controls="collapseThree1">
                    Semester 3: Specialized Cinematography Techniques
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseThree1" class="accordion-collapse collapse" aria-labelledby="headingThree1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                  </div>
                </div>
              </div>

            </div>
          </div>
          </div>
        </div>
      </section>
      <section class="about-section accadmic-prectice">
    <div class="container">
        <div class="row">
            <div class="col-md-9 text-left">
                <h3>Academic Practices</h3>
                <p>The B.Sc. (Cinematography) pathway is designed for students who wish to deepen their understanding of the Film and TV industry. While building on existing filmmaking skill students will focus on refining their cinematography expertise,
                    helping you become the best in your craft and create an exceptional body of work.</p>
            </div>
            <div class="col-md-3">
                <form class="yearfield">
                    <select aria-label="Degree Year" class="form-control" name="degree" aria-label="Degree Year">
                        <option value="">Degree Year 01</option>
                        <option value="Degree Year 01">Degree Year 01</option>
                        <option value="Degree Year 01">Degree Year 01</option>

                    </select>
                    <i class="fa fa-angle-down" aria-hidden="true"></i>
                </form>
            </div>
        </div>
    </div>
</section>
<section class="about-section accadmic-tab">
    <div class="container new-bg-black">
        <div class="row  ">
            <div class="col-md-12 text-left">
                <ul class="nav nav-tabs">
                    <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#tabs-11" role="tab">LEARNING<br> OUTCOMES</a></li>
                    <li class="nav-item"><a class="nav-link " data-bs-toggle="tab" href="#tabs-21" role="tab">PRACTICAL<br> LEARNING</a></li>

                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" aria-labelledby="tabs-11" id="tabs-11" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample2">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne2">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseOne2" aria-expanded="true" aria-controls="collapseOne2">
                                                  Semester 1: Foundations of Media & Film Production
                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseOne2" class="accordion-collapse collapse " aria-labelledby="headingOne2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo2">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo2" aria-expanded="false" aria-controls="collapseTwo2">
                                                Semester 2: Cinematography & Advanced Directing
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo2" class="accordion-collapse collapse" aria-labelledby="headingTwo2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree2">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree2" aria-expanded="false" aria-controls="collapseThree2">
                                                Semester 3: Specialized Cinematography Techniques
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree2" class="accordion-collapse collapse" aria-labelledby="headingThree2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample3">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne3">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseOne3" aria-expanded="true" aria-controls="collapseOne3">
                                                  Semester 1: Foundations of Media & Film Production
                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseOne3" class="accordion-collapse collapse " aria-labelledby="headingOne3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                    Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo3">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo3" aria-expanded="false" aria-controls="collapseTwo3">
                                                Semester 2: Cinematography & Advanced Directing
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo3" class="accordion-collapse collapse" aria-labelledby="headingTwo3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                    Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree3">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseThree3" aria-expanded="false" aria-controls="collapseThree3">
                                                  Semester 3: Specialized Cinematography Techniques
                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseThree3" class="accordion-collapse collapse" aria-labelledby="headingThree3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                    Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tab-pane " aria-labelledby="tabs-21" id="tabs-21" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample21">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOne21" aria-expanded="true" aria-controls="collapseOne21">
                                                Semester 11: Foundations of Media & Film Production
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseOne21" class="accordion-collapse collapse" aria-labelledby="headingOne21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo21" aria-expanded="false" aria-controls="collapseTwo21">
                                                Semester 2: Cinematography & Advanced Directing
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo21" class="accordion-collapse collapse" aria-labelledby="headingTwo21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree21" aria-expanded="false" aria-controls="collapseThree21">
                                                Semester 3: Specialized Cinematography Techniques
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree21" class="accordion-collapse collapse" aria-labelledby="headingThree21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample31">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOne31" aria-expanded="true" aria-controls="collapseOne31">
                                                Semester 1: Foundations of Media & Film Production
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseOne31" class="accordion-collapse collapse " aria-labelledby="headingOne31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo31" aria-expanded="false" aria-controls="collapseTwo31">
                                                Semester 2: Cinematography & Advanced Directing
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo31" class="accordion-collapse collapse" aria-labelledby="headingTwo31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree31" aria-expanded="false" aria-controls="collapseThree31">
                                                Semester 3: Specialized Cinematography Techniques
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree31" class="accordion-collapse collapse" aria-labelledby="headingThree31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                </div>

            </div>
        </div>
</section>
      <section class="about-section videoslider">
    <div class="container">
        <div class="row">

            <h3>Project <span>Videos</span></h3>
            <div class="four-item owl-carousel owl-theme">
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section gallerysec">


    <h3>Life at <span>School of Cinema</span></h3>
    <div id="six-item1" class="owl-carousel owl-theme">
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
    </div>
    <div id="six-item2" class="owl-carousel owl-theme">
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
    </div>



</section>
      <section class="about-section accadmic-prectice">
        <div class="container">
        <div class="row justify-content-center">
          <h3>Infrastructure</h3>
             <div  class="three-item owl-carousel owl-theme">
        <div class="item">
                <div class="career-card">
                  <img src="images/career1.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">High End Camera & Production Equipments</h4>
                    
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="career-card">
                  <img src="images/career2.png" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">Chroma Set & Enabled Studios</h4>
                    
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="career-card">
                  <img src="images/career2.png" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">Industry Level Lighting Set-Ups</h4>
                    
                  </div>
                </div>
              </div>
              </div>
          </div>
          </section>
          <section class="about-section application-info">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Learn from <span>Industry Veterans</span></h3>
                <p class="about-subtext">AAFT Boats of a highly qualified and experiences team of professor who hold impeccable industrial acumen after having led successful careers in their respective fields.</p>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-6 col-md-6">
                <div class="learndata">
                    <a href="">
                        <button class="squre">Industry Dean</button>
                    </a>
                    <h2>Ms. SWARA BHASKAR</h2>
                    <p class="hidden-xs">Swara Bhasker, an Indian actress has joined AAFT as the Industry Dean of the School of Drama & Acting. Best known for her supporting work in mainstream productions and starring roles in independent films, she has won two Screen Awards
                        and has received four Filmfare Award nominations. Bhasker garnered widespread recognition from critics and audiences with a supporting role in the 2011's commercially successful romantic comedy-drama Tanu Weds Manu.</p>

                </div>
            </div>
            <div class="col-6 col-md-6">
                <div class="learndata"><img src="images/swara-bhaskar.png" alt="Laurel" class="laurel img-fluid" />
                <p class="visible-xs">Swara Bhasker, an Indian actress has joined AAFT as the Industry Dean of the School of Drama & Acting. Best known for her supporting work in mainstream productions and starring roles in independent films, she has won two Screen Awards
                        and has received four Filmfare Award nominations. Bhasker garnered widespread recognition from critics and audiences with a supporting role in the 2011's commercially successful romantic comedy-drama Tanu Weds Manu.</p>
                      </div>

            </div>
            <div  class="fornew-item owl-carousel owl-theme">
        <div class="item">
                <div class="learnotherdata">
                    <img src="images/team1.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Dr. Shivani Dappe</h4>
                        <p>Dean (School of Cinema)</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team2.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Mr. Ashok Dhingra</h4>
                        <p>Mr. Ashok Dhingra</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team3.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Ms. Kirti</h4>
                        <p>Assistant Professor</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team1.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Ankit Saroha</h4>
                        <p>Dean (School of Cinema)</p>
                    </div>
                </div>
              </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section application-info meet-our-alumini">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Meet Our <span>ALUMNI</span></h3>

            </div>
        </div>
        <div class="row justify-content-left row-reves">
            <div class="col-6 col-md-6">
                <div class="learndata1">
                    <div id="one-item" class="owl-carousel owl-theme">
                        <div class="item">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
                        </div>
                        <div class="item">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
                        </div>
                        <div class="item">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
                        </div>
                    </div>


                </div>
            </div>
            <div class="col-6 col-md-6">
                <div class="learndataimage"><img src="images/alumini-image.png" alt="Laurel" class="laurel img-fluid" /></div>

            </div>

        </div>
    </div>
</section>
      <section class="about-section accadmic-prectice success-stories mpading">
    <div class="container">
        <div class="row justify-content-center pb-3">
            <h3>Students <span class="colorblack">Success Stories</span> </h3>
           <div  class="fornew1-item owl-carousel owl-theme">
        <div class="item">
                <div class="learnotherdata">
                    <img src="images/story-image.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon1.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Prathmesh<br/> Kumbhare</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
           <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon2.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Ajay <br/>Dubey</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
            <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon3.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Akash K.<br/> Mathur</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
            <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon4.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Dhruv <br/>Sethi</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
              </div>
            </div>
        </div>
        <div class="row justify-content-center pt-5">
            <h3>Students <span class="colorblack">Feedback</span> </h3>
            <div class="four-item1 owl-carousel owl-theme">
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
          <section class="about-section application-info mtext-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Who Can <span>Apply?</span></h3>
                <p class="about-subtext">We attract exceptional candidates who possess a blend of intellectual curiosity, leadership potential and a passion for music, thereby creating a cohort of promising future leaders.</p>
            </div>
        </div>
        <div class="row justify-content-center">
            <h4 class="mb-5">Eligibility Criteria</h4>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate must have a 10+2 from a recognized university/institution</p>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate must have a minimum of 50% marks in 10+2 (45% for reserved categories)</p>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate need to clear the AAFT Global Entrance Test (GET)</p>

                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section steptoapply">
    <div class="container">
        <div class="row justify-content-center">

            <h3>Step to <span>Apply?</span></h3>

            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>01</span>
                    <div>
                        <h4>Application Form</h4>
                        <p>Candidate must have a 10+2 from a recognized university/institution</p>
                    </div>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>02</span>
                    <div>
                        <h4>Personal Interview</h4>
                        <p>A personal interview will be conducted to screen your application.</p>
                    </div>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>03</span>
                    <div>
                        <h4>Offer of Admission</h4>
                        <p>Post the admission round, the admission letter will be rolled out to the selected candidates.</p>
                    </div>

                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section bookacall">
    <div class="container">
        <div class="row justify-content-center">
            <div class="bookcallbox">
                <img src="images/book-call-bg.png" alt="Laurel" class="img-fluid" />

                <div>
                    <h4>Let's Get<br/> You Onboard!</h4>
                    <a href="">
                        <button class="squre"><i class="fa fa-phone" aria-hidden="true"></i> BOOK A 1:1 CALL</button>
                    </a>
                </div>



            </div>
        </div>

    </div>

</section>
      <section class="about-section pb-0">
    <div class="container">
        <div class="row">
            <div class="faqnewdesign second-design">
                <h3>Frequently Asked <span>Question!</span></h3>
                <div class="accordion" id="accordionExample4">

                    <!-- Item 1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne4">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseOne4" aria-expanded="true" aria-controls="collapseOne4">
                              Semester 1: Foundations of Media & Film Production
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseOne4" class="accordion-collapse collapse show" aria-labelledby="headingOne4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                                Aesthetics of Make-up & Costume, Craft Development & Industry Relevance, Montage & Music Video Direction, Film Editing Techniques, Cinematography Specialization, Hands-on Camera & Lighting Skills.
                            </div>
                        </div>
                    </div>

                    <!-- Item 2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo4">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseTwo4" aria-expanded="false" aria-controls="collapseTwo4">
                              Semester 2: Cinematography & Advanced Directing
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseTwo4" class="accordion-collapse collapse" aria-labelledby="headingTwo4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                                Visual Storytelling, Advanced Lighting Techniques, Script Breakdown & Shot Design, Sound Design, Studio Production Workshop, Location-Based Cinematography.
                            </div>
                        </div>
                    </div>

                    <!-- Item 3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree4">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseThree4" aria-expanded="false" aria-controls="collapseThree4">
                              Semester 3: Specialized Cinematography Techniques
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseThree4" class="accordion-collapse collapse" aria-labelledby="headingThree4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                                Cinematic Lighting for Narrative, Drone & Gimbal Cinematography, Multi-Camera Setup Techniques, Color Grading & LUTs, Industry Internship, Portfolio Project.
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section courselanding">
    <div class="container">
        <div class="offset-md-1 col-md-10">
            <h3>Related <span> Course</span></h3>
        </div>
        <div class="row justify-content-center">
            <div class="two-item owl-carousel owl-theme">
                <div class="item">
                    <div class="career-card">
                        <Image src="images/career1.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Direction <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="career-card">
                        <Image src="images/career2.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Direction <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="career-card">
                        <Image src="images/career1.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Direction <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="career-card">
                        <Image src="images/career2.png" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Direction <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<footer class="next-step-section  text-center ">
  <div class="container">
    <div class="row">
    <h3 class="mb-5">Next Step</h3>

    <!-- Buttons Row -->
    <div class="row next-step-buttons mb-3">
      <div class="col-md-4">
        <a href="#" class="btn">
          <span><img src="images/vitual-tour.png" alt="Laurel" class="img-fluid" />Take Virtual Tour</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
      <div class="col-md-4">
        <a href="#" class="btn">
          <span><img src="images/book-a-visit.png" alt="Laurel" class="img-fluid" />Book a Visit</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
      <div class="col-md-4">
        <a href="#" class="btn">
          <span><img
              src="images/mailicon.png" alt="logo" class="img-fluid"
            />Download Brochure</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
    </div>

    <!-- Info Row -->
    <div class="row text-start mt-2 pt-3 align-items-start bordertop">
      <div class="col-md-4 map-container">
        <iframe
          src="https://www.google.com/maps/embed/v1/place?q=FC+14%2F15,+Film+City,+Sector+16A,+Noida,+Uttar+Pradesh+201301&key=AIzaSyDhOPKoDbaRE_QIuTpVqWZVJnXU3osiuj4"
          allowfullscreen="" loading="lazy">
        </iframe>
        <img src="images/aaftlogo.png" alt="AAFT Logo" class="img-fluid logo mt-3" width="100">
      </div>
      <div class="col-md-4 office-info">
        <h6>Admission Office</h6>
        <p>FC 14/15, Film City,<br>Sector 16A, Noida,<br>Uttar Pradesh 201301</p>
      </div>
      <div class="col-md-4 office-info">
        <h6>University Campus</h6>
        <p>AAFT University, Vill. Manth,<br>Kharora, District – Raipur,<br>Chhattisgarh – 493225</p>
      </div>
    </div>
    </div>
    </div>
  </section>
<div class="modal fade" id="iframeModal" tabindex="-1" aria-labelledby="iframeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
       
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="stopIframe()"></button>
      </div>
      <div class="modal-body">
        <div class="responsive-iframe">
          <iframe id="iframeContent" src="https://www.youtube.com/embed/dQw4w9WgXcQ" allowfullscreen></iframe>
        </div>
      </div>
    </div>
  </div>
</div>

    </main>
    
   <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<!-- Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<!-- Bootstrap JS -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css"/>
<!-- jQuery & Owl Carousel JS -->
<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
<!-- YouTube IFrame API -->
<!-- YouTube API -->
<script>
 $("#six-item").owlCarousel({
            items: 6,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 3.2,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 4
                  },
                  768: {
                    items: 5.2,
                    margin: 10,
                  },
                  1025: {
                    items: 6.1
                  }
                }
          });
 $("#six-item1").owlCarousel({
            items: 4,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            stagePadding: 60,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    margin:10,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                 768: {
                    items: 5.2,
                    margin: 10,
                  },
                  1025: {
                    items: 6.4
                  }
                }
          });
 $("#six-item2").owlCarousel({
          items: 4,
            loop: true,
            autoplay: true,
            rtl: true,
            autoplaySpeed: 2000,
            stagePadding: 60,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    margin:10,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                 768: {
                    items: 5.2,
                    margin: 10,
                  },
                  1025: {
                    items: 6.4
                  }
                }
          });
 $("#one-item").owlCarousel({
            items: 4,
            loop: false,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: true,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                    dots: false,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 1
                  },
                  768: {
                    items: 1
                  },
                  992: {
                    items: 1
                  }
                }
          });
 $(".fornew-item").owlCarousel({
            items: 3,
            loop: false,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  1025: {
                    items: 4
                  }
                }
          });
 $(".fornew1-item").owlCarousel({
            items: 3,
            loop: false,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:0,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  1025: {
                    items: 4
                  }
                }
          });
  $(".three-item").owlCarousel({
            items: 3,
            loop: false,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 2
                  },
                  992: {
                    items: 3
                  }
                }
          });
 $(".fornew-item").owlCarousel({
            items: 3,
            loop: false,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1.2,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  992: {
                    items: 4
                  }
                }
          });
</script>

      <script>
        $(document).ready(function(){
         
          $(".four-item").owlCarousel({
            items: 4,
            loop: false,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: true,
            margin:30,
            autoplayHoverPause: true,
             navText: [
                      '<img src="images/left-arrow.png" alt="Prev" style="width: 24px;">',
                      '<img src="images/right-arrow.png" alt="Next" style="width: 24px;">'
                    ],
            responsive: {
                  0: {
                    items: 1.2,
                    autoplay: true,
                    autoplaySpeed: 1000,
                    nav: false,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  992: {
                    items: 4
                  }
                }
          });
          $(".four-item1").owlCarousel({
            items: 4,
            loop: false,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: true,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
             navText: [
                      '<img src="images/left-arrow.png" alt="Prev" style="width: 24px;">',
                      '<img src="images/right-arrow.png" alt="Next" style="width: 24px;">'
                    ],
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  1025: {
                    items: 4
                  }
                }
          });
          $(".two-item").owlCarousel({
            items: 2,
            loop: true,
            autoplay: true,
            autoplaySpeed: 1000,
            smartSpeed: 1000,   
            dots: false,
            nav: true,
            margin:20,
            autoplayHoverPause: true,
            navText: [
                      '<img src="images/left-arrow.png" alt="Prev" style="width: 24px;">',
                      '<img src="images/right-arrow.png" alt="Next" style="width: 24px;">'
                    ],
                    responsive: {
                  0: {
                    items: 1
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 2
                  },
                  992: {
                    items: 2
                  }
                }
          });
        });


</script>
<script>
        new WOW().init();
</script>
<script>
  // Listen for collapse show event in accordionExample3
  document.querySelectorAll('#accordionExample3 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample2 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });


  document.querySelectorAll('#accordionExample2 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample3 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });
   document.querySelectorAll('#accordionExample31 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample21 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });


  document.querySelectorAll('#accordionExample21 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample31 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });
</script>
<script>
const menuToggle = document.querySelector('#menuToggle');
const navButtons = document.getElementById('navButtons');

menuToggle.addEventListener('click', function (e) {
  e.stopPropagation(); // Prevent event bubbling to document
  this.classList.toggle('active');
  navButtons.classList.toggle('show');
});

document.addEventListener('click', function (e) {
  // If click is outside navButtons and menuToggle
  if (!navButtons.contains(e.target) && !menuToggle.contains(e.target)) {
    navButtons.classList.remove('show');
    menuToggle.classList.remove('active');
  }
});


</script>
    
      
</body>
</html><?php /**PATH C:\xampp4\htdocs\aaft_cms\resources\views/front/landingpage2.blade.php ENDPATH**/ ?>