<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($page->title); ?></title>
    
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/bootstrap-grid-min.css">
    
    <link href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/3.5.2/animate.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.css" integrity="sha512-5A8nwdMOWrSz20fDsjczgUidUBR8liPYU+WymTZP1lmY9G6Oc7HlZv156XqnsgNUzTyMefFTcsFH/tnJE/+xBg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="css/style.css">
<style>
@media (min-width: 1020px) {
    
section.about-section.setheight .card-content {
    min-height: 492px;
}
.review-box {
    min-height: 350px;
    display: flex;
    flex-direction: column;
    justify-content: space-evenly;
}
.review-box p span {
    min-height: 189px;}
}
@media screen and (min-width: 1100px) and (max-width: 1400px) {
.review-box p span {  min-height: 216px;}


}
@media screen and (min-width: 768px) and (max-width: 920px) {
.hr2 button.squre{font-size:17px}
.review-box p span{min-hight:216px;min-height: 217px;}
}
</style>
</head>
<body>
   <div class="fix-header">
      <div class="top-bar d-flex justify-content-center align-items-center">
        <div>For queries & other course or career related discussions</div>
        <a href="tel:+08031443425" class="btn">Get FREE COUNSELLING CALL <i class="fa fa-angle-right" aria-hidden="true"></i>
</a>
      </div>
     <div class="navbox">
  <div class="container m-header">
    <div class="row align-items-center">
      <div class=" col-sm-4">
        <img src="images/aaftlogo.png" class="lplogo" alt="AAFT Logo" width="155" height="53" />
      </div>
      <div class=" col-sm-8 text-end d-sm-none">
        <!-- Mobile menu toggle button -->
        <button class="menu-toggle" id="menuToggle">
          <span></span>
        <span></span>
      <span></span>
    </button>
      </div>

      <!-- Nav links (shared for all screen sizes) -->
      <div class="col-12 col-sm-8">
        <div class="nav-buttons" id="navButtons">
          <a href="#programme" class="btn btn-outline-dark btn-dark">Programme Info.</a>
          <a href="#infrastructure" class="btn btn-outline-dark">Infrastructure</a>
          <a href="#steps-to-apply" class="btn btn-outline-dark">Steps to Apply</a>
          <a href="#faq" class="btn btn-outline-dark">FAQ</a>
          <a href="#resources" class="btn btn-outline-dark">Free Resources</a>
          </div>
      </div>
    </div>
  </div>
</div>

      </div>
      <section class="banner-area relative" id="book">
        <div class="container">
          <div class="row b-sec">
            <img
              src="images/photography-new-landingpage-banner.jpg"
              width={1300}
              height={600}
              alt="logo"
              class="banner hidden-xs"
            />
            <img
              src="images/mobile-banner.png"
              width={1300}
              height={600}
              alt="logo"
              class="banner visible-xs"
            />
            
          </div>
        </div>
        <div class="absolutediv">
          <div class="container">
            <div class="row b-sec">
              <div class="col-sm-6">
                <div class="left-area">
                  <p>On-Campus : <br /><span>Delhi-NCR</span></p>
                  <div class="hr2">
                    <a  ><button class="squre" style="cursor: auto;">B.A. in Professional Photography</button></a>
                  </div>
                  <!-- <h3>Specialisation in <br /><span>CINEMATOGRAPHY</span></h3> -->
                  <a href="https://stg.weaddo.live/aaftcms/public/images/cinema.pdf" target="_blank" class="downloadbtn"><img
              src="images/mailicon.png" alt="logo" class="img-fluid"
            /> Download Brochure </a>
                  
                </div>
              </div>
              <div class="col-sm-1 hide1366"></div>
              <div class="col-sm-4">
                <div id="enquire"></div>
                <div class="right-area">
                  <!-- <hr class="d-block d-sm-none" /> -->
                  <div id="enquire-cta">
                    <h3>Receive a call from our <br /><span>COUNSELORS</span></h3>

                    <span>FILL IN THE DETAILS TO RECEIVE A CALL</span>
                   <form class="m-t-30" method="post" action ="<?php echo e(url('store_lead')); ?>">
                      <?php echo csrf_field(); ?>  
                      <div class="form-group">
                        <label>NAME*</label>
                        <input type="text" class="register-input-box" required placeholder="Name*" oninput="this.value = this.value.replace(/[^a-zA-Z\s]/g, '');" maxLength="50" name="name" /><span class="landing-form-error"></span></div>
                      <div class="form-group">
                        <label>EMAIL*</label>
                        <input type="email" class="register-input-box" required placeholder="Email*" name="email" /><span class="landing-form-error"></span></div>
                      <div class="form-group">
                        <label>CONTACT*</label>
                        <input type="text" minLength="10" maxLength="10" required class="register-input-box" placeholder="Contact Number*" name="phone" oninput="this.value = this.value.replace(/[^0-9]/g, '');" pattern="[1-9]{1}[0-9]{9}" /><span class="landing-form-error"></span></div>


                      <div class="form-group">
                        <div class="checkbox">
                          <p>
                            <input type="checkbox" name="checkbox" required /> I acknowledge and agree to the <a href="https://aaft.com/privacy-policy">Terms and Conditions</a> of AAFT, including the admission policies, privacy, and code of conduct.</p>
                        </div><span class="landing-form-error"></span></div>
                      <div class="form-btn-wrap">
                        <input type="hidden" name="page" value="<?php echo e($page->title); ?>">
                        <button type="submit" class="form-btn"><img
              src="images/call-image.png" alt="logo" class="img-fluid"
            /> Get 1:1 COUNSELLING CALL!</button>
                      </div>

                    </form>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="duration1">
        <div class="container">
          <div class="duration-content">
            <div class="row notice1">
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item1">
                  <p>Duration</p>
                  <h3>03 Years</h3>
                </div>
              </div>
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item2">
                  <p>Class Schedule</p>
                  <h3>05 Days/Week</h3>
                </div>
              </div>
              <!-- <hr class="d-block d-sm-none" /> -->
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item4">
                  <p>Financial Aid</p>
                  <h3>Easy EMI Option</h3>
                </div>
              </div>
              <div class="col-md-3 col-6 col-sm-4">
                <div class="item5">
                  <p>Placements</p>
                  <h3>100% Assistance</h3>
                </div>
              </div>
              
            </div>
          </div>
          <div id="about"></div>
        </div>
      </section>
      <section class="highlight-section">

        <div class="container">
          <div class="row b-sec">
            <h1>
              Photography is the only language that <span class="red-highlight">can be understood anywhere in the</span>world.
              <!-- The paramount of cinema studies is the<br />
              <span class="red-highlight">practical application of your vision for</span>
              creating cinematic masterpieces. -->
            </h1>
            </div>
        </div>
      </section>

      <section class="about-section aboutaaft">
        <div class="container">
          <h3>About <span>AAFT</span></h3>
          <p class="about-subtext">Access to state of the art equipment and industry-centric curriculum, shaping future success.</p>

          <div class="row justify-content-center">
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon1.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">Education<br /> Legacy</div>
              <div class="stats-number">33 Years</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon2.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">Alumni<br /> Network</div>
              <div class="stats-number">35000+</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon3.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">World<br /> Ranking</div>
              <div class="stats-number">10<sup>th</sup>*</div>
            </div>
            <div class="col-6 col-md-3 col-xs-6">
              <div class="stats-icon"><img src="images/icon4.png" alt="Laurel" class="laurel" width={100} height={100} /></div>
              <div class="stats-title">Right at the<br /> heart of</div>
              <div class="stats-number">Film City</div>
            </div>
          </div>
        </div>
      </section>

      <section class="about-section mpading0">
    <div class="container">
        <div class="row">
            <h3>Our <span> Collaborations</span></h3>

            <div class="row justify-content-center">
                <div id="six-item" class="owl-carousel owl-theme">
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-1.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-2.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-3.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-4.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-5.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/photography-col-6.png" alt="" />
                        </div>
                    </div>
                    <!-- <div class="item">
                        <div>
                            <Image src="images/col-7.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-8.png" alt="" />
                        </div>
                    </div>
                    <div class="item">
                        <div>
                            <Image src="images/col-9.png" alt="" />
                        </div>
                    </div> -->
                </div>

            </div>
        </div>

    </div>
</section>
      <section class="about-section setheight ">
        <div class="container">
          <div class="row">
            <div class="offset-md-1 col-md-10">
              <h3>The <span> Course</span> is Designed For</h3>
              <p class="about-subtext">The <b>B.A. in Professional Photography</b> program is designed for those who love to capture the world through lens. This industry-aligned program focuses on creative vision, technical expertise and storytelling through images. With our 100% practical curriculum, our photography course will help students gain in-depth knowledge about lighting, composition, post-production and visual aesthetics. With our photography course, you will learn about different genres including fashion, product, documentary, wildlife, portrait and commercial photography.</p>
            </div>
            <div class="row justify-content-center">
              <div class="col-md-6">
                <div class="career-card">
                  <img src="images/photography-career1.jpg" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <div class="card-title">Career Trajectory</div>
                    <ul>
                      <li>Product Photographer</li>
                      <li>Fashion Photographer</li>
<li>Photojournalist</li>
<li>Wedding Photographer</li>
<li>Commercial Photographer</li>
<li>Event Photographer</li>
<li>Travel Photographer</li>
<li>Workshop Trainer</li>
<li>Photo Editor</li>
                    </ul>
                  </div>
                </div>
              </div>
              <div class="col-md-6">
                <div class="career-card">
                  <img src="images/photography-career2.jpg" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <div class="card-title">Skills Acquisition</div>
                    <ul>
                      <li>Mastery over lenses, lighting and equipment</li>
                      <li>Creative eye for detail, color and aesthetics</li>
                      <li>Editing and Post-processing Skills</li>
                      <li>Communication and Interpersonal Skills</li>
<li>Business & Marketing Basics</li>
<li>Adaptability and Flexibility</li>
                    </ul>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
      <section class="about-section course-highlights">
    <div class="container">

        <h3>Course Highlights</h3>
        <ul class="nav nav-tabs">
            <li class="nav-item"><a class="nav-link " data-bs-toggle="tab" href="#tabs-1" role="tab">How You’ll Learn at AAFT</a></li>
            <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#tabs-2" role="tab">Academic Staff</a></li>
            <li class="nav-item"><a class="nav-link" data-bs-toggle="tab" href="#tabs-3" role="tab">Career &amp; Placements</a></li>
        </ul>
        <div class="tab-content">
            <div class="tab-pane " aria-labelledby="tabs-1" id="tabs-1" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>How You’ll Learn at AAFT</h3>
                            <p>The program <b>B.A. in Professional Photography</b> is an industry-aligned 100% assessment structure, with a focus on practical sessions and live projects, fashion shows and portfolio development, strategic thinking and critical analysis. This program offers a holistic development of both artistic expression and intellectual understanding, preparing students for real-world fashion careers.</p>
                            <p>Throughout the program, you will engage in interactive lectures, on-location and studio shoots, post-production workshops, exclusive masterclasses, including 1:1 vocal tutorials by renowned photographers and industry leaders. </p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/photography-tabimage1.jpg" alt="Skills Acquisition" class="img-fluid r-30 hidden-xs"></div>
                </div>
            </div>
            <div class="tab-pane active" aria-labelledby="tabs-2" id="tabs-2" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>Academic Staff</h3>
                            <p>At AAFT, you’ll learn from a team of accomplished educators and active industry professionals—including renowned photographers and industry leaders. Their ongoing involvement in national and international projects keeps the curriculum relevant, future-facing, and aligned with industry trends.</p>
                            <p>The B.A. in Professional Photography program also offers valuable exposure through guest lectures, on-campus masterclasses, professional studio visits, and opportunities for expert mentorship and industry consultation, giving you insights that go beyond the classroom.</p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/photography-tabimage.jpg" alt="Skills Acquisition" class="img-fluid r-30 hidden-xs"></div>
                </div>
            </div>
            <div class="tab-pane " aria-labelledby="tabs-3" id="tabs-3" role="tabpanel">
                <div class="row">
                    <div class="col-md-6">
                        <div class="datadiv">
                            <h3>Career & Placements</h3>
                            <p>AAFT provides a strong commitment and assurance for employment prospects upon completion of your academic programs. We have developed strong alliances with numerous industrial partners.</p>
                            <p>We organize job fairs and offer career counseling services to improve students' prospects for employment (more on EDGE and CARE). We provide training to students to ensure their abilities are in line with the expectations of the industry.</p>
                        </div>
                    </div>
                    <div class="col-md-6"> <img src="images/photography-tabimage3.jpg" alt="Skills Acquisition" class="img-fluid r-30 hidden-xs"></div>
                </div>
            </div>
        </div>

    </div>

</section>
      <section class="about-section pading-top">
    <div class="container">
        <div class="row">
            <div class="faqnewdesign">
                <h3>Curriculum <span>Breakdown</span></h3>
                <div class="accordion" id="accordionExample">

                    <!-- Item 1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne">
        <button class="accordion-button" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">
          Semester 1: Fundamentals of Photography
          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseOne" class="accordion-collapse collapse show" aria-labelledby="headingOne" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <ul>
<li>History of Photography</li>
<li>Elements of Photography</li>
<li>Art and Composition in Photography</li>
<li>Still Life Photography</li>
<li>Introduction to Photojournalism</li>
</ul>
                            </div>
                        </div>
                    </div>

                    <!-- Item 2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
          Semester 2: Introduction to the Genres of Photography 

          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseTwo" class="accordion-collapse collapse" aria-labelledby="headingTwo" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <ul>
<li>Theory of Light</li>
<li>Lens and Optics in Photography</li>
<li>Marketing Management</li>
<li>Basics of Editing </li>
<li>Fundamentals of Visual Theory</li>
</ul>
                            </div>
                        </div>
                    </div>

                    <!-- Item 3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
          data-bs-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
          Semester 3: Basics of Photography  

          <div class="indicator"><div></div><div></div></div>
        </button>
      </h2>
                        <div id="collapseThree" class="accordion-collapse collapse" aria-labelledby="headingThree" data-bs-parent="#accordionExample">
                            <div class="accordion-body">
                                <ul>
<li>Digital Video - I</li>
<li>Color Science</li>
<li>Introduction to Fashion Photography</li>
<li>Introduction to Food Photography</li>
<li>Elementary Designing and Layouting </li>
<li>Advance Image Editing</li>
</ul>
                            </div>
                        </div>
                    </div>
                    <!-- Item 4 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingFour">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
      Semester 4: Advance Designing and Layouting 

      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseFour" class="accordion-collapse collapse" aria-labelledby="headingFour" data-bs-parent="#accordionExample">
    <div class="accordion-body">
      <ul>
<li>Digital Video - II</li>
<li>Entrepreneurship</li>
<li>Advance Designing and Layouting </li>
<li>Video Editing </li>
<li>Advertising Photography</li>
</ul>
    </div>
  </div>
</div>

<!-- Item 5 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingFive">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseFive" aria-expanded="false" aria-controls="collapseFive">
      Semester 5: Research Methodology

      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseFive" class="accordion-collapse collapse" aria-labelledby="headingFive" data-bs-parent="#accordionExample">
    <div class="accordion-body">
      <ul>
<li>Creative Motion Graphics</li>
<li>Architecture and Interior Photography</li>
<li>Photo Development and Stories</li>
<li>Fine Art Photography</li>
</ul>
    </div>
  </div>
</div>

<!-- Item 6 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingSix">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseSix" aria-expanded="false" aria-controls="collapseSix">
      Semester 6: Graduation Project

      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseSix" class="accordion-collapse collapse" aria-labelledby="headingSix" data-bs-parent="#accordionExample">
    <div class="accordion-body">
      <ul>
<li>Dissertation Project </li>
<li>Final Project Submission (Fashion)</li>
<li>Final Project Submission (Commercial / Product)</li>
<li>Final Project Submission (Creative)</li>
</ul>
    </div>
  </div>
</div>

                </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section mob-pad">
        <div class="container">
          <div class="row">
            <div class="faqnewdesign second-design">
            <h3>Specialization Curriculum Breakdown:  <span>Cinematography Focus</span></h3>
            <div class="accordion" id="accordionExample1">

              <!-- Item 1 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingOne1">
                  <button class="accordion-button" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseOne1" aria-expanded="true" aria-controls="collapseOne1">
                    Semester I: Foundations of Photography & Visual Communication
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseOne1" class="accordion-collapse collapse show" aria-labelledby="headingOne1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    <ul>
                      <li>	Basics of Camera Operation</li>
                      <li>	Introduction to Lighting</li>
                      <li>	Visual Storytelling Concepts</li>
                    </ul>
                  </div>
                </div>
              </div>

              <!-- Item 2 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingTwo1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseTwo1" aria-expanded="false" aria-controls="collapseTwo1">
                    Semester II: Mastering Camera & Lighting Techniques
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseTwo1" class="accordion-collapse collapse" aria-labelledby="headingTwo1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    <ul>
                      <li>	Cinematography Terminology</li>
                      <li>	Framing & Camera Angles</li>
                      <li>	Set Lighting Techniques</li>
                    </ul>
                  </div>
                </div>
              </div>

              <!-- Item 3 -->
              <div class="accordion-item">
                <h2 class="accordion-header" id="headingThree1">
                  <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#collapseThree1" aria-expanded="false" aria-controls="collapseThree1">
                    Semester III: Cinematography Essentials
                    <div class="indicator"><div></div><div></div></div>
                  </button>
                </h2>
                <div id="collapseThree1" class="accordion-collapse collapse" aria-labelledby="headingThree1"
                  data-bs-parent="#accordionExample1">
                  <div class="accordion-body">
                    <ul>
                      <li>Exposure & Composition Techniques</li>
                      <li>Camera Lenses & Digital Imaging</li>
                      <li>Understanding the Third Dimension</li>
                    </ul>
                  </div>
                </div>
              </div>
              <!-- Item 4 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingFour1">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseFour1" aria-expanded="false" aria-controls="collapseFour1">
      Semester IV: Advanced Cinematography & Storytelling
      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseFour1" class="accordion-collapse collapse" aria-labelledby="headingFour1"
    data-bs-parent="#accordionExample1">
    <div class="accordion-body">
      <ul>
        <li>	Method Acting Fundamentals</li>
        <li>	Camera Movements & Continuity</li>
        <li>	Practical Film Shooting & Cutting Techniques</li>
      </ul>
    </div>
  </div>
</div>

<!-- Item 5 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingFive1">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseFive1" aria-expanded="false" aria-controls="collapseFive1">
      Semester V: Digital Techniques & Film Set Operations
      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseFive1" class="accordion-collapse collapse" aria-labelledby="headingFive1"
    data-bs-parent="#accordionExample1">
    <div class="accordion-body">
      <ul>
        <li>	3-Point Lighting Setup</li>
        <li>	Digital Imaging Techniques</li>
        <li>	Documentary, Music Video, & Short Film Production</li>
      </ul>
    </div>
  </div>
</div>

<!-- Item 6 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingSix1">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseSix1" aria-expanded="false" aria-controls="collapseSix1">
      Semester VI: Final Project
      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseSix1" class="accordion-collapse collapse" aria-labelledby="headingSix1"
    data-bs-parent="#accordionExample1">
    <div class="accordion-body">
      <ul>
        <li>	Showreel Creation: Showcase Your Work</li>
        <li>	Collaborative Final Film Project: Fiction & Non-Fiction</li>
      </ul>
    </div>
  </div>
</div>

            </div>
          </div>
          </div>
        </div>
      </section>
      <section class="about-section accadmic-prectice">
    <div class="container">
        <div class="row">
            <div class="col-md-12 text-left">
                <h3>Academic Practices</h3>
                <p>The B.Sc. (Cinematography) pathway is designed for students who wish to deepen their understanding of the Film and TV industry. While building on existing filmmaking skill students will focus on refining their cinematography expertise,
                    helping you become the best in your craft and create an exceptional body of work.</p>
            </div>
            <!-- <div class="col-md-3">
                <form class="yearfield">
                    <select aria-label="Degree Year" class="form-control" name="degree" aria-label="Degree Year">
                        <option value="">Degree Year 01</option>
                        <option value="Degree Year 01">Degree Year 01</option>
                        <option value="Degree Year 01">Degree Year 01</option>

                    </select>
                    <i class="fa fa-angle-down" aria-hidden="true"></i>
                </form>
            </div> -->
        </div>
    </div>
</section>
<section class="about-section accadmic-tab">
    <div class="container new-bg-black">
        <div class="row  ">
            <div class="col-md-12 text-left">
                <ul class="nav nav-tabs">
                    <li class="nav-item"><a class="nav-link active" data-bs-toggle="tab" href="#tabs-11" role="tab">LEARNING<br> OUTCOMES</a></li>
                    <li class="nav-item"><a class="nav-link " data-bs-toggle="tab" href="#tabs-21" role="tab">PRACTICAL<br> LEARNING</a></li>
                    <!-- <li class="nav-item"><a class="nav-link " data-bs-toggle="tab" href="#tabs-31" role="tab">Specialised <br>Learning</a></li> -->

                </ul>
                <div class="tab-content">
                    <div class="tab-pane active" aria-labelledby="tabs-11" id="tabs-11" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample2">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne2">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseOne2" aria-expanded="true" aria-controls="collapseOne2">
                                                 1. History of Photography


                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseOne2" class="accordion-collapse collapse " aria-labelledby="headingOne2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Learn about the evolution of photography in the 19th century</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo2">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo2" aria-expanded="false" aria-controls="collapseTwo2">
                                                2. Principles of Photography
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo2" class="accordion-collapse collapse" aria-labelledby="headingTwo2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Learn to capture photography and its principles</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree2">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree2" aria-expanded="false" aria-controls="collapseThree2">
                                                3. Modern Media and Visual Storytelling


                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree2" class="accordion-collapse collapse" aria-labelledby="headingThree2" data-bs-parent="#accordionExample2">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Understand the newsroom culture, photojournalism and creative advertising </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                       

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample3">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne3">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseOne3" aria-expanded="true" aria-controls="collapseOne3">
                                                 4. Importance of Lighting


                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseOne3" class="accordion-collapse collapse " aria-labelledby="headingOne3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                    <ul>
        <li>Explore the fundamentals of lighting for museums / gallery shows</li>
      </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo3">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo3" aria-expanded="false" aria-controls="collapseTwo3">
                                                5. Advanced Video Production
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo3" class="accordion-collapse collapse" aria-labelledby="headingTwo3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                    <ul>
        <li>Learn about motion graphic techniques and basic logo animation</li>
      </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree3">
                                                <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                  data-bs-target="#collapseThree3" aria-expanded="false" aria-controls="collapseThree3">
                                                   6. Fundamentals of Media Market Research

                                                  <div class="indicator"><div></div><div></div></div>
                                                </button>
                                              </h2>
                                            <div id="collapseThree3" class="accordion-collapse collapse" aria-labelledby="headingThree3" data-bs-parent="#accordionExample3">
                                                <div class="accordion-body">
                                                   <ul>
        <li>Graduation Project</li>
      </ul>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                            
                    <div class="tab-pane " aria-labelledby="tabs-21" id="tabs-21" role="tabpanel">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample21">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOne21" aria-expanded="true" aria-controls="collapseOne21">
                                                1. Project 1

                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseOne21" class="accordion-collapse collapse" aria-labelledby="headingOne21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Introduction to photography and depth of field</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo21" aria-expanded="false" aria-controls="collapseTwo21">
                                                2. Project 2
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo21" class="accordion-collapse collapse" aria-labelledby="headingTwo21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Understanding different setups and lighting </li>
                                                    </ul>


                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree21" aria-expanded="false" aria-controls="collapseThree21">
                                                3. Project 3

                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree21" class="accordion-collapse collapse" aria-labelledby="headingThree21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li> Practicing lightroom tools, presets, color and image correction</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
<div class="accordion-item">
                                            <h2 class="accordion-header" id="headingFour21">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseFour21" aria-expanded="false" aria-controls="collapseFour21">
                                                4. Project 4

                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseFour21" class="accordion-collapse collapse" aria-labelledby="headingFour21" data-bs-parent="#accordionExample21">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Learn to capture dramatic moments </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="datadiv">
                                    <div class="accordion" id="accordionExample31">

                                        <!-- Item 1 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingOne31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseOne31" aria-expanded="true" aria-controls="collapseOne31">
                                                5. Project 5
                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseOne31" class="accordion-collapse collapse " aria-labelledby="headingOne31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Case study of corporate digital campaign </li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 2 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingTwo31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseTwo31" aria-expanded="false" aria-controls="collapseTwo31">
                                                6. Project 6

                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseTwo31" class="accordion-collapse collapse" aria-labelledby="headingTwo31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Learn the basics of food photography</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Item 3 -->
                                        <div class="accordion-item">
                                            <h2 class="accordion-header" id="headingThree31">
                                              <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                                                data-bs-target="#collapseThree31" aria-expanded="false" aria-controls="collapseThree31">
                                                7. Project 7

                                                <div class="indicator"><div></div><div></div></div>
                                              </button>
                                            </h2>
                                            <div id="collapseThree31" class="accordion-collapse collapse" aria-labelledby="headingThree31" data-bs-parent="#accordionExample31">
                                                <div class="accordion-body">
                                                    <ul>
                                                      <li>Shooting for a fashion campaign</li>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                       </div>

                       

                </div>

            </div>
        </div>
</section>
      <section class="about-section videoslider">
    <div class="container">
        <div class="row">

            <h3>Project <span>Videos</span></h3>
            <div class="four-item owl-carousel owl-theme">
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
                <div class="item">
                    <a href="#" data-bs-toggle="modal" data-bs-target="#iframeModal">
                        <img src="images/youtube-thumb.jpg" alt="" />
                        <h4>Shivani</h4>
                        <p>Bsc. in Cinema</p>
                    </a>
                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section gallerysec">


    <h3>Life at <span>School of Cinema</span></h3>
    <div id="six-item1" class="owl-carousel owl-theme">
        <div class="item">
            <Image src="images/photography-gallery1.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery2.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery3.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery4.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery5.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery6.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery7.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery8.jpg" alt="" />
        </div>
        <!-- <div class="item">
            <Image src="images/photography-gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div> -->
    </div>
    <div id="six-item2" class="owl-carousel owl-theme">
        <div class="item">
            <Image src="images/photography-gallery9.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery10.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery11.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery12.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery13.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery14.jpg" alt="" />
        </div>
        <div class="item">
            <Image src="images/photography-gallery15.jpg" alt="" />
        </div>
        <!-- <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery1.png" alt="" />
        </div>
        <div class="item">
            <Image src="images/gallery2.png" alt="" />
        </div> -->
    </div>



</section>
      <section class="about-section accadmic-prectice" id="infrastructure">
        <div class="container">
        <div class="row justify-content-center">
          <h3>Infrastructure</h3>
             <div  class="three-item owl-carousel owl-theme">
        <div class="item">
                <div class="career-card">
                  <img src="images/photography-infra1.jpg" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">High End Camera & Production Equipments</h4>
                    
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="career-card">
                  <img src="images/photography-infra2.jpg" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">Chroma Set & Enabled Studios</h4>
                    
                  </div>
                </div>
              </div>
              <div class="item">
                <div class="career-card">
                  <img src="images/photography-infra3.jpg" alt="Skills Acquisition" class="img-fluid" width={500} height={100} />
                  <div class="card-content">
                    <h4 class="card-title">Industry Level Lighting Set-Ups</h4>
                    
                  </div>
                </div>
              </div>
              </div>
          </div>
          </section>
          <section class="about-section application-info mrpading">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Learn from <span>Industry Veterans</span></h3>
                <p class="about-subtext">AAFT Boats of a highly qualified and experiences team of professor who hold impeccable industrial acumen after having led successful careers in their respective fields.</p>
            </div>
        </div>
        <div class="row justify-content-center">
            <div class="col-6 col-md-6">
                <div class="learndata">
                    <a href="">
                        <button class="squre">Industry Dean</button>
                    </a>
                    <h2>Ms. SWARA BHASKAR</h2>
                    <p class="hidden-xs">Swara Bhasker, an Indian actress has joined AAFT as the Industry Dean of the School of Drama & Acting. Best known for her supporting work in mainstream productions and starring roles in independent films, she has won two Screen Awards
                        and has received four Filmfare Award nominations. Bhasker garnered widespread recognition from critics and audiences with a supporting role in the 2011's commercially successful romantic comedy-drama Tanu Weds Manu.</p>

                </div>
            </div>
            <div class="col-6 col-md-6">
                <div class="learndata"><img src="images/swara-bhaskar.png" alt="Laurel" class="laurel img-fluid" />
                <p class="visible-xs">Swara Bhasker, an Indian actress has joined AAFT as the Industry Dean of the School of Drama & Acting. Best known for her supporting work in mainstream productions and starring roles in independent films, she has won two Screen Awards
                        and has received four Filmfare Award nominations. Bhasker garnered widespread recognition from critics and audiences with a supporting role in the 2011's commercially successful romantic comedy-drama Tanu Weds Manu.</p>
                      </div>

            </div>
            <div  class="fornew-item owl-carousel owl-theme">
        <div class="item">
                <div class="learnotherdata">
                    <img src="images/team1.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Dr. Shivani Dappe</h4>
                        <p>Dean (School of Cinema)</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team2.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Mr. Ashok Dhingra</h4>
                        <p>Mr. Ashok Dhingra</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team3.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Ms. Kirti</h4>
                        <p>Assistant Professor</p>
                    </div>
                </div>
            </div>
             <div class="item">
                <div class="learnotherdata">

                    <img src="images/team4.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="abso">
                        <h4>Ankit Saroha</h4>
                        <p>Dean (School of Cinema)</p>
                    </div>
                </div>
              </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section application-info meet-our-alumini">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Meet Our <span>ALUMNI</span></h3>

            </div>
        </div>
        <div class="row justify-content-left row-reves">
            <div class="col-6 col-md-12">
                <div class="learndata1">
                    <div id="one-item" class="owl-carousel owl-theme">
                        <div class="item row">
<div class="col-6 col-md-6">
                            <a href="">
                                <button class="squre">Mrigdeep S. Lamba</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Fukrey</p>
                            <p>- Fukrey Returns</p>
                            <p>- Roohi</p>
</div>
<div class="col-6 col-md-6">
 <div class="learndataimage"><img src="images/alumni1.png" alt="Laurel" class="laurel img-fluid" /></div>
</div>
                        </div>
<div class="item row">
<div class="col-6 col-md-6">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
</div>
<div class="col-6 col-md-6">
 <div class="learndataimage"><img src="images/alumni2.png" alt="Laurel" class="laurel img-fluid" /></div>
</div>
                        </div>
<div class="item row">
<div class="col-6 col-md-6">
                            <a href="">
                                <button class="squre">Gurmeet Singh</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Mirzapur (2018-2024)</p>
                            <p>- Inside Edge (2017-2019)</p>
                            <p>- Phone Bhoot (2022)</p>
</div>
<div class="col-6 col-md-6">
 <div class="learndataimage"><img src="images/alumni3.jpg" alt="Laurel" class="laurel img-fluid" /></div>
</div>
                        </div>
                        <!-- <div class="item">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
                        </div>
                        <div class="item">
                            <a href="">
                                <button class="squre">Luv Ranjan</button> <span>Film Director,<br> Writer</span></a>

                            <p>- Tu Jhuti, Mai Makkaar</p>
                            <p>- Sonu Ke Titu Ki Sweety</p>
                            <p>- Pyaar Ka Punchnama Series</p>
                            <p>- Aakaash Vani</p>
                        </div> -->
                    </div>


                </div>
            </div>
           
        </div>
    </div>
</section>
      <section class="about-section accadmic-prectice success-stories mpading">
    <div class="container">
        <div class="row justify-content-center pb-3">
            <h3><span class="colorblack">Success Stories</span> </h3>
           <div  class="fornew1-item owl-carousel owl-theme">
        <div class="item">
                <div class="learnotherdata">
                    <img src="images/story-image.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon1.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Prathmesh<br/> Kumbhare</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
           <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image2.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon2.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Ajay <br/>Dubey</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
            <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image3.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon3.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Akash K.<br/> Mathur</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
            </div>
            <div class="item">
                <div class="learnotherdata">

                    <img src="images/story-image4.png" alt="Laurel" class="laurel img-fluid" />
                    <div class="absoimage">
                        <img src="images/story-icon4.png" alt="Laurel" class="laurel img-fluid" />
                    </div>
                    <div class="absonew">
                        <h4>Dhruv <br/>Sethi</h4>
                        <p>CINEMATOGRAPHER</p>
                    </div>
                </div>
              </div>
            </div>
        </div>
        <div class="row justify-content-center pt-5">
            <h3>Students <span class="colorblack">Feedback</span> </h3>
            <div class="four-item1 owl-carousel owl-theme">
                <div class="item">
                    <div class='review-box'>
			<p>
			
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>
			</p>
                        <p>B.A. in Professional Photography</p>
                        <p><span>AAFT School of Photography gave me more than just technical knowledge—it shaped my creative eye. From live shoots to exhibitions, every assignment pushed me closer to becoming a professional photographer.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Shally</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
<p>
			
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>
			</p>
                        <p>B.A. in Professional Photography</p>
                        <p><span>The hands-on experience at AAFT is unmatched. We don’t just learn theory—we shoot in real-world settings, build portfolios, and even work on client briefs. I feel career-ready already!</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Haider</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
<p>
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>
   			<i class="fa fa-star" aria-hidden="true"></i>
			<i class="fa fa-star" aria-hidden="true"></i>

			</p>
                        <p>B.A. in Professional Photography</p>
                        <p><span>AAFT has helped me reshape my carrier in cinematography and direction. With their equipment and support, finding career opportunities became easier than ever.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Teena </b></p>
                    </div>
                </div>
                <!-- <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>The best part about studying photography at AAFT is the constant industry exposure. Masterclasses with leading photographers, workshops on editing tools, and constructive feedback helped me grow with every click.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div>
                <div class="item">
                    <div class='review-box'>
                        <p>B.Sc Cinema</p>
                        <p><span>I had an amazing collage experience with AAFT. The tools I learned in my time here has helped me get good offers from production houses and agencies too.</span></p>
                        <p class='d-flex'>
                            <Image src="images/user.png" alt="Laurel" class="laurel " width={33} height={33} /> <b>Paarth</b></p>
                    </div>
                </div> -->
            </div>
        </div>
    </div>
</section>
          <section class="about-section application-info mtext-center">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-10 offset-md-1">
                <h3>Who Can <span>Apply?</span></h3>
                <p class="about-subtext">We attract exceptional candidates who possess a blend of intellectual curiosity, leadership potential and a passion for music, thereby creating a cohort of promising future leaders.</p>
            </div>
        </div>
        <div class="row justify-content-center">
            <h4 class="mb-5">Eligibility Criteria</h4>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate must have a 10+2 from a recognized university/institution</p>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate must have a minimum of 50% marks in 10+2 (45% for reserved categories)</p>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="criteriabox">
                    <img src="images/check-icon.png" alt="Laurel" class="check-icon" width={57} height={57} />
                    <p>Candidate need to clear the AAFT Global Entrance Test (GET)</p>

                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section steptoapply" id="steps-to-apply">
    <div class="container">
        <div class="row justify-content-center">

            <h3>Step to <span>Apply?</span></h3>

            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>01</span>
                    <div>
                        <h4>Application Form</h4>
                        <p>Candidate must have a 10+2 from a recognized university/institution</p>
                    </div>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>02</span>
                    <div>
                        <h4>Personal Interview</h4>
                        <p>A personal interview will be conducted to screen your application.</p>
                    </div>

                </div>
            </div>
            <div class="col-6 col-md-4">
                <div class="applybox">
                    <span>03</span>
                    <div>
                        <h4>Offer of Admission</h4>
                        <p>Post the admission round, the admission letter will be rolled out to the selected candidates.</p>
                    </div>

                </div>
            </div>

        </div>
    </div>
</section>
      <section class="about-section bookacall">
    <div class="container">
        <div class="row justify-content-center">
            <div class="bookcallbox">
                <img src="images/book-call-bg.png" alt="Laurel" class="img-fluid hidden-xs" />
<img src="images/book-call-bg-mobile.png" alt="Laurel" class="img-fluid visible-xs" />

                <div>
                    <h4>Let's Get<br/> You Onboard!</h4>
                    <a href="">
                        <button class="squre"><img
              src="images/call-image.png" alt="logo" class="img-fluid"
            /> BOOK A 1:1 CALL</button>
                    </a>
                </div>



            </div>
        </div>

    </div>

</section>
      <section class="about-section pb-0" id="faq">
    <div class="container">
        <div class="row">
            <div class="faqnewdesign second-design">
                <h3>Frequently Asked <span>Question!</span></h3>
                <div class="accordion" id="accordionExample4">

                    <!-- Item 1 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingOne4">
                            <button class="accordion-button" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseOne4" aria-expanded="true" aria-controls="collapseOne4">
                              
                                    1.	What is the eligibility criteria for a photography UG degree? 
                                    
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseOne4" class="accordion-collapse collapse show" aria-labelledby="headingOne4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                               Ans.: Students who have passed or will appear for higher secondary (10+2) from any recognized Board of Education such as CBSE / ICSE / IGCSE / IB or State Board, can apply for admission to the UG course in photography. 
                            </div>
                        </div>
                    </div>

                    <!-- Item 2 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingTwo4">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseTwo4" aria-expanded="false" aria-controls="collapseTwo4">
                              
                                   2.	What is the duration of BA in still photography course? 
                                    
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseTwo4" class="accordion-collapse collapse" aria-labelledby="headingTwo4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                                <p>Ans.: The duration of the UG degree in photography is 3 years.</p>
                            </div>
                        </div>
                    </div>

                    <!-- Item 3 -->
                    <div class="accordion-item">
                        <h2 class="accordion-header" id="headingThree4">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
                              data-bs-target="#collapseThree4" aria-expanded="false" aria-controls="collapseThree4">
                              
                                    3.	How to apply for an under graduate degree in photography?
                                    
                              <div class="indicator"><div></div><div></div></div>
                            </button>
                          </h2>
                        <div id="collapseThree4" class="accordion-collapse collapse" aria-labelledby="headingThree4" data-bs-parent="#accordionExample4">
                            <div class="accordion-body">
                                <p> Ans.: To apply for admission in the undergraduate photography course in cinema, just submit the duly filled application along with the mandatory documents. The application form can be downloaded online () or collected in person from the campus. </p>
                                        <p>The administration department is open 6 days a week (Monday to Saturday) from 10:00 AM to 06:00 PM. You can give us a call at 09811014536, 09811013654, 0120-4831100. <br>To know more about the admission process at AAFT, visit our website <a href="https://aaft.com/apply-now">https://aaft.com/apply-now</a> </p>
                            </div>
                        </div>
                    </div>
                    <!-- Item 4 -->
<div class="accordion-item">
  <h2 class="accordion-header" id="headingFour4">
    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse"
      data-bs-target="#collapseFour4" aria-expanded="false" aria-controls="collapseFour4">
      
                                4.	What are the career opportunities after completing a bachelors in photography?
                                    
      <div class="indicator"><div></div><div></div></div>
    </button>
  </h2>
  <div id="collapseFour4" class="accordion-collapse collapse" aria-labelledby="headingFour4" data-bs-parent="#accordionExample4">
    <div class="accordion-body">
      <ul>
											<li>Commercial photographers </li>
											<li>Photojournalists </li>
                                            <li>Street photographers</li>
                                            <li>Food photographers</li>
                                            <li>Landscape photographers</li>
											<li>Fashion Photographers</li>
											<li>Event Photographers</li>
											<li>Digital Photo Editors</li>
											<li>Videographers</li>
											<li>Wildlife Photographer </li>
											<li>Aerial Photographer  </li>
											<li>Photography Educator</li>
										</ul>
    </div>
  </div>
</div>


                </div>
            </div>
        </div>
    </div>
</section>
      <section class="about-section courselanding">
    <div class="container">
        <div class="offset-md-1 col-md-10">
            <h3>Related <span> Course</span></h3>
        </div>
        <div class="row justify-content-center">
            <div class="two-item owl-carousel owl-theme">
                <div class="item">
                    <div class="career-card">
                        <Image src="images/photography-cinema-career1.jpg" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Direction <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
                <div class="item">
                    <div class="career-card">
                        <Image src="images/photography-cinema-career2.jpg" alt="Career Trajectory" class="img-fluid" width={500} height={100} />
                        <div class="card-content">
                            <div class="card-title"><a>Specialization in Post Production <img src="images/long-right.png" alt="Laurel" class="img-fluid" /></a></div>

                        </div>
                    </div>
                </div>
 
                
            </div>
        </div>
    </div>
</section>
<footer class="next-step-section  text-center ">
  <div class="container">
    <div class="row">
    <h3 class="mb-5">Next Step</h3>

    <!-- Buttons Row -->
    <div class="row next-step-buttons mb-3">
      <div class="col-md-4">
        <a href="#" class="btn" data-bs-toggle="modal" data-bs-target="#virtualtour1">
          <span><img src="images/vitual-tour.png" alt="Laurel" class="img-fluid" />Take Virtual Tour</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
      <div class="col-md-4">
        <a href="#book" class="btn">
          <span><img src="images/book-a-visit.png" alt="Laurel" class="img-fluid" />Book a Visit</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
      <div class="col-md-4">
        <a href="https://stg.weaddo.live/aaftcms/public/images/cinema.pdf" target="_blank" class="btn">
          <span><img
              src="images/mailicon.png" alt="logo" class="img-fluid"
            />Download Brochure</span>
          <img src="images/long-right.png" alt="Laurel" class="img-fluid" />
        </a>
      </div>
    </div>

    <!-- Info Row -->
    <div class="row text-start mt-2 pt-3 align-items-start bordertop">
      <div class="col-md-4 map-container">
        <iframe
          src="https://www.google.com/maps/embed/v1/place?q=FC+14%2F15,+Film+City,+Sector+16A,+Noida,+Uttar+Pradesh+201301&key=AIzaSyDhOPKoDbaRE_QIuTpVqWZVJnXU3osiuj4"
          allowfullscreen="" loading="lazy">
        </iframe>
        <img src="images/aaftlogo.png" alt="AAFT Logo" class="img-fluid logo mt-3" width="100">
      </div>
      <div class="col-md-4 office-info">
        <h6>Admission Office</h6>
        <p>FC 14/15, Film City,<br>Sector 16A, Noida,<br>Uttar Pradesh 201301</p>
      </div>
      <div class="col-md-4 office-info">
        <h6>University Campus</h6>
        <p>AAFT University, Vill. Manth,<br>Kharora, District – Raipur,<br>Chhattisgarh – 493225</p>
      </div>
    </div>
    </div>
    </div>
  </section>
<div class="modal fade" id="iframeModal" tabindex="-1" aria-labelledby="iframeModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
       
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="stopIframe()"></button>
      </div>
      <div class="modal-body">
        <div class="responsive-iframe">
          <iframe id="iframeContent" src="https://www.youtube.com/embed/zSzzQbzpTcE?si=fHR4wxVTdulESf22" allowfullscreen></iframe>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="virtualtour" tabindex="-1" aria-labelledby="virtualtourLabel" aria-hidden="true">
  <div class="modal-dialog modal-xl modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
       
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close" onclick="stopIframe()"></button>
      </div>
      <div class="modal-body">
        <div class="responsive-iframe">
          <video width="320" height="320" controls>
  <source src="images/imagesvirtual-tour.mp4" type="video/mp4">
  <source src="images/imagesvirtual-tour.ogg" type="video/ogg">
</video>
        </div>
      </div>
    </div>
  </div>
</div>
    </main>
    
   <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
<!-- Popper.js -->
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js"></script>
<!-- Bootstrap JS -->

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css"/>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css"/>
<!-- jQuery & Owl Carousel JS -->
<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js"></script>
<!-- YouTube IFrame API -->
<!-- YouTube API -->
<script>
 $("#six-item").owlCarousel({
            items: 7,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 3.2,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 4
                  },
                  768: {
                    items: 5.2,
                    margin: 10,
                  },
                  1025: {
                    items: 7.1
                  }
                }
          });
 $("#six-item1").owlCarousel({
            items: 4,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            stagePadding: 60,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    margin:10,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                 768: {
                    items: 3.7,
                    margin: 10,
                  },
                  1025: {
                    items: 4.8
                  },
                  1205: {
                    items: 5.2
                  },
                  1400: {
                    items: 6.4
                  }
                }
          });
 $("#six-item2").owlCarousel({
          items: 4,
            loop: true,
            autoplay: true,
            rtl: true,
            autoplaySpeed: 2000,
            stagePadding: 60,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    margin:10,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                 768: {
                    items: 3.7,
                    margin: 10,
                  },
                  1025: {
                    items: 4.8
                  },
                  1205: {
                    items: 5.2
                  },
                  1400: {
                    items: 6.4
                  }
                }
          });
 $("#one-item").owlCarousel({
            items: 4,
            loop: false,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: true,
            nav: false,
            margin:20,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                    dots: false,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 1
                  },
                  768: {
                    items: 1
                  },
                  992: {
                    items: 1
                  }
                }
          });

  $(".fornew-item").owlCarousel({
            items: 3,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1.3,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  1025: {
                    items: 4
                  }
                }
          });
 $(".fornew1-item").owlCarousel({
            items: 3,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:0,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  1025: {
                    items: 4
                  }
                }
          });
  $(".three-item").owlCarousel({
            items: 3,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 2
                  },
                  992: {
                    items: 3
                  }
                }
          });
 $(".fornew-item").owlCarousel({
            items: 3,
            loop: true,
            autoplay: true,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: false,
            margin:15,
            autoplayHoverPause: true,
            responsive: {
                  0: {
                    items: 1.2,
                    autoplaySpeed: 1000,
                     dots: true,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  992: {
                    items: 4
                  }
                }
          });
</script>

      <script>
        $(document).ready(function(){
         
          $(".four-item").owlCarousel({
            items: 4,
            loop: true,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: false,
            nav: true,
            margin:30,
            autoplayHoverPause: true,
             navText: [
                      '<img src="images/left-arrow.png" alt="Prev" style="width: 24px;">',
                      '<img src="images/right-arrow.png" alt="Next" style="width: 24px;">'
                    ],
            responsive: {
                  0: {
                    items: 1.2,
                    autoplay: true,
                    autoplaySpeed: 1000,
                    nav: false,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 3
                  },
                  992: {
                    items: 4
                  }
                }
          });
          $(".four-item1").owlCarousel({
            items: 4,
            loop: true,
            autoplay: false,
            autoplaySpeed: 2000,
            smartSpeed: 3000,   
            dots: true,
            nav: false,
            margin:30,
            autoplayHoverPause: true,
             navText: [
                      '<img src="images/left-arrow.png" alt="Prev" style="width: 24px;">',
                      '<img src="images/right-arrow.png" alt="Next" style="width: 24px;">'
                    ],
            responsive: {
                  0: {
                    items: 1,
                    autoplaySpeed: 1000,
                    smartSpeed: 1000
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 2
                  },
                  1025: {
                    items: 3
                  }
                }
          });
          $(".two-item").owlCarousel({
            items: 2,
            loop: true,
            autoplay: true,
            autoplaySpeed: 1000,
            smartSpeed: 1000,   
            dots: false,
            nav: true,
            margin:20,
            autoplayHoverPause: true,
            navText: [
                      '<i class="fa fa-angle-left" aria-hidden="true"></i>',
                      '<i class="fa fa-angle-right" aria-hidden="true"></i>'
                    ],
                    responsive: {
                  0: {
                    items: 1
                  },
                  576: {
                    items: 2
                  },
                  768: {
                    items: 2
                  },
                  992: {
                    items: 2
                  }
                }
          });
        });


</script>
<script>
        new WOW().init();
</script>
<script>
  // Listen for collapse show event in accordionExample3
  document.querySelectorAll('#accordionExample3 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample2 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });


  document.querySelectorAll('#accordionExample2 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample3 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });
   document.querySelectorAll('#accordionExample31 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample21 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });
   document.querySelectorAll('#accordionExample32 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample22 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });


  document.querySelectorAll('#accordionExample21 .accordion-collapse').forEach((el) => {
    el.addEventListener('show.bs.collapse', function () {
      // Collapse all shown items inside accordionExample2
      const openItems = document.querySelectorAll('#accordionExample31 .accordion-collapse.show');
      openItems.forEach(item => {
        new bootstrap.Collapse(item, {
          toggle: true
        });
      });
    });
  });
</script>
<script>
const menuToggle = document.querySelector('#menuToggle');
const navButtons = document.getElementById('navButtons');

menuToggle.addEventListener('click', function (e) {
  e.stopPropagation(); // Prevent event bubbling to document
  this.classList.toggle('active');
  navButtons.classList.toggle('show');
});

document.addEventListener('click', function (e) {
  // If click is outside navButtons and menuToggle
  if (!navButtons.contains(e.target) && !menuToggle.contains(e.target)) {
    navButtons.classList.remove('show');
    menuToggle.classList.remove('active');
  }
});
document.querySelectorAll('a').forEach(link => {
  link.addEventListener('click', function () {
    navButtons.classList.remove('show');
    menuToggle.classList.remove('active');
  });
});

</script>
    
      <script>
      $('.modal').each(function(){            
                    var src = $(this).find('iframe').attr('src');        
                    $(this).on('click', function(){            
                        $(this).find('iframe').attr('src', '');            
                        $(this).find('iframe').attr('src', src);        
                    });    
                });
</script>
<script>
  document.querySelectorAll('#navButtons .btn-outline-dark').forEach(button => {
    button.addEventListener('click', function () {
      // Remove 'btn-dark' from all buttons
      document.querySelectorAll('#navButtons .btn-outline-dark').forEach(btn => {
        btn.classList.remove('btn-dark');
      });

      // Add 'btn-dark' to the clicked button
      this.classList.add('btn-dark');
    });
  });
</script>


</body>
</html><?php /**PATH /var/www/stg/aaftcms/resources/views/front/landingpage4.blade.php ENDPATH**/ ?>