<!DOCTYPE html>
<html lang="en">
  <!-- [Head] start -->
  <head>
    <title>Dashboard - Kamdhenu Group</title>
    <!-- [Meta] -->
    <meta charset="utf-8"> 
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="description" content="">
    <meta name="keywords" content="">
    <meta name="author" content="Phoenixcoded">

    <!-- [Favicon] icon -->
    <link rel="icon" href="<?php echo e(asset('/assets/images/favicon.ico')); ?>" type="image/x-icon">
    <!-- data tables css -->
    
    <!-- [Font] Family -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/inter/inter.css')); ?>"
      id="main-font-link" />
    <!-- [Tabler Icons] https://tablericons.com -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/tabler-icons.min.css')); ?>" />
    <!-- [Feather Icons] https://feathericons.com -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/feather.css')); ?>" />
    <!-- [Font Awesome Icons] https://fontawesome.com/icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/fontawesome.css')); ?>" />
    <!-- [Material Icons] https://fonts.google.com/icons -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/fonts/material.css')); ?>" />
    <!-- [Template CSS Files] -->
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/style.css')); ?>" id="main-style-link" />
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/style-preset.css')); ?>" />
    <link rel="stylesheet" href="<?php echo e(asset('/assets/css/plugins/dataTables.bootstrap5.min.css')); ?>">
    <?php echo $__env->yieldContent('style'); ?>
  </head>
  <!-- [Head] end -->
  <!-- [Body] Start -->

  <body data-pc-preset="preset-1" data-pc-sidebar-caption="true"
    data-pc-direction="ltr" data-pc-theme_contrast data-pc-theme="light">
    <!-- [ Pre-loader ] start -->
    <div class="loader-bg">
      <div class="loader-track">
        <div class="loader-fill"></div>
      </div>
    </div>
    <!-- [ Pre-loader ] End -->
    <!-- [ Sidebar Menu ] start -->
    <nav class="pc-sidebar">
      <div class="navbar-wrapper">
        <div class="m-header">
          <a href="<?php echo e(route('dashboard')); ?>" class="b-brand text-primary twst">
            <!-- ======== Change your logo from here   ============ -->
            <img src="<?php echo e(asset('/assets/images/logo.png')); ?>" width="200"/>
            <!-- <span
              class="badge bg-light-success rounded-pill ms-2 theme-version">v9.0</span> -->
          </a>
        </div>
        <div class="navbar-content">
          <div class="card pc-user-card">
            <div class="card-body">
              <div class="d-flex align-items-center">
                <div class="flex-shrink-0">
                  <img src="<?php echo e(asset('/assets/images/user/avatar-11.jpg')); ?>" alt="user-image"
                    class="user-avtar wid-45 rounded-circle" />
                </div>
                <div class="flex-grow-1 ms-3 me-2">
                  <h6 class="mb-0"><?php echo e(Auth::user()->name); ?></h6>
                  <!-- <small>Administrator</small> -->
                </div>
                <!-- <a class="btn btn-icon btn-link-secondary avtar"
                  data-bs-toggle="collapse" href="#pc_sidebar_userlink">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-sort-outline"></use>
                  </svg>
                </a> -->
              </div>
              <!-- <div class="collapse pc-user-links" id="pc_sidebar_userlink">
                <div class="pt-3">
                  <a href="#!">
                    <i class="ti ti-user"></i>
                    <span>My Account</span>
                  </a>
                  <a href="#!">
                    <i class="ti ti-settings"></i>
                    <span>Settings</span>
                  </a>
                  <a href="#!">
                    <i class="ti ti-lock"></i>
                    <span>Lock Screen</span>
                  </a>
                  <a href="#!">
                    <i class="ti ti-power"></i>
                    <span>Logout 3</span>
                  </a>
                </div>
              </div> -->
            </div>
          </div>

          <ul class="pc-navbar">
            <li class="pc-item pc-caption">
              <label>Navigation</label>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="<?php echo e(route('dashboard')); ?>" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-status-up"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Dashboard</span>
              </a>            
            </li>                     


            <li class="pc-item pc-hasmenu">
              <a href="#" class="pc-link">
                <span class="pc-micon"><svg class="pc-icon"><use xlink:href="#custom-document"></use></svg></span>
                <span class="pc-mtext">CMS</span>
                <span class="pc-arrow"><i data-feather="chevron-right"></i></span>
              </a>
              <ul class="pc-submenu">
            
                 <li class="pc-item"><a class="pc-link" href="<?php echo e(route('page')); ?>">  Pages</a></li>   
               <li class="pc-item"><a class="pc-link" href="<?php echo e(route('leads')); ?>">  Leads</a></li>               
                  </ul>
            </li>

            <!-- <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-document"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Blog</span>
                <span class="pc-arrow"><i
                    data-feather="chevron-right"></i></span>
              </a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="<?php echo e(url('/add_blog')); ?>">Add New</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="<?php echo e(url('/view_blog')); ?>">View</a></li>                
              </ul>
            </li>
            <li class="pc-item pc-caption">
              <label>Widget</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-presentation-chart"></use>
              </svg>
            </li>
            <li class="pc-item">
              <a href="./widget/w_statistics.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-story"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Statistics</span>
              </a>
            </li>
            <li class="pc-item">
              <a href="./widget/w_data.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-fatrows"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Data</span>
              </a>
            </li>
            <li class="pc-item">
              <a href="./widget/w_chart.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-presentation-chart"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Chart</span></a>
            </li>
            <li class="pc-item pc-caption">
              <label>UI Components</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-box-1"></use>
              </svg>
            </li>
            <li class="pc-item">
              <a href="./elements/bc_alert.html" class="pc-link"
                target="_blank"><span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-box-1"></use>
                  </svg> </span><span class="pc-mtext">Components</span></a>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link"><span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-mouse-circle"></use>
                  </svg> </span><span class="pc-mtext">Icons</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./elements/icon-feather.html">Feather</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./elements/icon-fontawesome.html">Font Awesome
                    5</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./elements/icon-material.html">Material</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./elements/icon-tabler.html">Tabler</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./elements/icon-custom.html">Custom</a></li>
              </ul>
            </li>
            <li class="pc-item pc-caption">
              <label>Forms</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-element-plus"></use>
              </svg>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-element-plus"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Forms Elements</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form_elements.html">Form Basic</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form_floating.html">Form Floating</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_basic.html">Form Options</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_input_group.html">Input Groups</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_checkbox.html">Checkbox</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_radio.html">Radio</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_switch.html">Switch</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_megaoption.html">Mega option</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-cpu-charge"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Forms Plugins</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item pc-hasmenu">
                  <a class="pc-link" href="#">Date<span class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/form2_datepicker.html">Datepicker</a></li>
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/form2_daterangepicker.html">Date Range
                        Picker</a> </li>
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/form2_timepicker.html">Timepicker</a></li>
                  </ul>
                </li>
                <li class="pc-item pc-hasmenu">
                  <a class="pc-link" href="#">Select<span class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/form2_choices.html">Choices js</a></li>
                  </ul>
                </li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_recaptcha.html">Google
                    reCaptcha</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_inputmask.html">Input Masks</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_clipboard.html">Clipboard</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_nouislider.html">Nouislider</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_switchjs.html">Bootstrap Switch</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_typeahead.html">Typeahead</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-text-block"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Text Editors</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_tinymce.html">Tinymce</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_quill.html">Quill</a></li>
                <li class="pc-item pc-hasmenu">
                  <a class="pc-link" href="#">CK editor<span class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/editor-classic.html">classic</a></li>
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/editor-document.html">Document</a></li>
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/editor-inline.html">Inline</a></li>
                    <li class="pc-item"><a class="pc-link"
                        href="./forms/editor-balloon.html">Balloon</a></li>
                  </ul>
                </li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_markdown.html">Markdown</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-row-vertical"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Form Layouts</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_lay-default.html">Layouts</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_lay-multicolumn.html">Multicolumn</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_lay-actionbars.html">Actionbars</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_lay-stickyactionbars.html">Sticky Action
                    bars</a> </li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-document-upload"></use>
                  </svg>
                </span>
                <span class="pc-mtext">File upload</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./forms/file-upload.html">Dropzone</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./forms/form2_flu-uppy.html">Uppy</a></li>
              </ul>
            </li>
            <li class="pc-item">
              <a href="./forms/form-validation.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-password-check"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Form Validation</span></a>
            </li>
            <li class="pc-item"><a href="./forms/image_crop.html"
                class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-crop"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Image cropper</span></a></li>
            <li class="pc-item pc-caption">
              <label>table</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-text-align-justify-center"></use>
              </svg>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-text-align-justify-center"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Bootstrap Table</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_bootstrap.html">Basic table</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_sizing.html">Sizing table</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_border.html">Border table</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_styling.html">Styling table</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-keyboard"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Vanilla Table</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-simple.html">Basic
                    initialization</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-dynamic-import.html">Dynamic
                    Import</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-render-column-cells.html">Render Column
                    Cells</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-column-manipulation.html">Column
                    Manipulation</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-datetime-sorting.html">Datetime
                    Sorting</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-methods.html">Methods</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-add-rows.html">Add Rows</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-fetch-api.html">Fetch API</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-filters.html">Filters</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/tbl_dt-export.html">Export</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-graph"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Data table</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_advance.html">Advance
                    initialization</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_styling.html">Styling</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_api.html">API</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_plugin.html">Plug-in</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_sources.html">Data sources</a></li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-add-item"></use>
                  </svg>
                </span>
                <span class="pc-mtext">DT extensions</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_autofill.html">Autofill</a></li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Button<span class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link"
                        href="./table/dt_ext_basic_buttons.html">Basic
                        button</a></li>
                    <li class="pc-item"><a class="pc-link"
                        href="./table/dt_ext_export_buttons.html">Data
                        export</a></li>
                  </ul>
                </li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_col_reorder.html">Col reorder</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_fixed_columns.html">Fixed
                    columns</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_fixed_header.html">Fixed
                    header</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_key_table.html">Key table</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_responsive.html">Responsive</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_row_reorder.html">Row reorder</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_scroller.html">Scroller</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./table/dt_ext_select.html">Select table</a></li>
              </ul>
            </li>
            <li class="pc-item pc-caption">
              <label>Charts</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-graph"></use>
              </svg>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-graph"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Charts</span><span class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./chart/chart-apex.html">Apex Chart</a></li>
              </ul>
            </li>
            <li class="pc-item pc-caption">
              <label>Application</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-shopping-bag"></use>
              </svg>
            </li>
            <li class="pc-item">
              <a href="./application/calendar.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-calendar-1"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Calendar</span></a>
            </li>
            <li class="pc-item">
              <a href="./application/chat.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-message-2"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Chat</span></a>
            </li>
            <li class="pc-item">
              <a href="./application/cust_customer_list.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-notification-status"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Customer</span></a>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-shopping-bag"></use>
                  </svg>
                </span>
                <span class="pc-mtext">E-commerce</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./application/ecom_product.html">Product</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./application/ecom_product-details.html">Product
                    details</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./application/ecom_product-list.html">Product
                    List</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./application/ecom_product-add.html">Add New
                    Product</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./application/ecom_checkout.html">Checkout</a></li>
              </ul>
            </li>
            <li class="pc-item">
              <a href="./application/file-manager.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-document-filter"></use>
                  </svg>
                </span>
                <span class="pc-mtext">File manager</span></a>
            </li>
            <li class="pc-item">
              <a href="./application/mail.html" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-direct-inbox"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Mail</span></a>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-user-square"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Users</span><span class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./application/account-profile.html">Account
                    Profile</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./application/social-media.html">Social media</a></li>
              </ul>
            </li>

            <li class="pc-item pc-caption">
              <label>Pages</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-flag"></use>
              </svg>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-shield"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Authentication</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Authentication 1<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/login-v1.html">Login</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/register-v1.html">Register</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/forgot-password-v1.html">Forgot
                        Password</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/check-mail-v1.html">check mail</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/reset-password-v1.html">reset password</a>
                    </li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/code-verification-v1.html">code
                        verification</a></li>
                  </ul>
                </li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Authentication 2<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/login-v2.html">Login</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/register-v2.html">Register</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/forgot-password-v2.html">Forgot
                        password</a> </li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/check-mail-v2.html">check mail</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/reset-password-v2.html">reset password</a>
                    </li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/code-verification-v2.html">code
                        verification</a></li>
                  </ul>
                </li>
                <li class="pc-item">
                  <a href="./pages/login-v3.html" target="_blank"
                    class="pc-link">Authentication 3</a>
                </li>
              </ul>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-flag"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Maintenance</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link" target="_blank"
                    href="./pages/error-404.html">Error 404</a></li>
                <li class="pc-item"><a class="pc-link" target="_blank"
                    href="./pages/error-500.html">Error 500</a></li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Under construction<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/under-construction-v1.html">Under
                        Construction 1</a></li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/under-construction-v2.html">Under
                        Construction 2</a></li>
                  </ul>
                </li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Coming soon<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/coming-soon-v1.html">Coming soon 1</a>
                    </li>
                    <li class="pc-item"><a class="pc-link" target="_blank"
                        href="./pages/coming-soon-v2.html">Coming soon 2</a>
                    </li>
                  </ul>
                </li>
              </ul>
            </li>
            <li class="pc-item"><a href="./pages/contact-us.html"
                class="pc-link" target="_blank">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-24-support"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Contact us</span>
              </a>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-dollar-square"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Price</span><span class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link"
                    href="./pages/price-v1.html">Price 1</a></li>
                <li class="pc-item"><a class="pc-link"
                    href="./pages/price-v2.html">Price 2</a></li>
              </ul>
            </li>
            <li class="pc-item"><a href="./pages/landing.html" class="pc-link"
                target="_blank"><span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-airplane"></use>
                  </svg> </span><span class="pc-mtext">Landing</span></a>
            </li>

            <li class="pc-item pc-caption">
              <label>Other</label>
              <svg class="pc-icon">
                <use xlink:href="#custom-notification-status"></use>
              </svg>
            </li>
            <li class="pc-item pc-hasmenu">
              <a href="#!" class="pc-link"><span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-level"></use>
                  </svg> </span><span class="pc-mtext">Menu levels</span><span
                  class="pc-arrow"><i
                    data-feather="chevron-right"></i></span></a>
              <ul class="pc-submenu">
                <li class="pc-item"><a class="pc-link" href="#!">Level
                    2.1</a></li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Level 2.2<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" href="#!">Level
                        3.1</a></li>
                    <li class="pc-item"><a class="pc-link" href="#!">Level
                        3.2</a></li>
                    <li class="pc-item pc-hasmenu">
                      <a href="#!" class="pc-link">Level 3.3<span
                          class="pc-arrow"><i
                            data-feather="chevron-right"></i></span></a>
                      <ul class="pc-submenu">
                        <li class="pc-item"><a class="pc-link" href="#!">Level
                            4.1</a></li>
                        <li class="pc-item"><a class="pc-link" href="#!">Level
                            4.2</a></li>
                      </ul>
                    </li>
                  </ul>
                </li>
                <li class="pc-item pc-hasmenu">
                  <a href="#!" class="pc-link">Level 2.3<span
                      class="pc-arrow"><i
                        data-feather="chevron-right"></i></span></a>
                  <ul class="pc-submenu">
                    <li class="pc-item"><a class="pc-link" href="#!">Level
                        3.1</a></li>
                    <li class="pc-item"><a class="pc-link" href="#!">Level
                        3.2</a></li>
                    <li class="pc-item pc-hasmenu">
                      <a href="#!" class="pc-link">Level 3.3<span
                          class="pc-arrow"><i
                            data-feather="chevron-right"></i></span></a>
                      <ul class="pc-submenu">
                        <li class="pc-item"><a class="pc-link" href="#!">Level
                            4.1</a></li>
                        <li class="pc-item"><a class="pc-link" href="#!">Level
                            4.2</a></li>
                      </ul>
                    </li>
                  </ul>
                </li>
              </ul>
            </li>
            <li class="pc-item"><a href="./other/sample-page.html"
                class="pc-link">
                <span class="pc-micon">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-notification-status"></use>
                  </svg>
                </span>
                <span class="pc-mtext">Sample page</span></a></li> -->

          </ul>
        </div>
      </div>
    </nav>
    <!-- [ Sidebar Menu ] end -->
    <!-- [ Header Topbar ] start -->
    <header class="pc-header">
      <div class="header-wrapper"> <!-- [Mobile Media Block] start -->
        <div class="me-auto pc-mob-drp">
          <ul class="list-unstyled">
            <!-- ======= Menu collapse Icon ===== -->
            <li class="pc-h-item pc-sidebar-collapse">
              <a href="#" class="pc-head-link ms-0" id="sidebar-hide">
                <i class="ti ti-menu-2"></i>
              </a>
            </li>
            <li class="pc-h-item pc-sidebar-popup">
              <a href="#" class="pc-head-link ms-0" id="mobile-collapse">
                <i class="ti ti-menu-2"></i>
              </a>
            </li>
            <!-- <li class="dropdown pc-h-item">
              <a
                class="pc-head-link dropdown-toggle arrow-none m-0 trig-drp-search"
                data-bs-toggle="dropdown"
                href="#"
                role="button"
                aria-haspopup="false"
                aria-expanded="false">
                <svg class="pc-icon">
                  <use xlink:href="#custom-search-normal-1"></use>
                </svg>
              </a>
              <div class="dropdown-menu pc-h-dropdown drp-search">
                <form class="px-3 py-2">
                  <input type="search" class="form-control border-0 shadow-none"
                    placeholder="Search here. . ." />
                </form>
              </div>
            </li> -->
          </ul>
        </div>
        <!-- [Mobile Media Block end] -->
        <div class="ms-auto">
          <ul class="list-unstyled">
            <!-- <li class="dropdown pc-h-item">
              <a
                class="pc-head-link dropdown-toggle arrow-none me-0"
                data-bs-toggle="dropdown"
                href="#"
                role="button"
                aria-haspopup="false"
                aria-expanded="false">
                <svg class="pc-icon">
                  <use xlink:href="#custom-sun-1"></use>
                </svg>
              </a>
              <div class="dropdown-menu dropdown-menu-end pc-h-dropdown">
                <a href="#!" class="dropdown-item"
                  onclick="layout_change('dark')">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-moon"></use>
                  </svg>
                  <span>Dark</span>
                </a>
                <a href="#!" class="dropdown-item"
                  onclick="layout_change('light')">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-sun-1"></use>
                  </svg>
                  <span>Light</span>
                </a>
                <a href="#!" class="dropdown-item"
                  onclick="layout_change_default()">
                  <svg class="pc-icon">
                    <use xlink:href="#custom-setting-2"></use>
                  </svg>
                  <span>Default</span>
                </a>
              </div>
            </li>
            <li class="dropdown pc-h-item">
              <a
                class="pc-head-link dropdown-toggle arrow-none me-0"
                data-bs-toggle="dropdown"
                href="#"
                role="button"
                aria-haspopup="false"
                aria-expanded="false">
                <svg class="pc-icon">
                  <use xlink:href="#custom-setting-2"></use>
                </svg>
              </a>
              <div class="dropdown-menu dropdown-menu-end pc-h-dropdown">
                <a href="#!" class="dropdown-item">
                  <i class="ti ti-user"></i>
                  <span>My Account</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ti ti-settings"></i>
                  <span>Settings</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ti ti-headset"></i>
                  <span>Support</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ti ti-lock"></i>
                  <span>Lock Screen</span>
                </a>
                <a href="#!" class="dropdown-item">
                  <i class="ti ti-power"></i>
                  <span><a href="<?php echo e(url('/logout')); ?>">Logout</a></span>
                </a>
              </div>
            </li>
            <li class="pc-h-item">
              <a href="#" class="pc-head-link me-0" data-bs-toggle="offcanvas"
                data-bs-target="#announcement" aria-controls="announcement">
                <svg class="pc-icon">
                  <use xlink:href="#custom-flash"></use>
                </svg>
              </a>
            </li>
            <li class="dropdown pc-h-item">
              <a
                class="pc-head-link dropdown-toggle arrow-none me-0"
                data-bs-toggle="dropdown"
                href="#"
                role="button"
                aria-haspopup="false"
                aria-expanded="false">
                <svg class="pc-icon">
                  <use xlink:href="#custom-notification"></use>
                </svg>
                <span class="badge bg-success pc-h-badge">3</span>
              </a>
              <div
                class="dropdown-menu dropdown-notification dropdown-menu-end pc-h-dropdown">
                <div
                  class="dropdown-header d-flex align-items-center justify-content-between">
                  <h5 class="m-0">Notifications</h5>
                  <a href="#!" class="btn btn-link btn-sm">Mark all read</a>
                </div>
                <div
                  class="dropdown-body text-wrap header-notification-scroll position-relative"
                  style="max-height: calc(100vh - 215px)">
                  <p class="text-span">Today</p>
                  <div class="card mb-2">
                    <div class="card-body">
                      <div class="d-flex">
                        <div class="flex-shrink-0">
                          <svg class="pc-icon text-primary">
                            <use xlink:href="#custom-layer"></use>
                          </svg>
                        </div>
                        <div class="flex-grow-1 ms-3">
                          <span class="float-end text-sm text-muted">2 min
                            ago</span>
                          <h5 class="text-body mb-2">UI/UX Design</h5>
                          <p class="mb-0">Lorem Ipsum has been the industry's
                            standard dummy text ever since the 1500s, when an
                            unknown printer took a galley of
                            type and scrambled it to make a type</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card mb-2">
                    <div class="card-body">
                      <div class="d-flex">
                        <div class="flex-shrink-0">
                          <svg class="pc-icon text-primary">
                            <use xlink:href="#custom-sms"></use>
                          </svg>
                        </div>
                        <div class="flex-grow-1 ms-3">
                          <span class="float-end text-sm text-muted">1 hour
                            ago</span>
                          <h5 class="text-body mb-2">Message</h5>
                          <p class="mb-0">Lorem Ipsum has been the industry's
                            standard dummy text ever since the 1500.</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <p class="text-span">Yesterday</p>
                  <div class="card mb-2">
                    <div class="card-body">
                      <div class="d-flex">
                        <div class="flex-shrink-0">
                          <svg class="pc-icon text-primary">
                            <use xlink:href="#custom-document-text"></use>
                          </svg>
                        </div>
                        <div class="flex-grow-1 ms-3">
                          <span class="float-end text-sm text-muted">2 hour
                            ago</span>
                          <h5 class="text-body mb-2">Forms</h5>
                          <p class="mb-0">Lorem Ipsum has been the industry's
                            standard dummy text ever since the 1500s, when an
                            unknown printer took a galley of
                            type and scrambled it to make a type</p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card mb-2">
                    <div class="card-body">
                      <div class="d-flex">
                        <div class="flex-shrink-0">
                          <svg class="pc-icon text-primary">
                            <use xlink:href="#custom-user-bold"></use>
                          </svg>
                        </div>
                        <div class="flex-grow-1 ms-3">
                          <span class="float-end text-sm text-muted">12 hour
                            ago</span>
                          <h5 class="text-body mb-2">Challenge invitation</h5>
                          <p class="mb-2"><span class="text-dark">Jonny
                              aber</span> invites to join the challenge</p>
                          <button
                            class="btn btn-sm btn-outline-secondary me-2">Decline</button>
                          <button class="btn btn-sm btn-primary">Accept</button>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="card mb-2">
                    <div class="card-body">
                      <div class="d-flex">
                        <div class="flex-shrink-0">
                          <svg class="pc-icon text-primary">
                            <use xlink:href="#custom-security-safe"></use>
                          </svg>
                        </div>
                        <div class="flex-grow-1 ms-3">
                          <span class="float-end text-sm text-muted">5 hour
                            ago</span>
                          <h5 class="text-body mb-2">Security</h5>
                          <p class="mb-0">Lorem Ipsum has been the industry's
                            standard dummy text ever since the 1500s, when an
                            unknown printer took a galley of
                            type and scrambled it to make a type</p>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <div class="text-center py-2">
                  <a href="#!" class="link-danger">Clear all Notifications</a>
                </div>
              </div>
            </li> -->
            <li class="dropdown pc-h-item header-user-profile">
              <a
                class="pc-head-link dropdown-toggle arrow-none me-0"
                data-bs-toggle="dropdown"
                href="#"
                role="button"
                aria-haspopup="false"
                data-bs-auto-close="outside"
                aria-expanded="false">
                <img src="<?php echo e(asset('/assets/images/user/avatar-11.jpg')); ?>" alt="user-image"
                  class="user-avtar" />
              </a>
              <div class="dropdown-menu dropdown-user-profile dropdown-menu-end pc-h-dropdown">
                <div class="dropdown-header d-flex align-items-center justify-content-between">
                  <h5 class="m-0">Profile</h5>
                </div>
                <div class="dropdown-body">
                  <div class="profile-notification-scroll position-relative"
                    style="max-height: calc(100vh - 225px)">
                    <div class="d-flex mb-1">
                      <div class="flex-shrink-0">
                        <img src="<?php echo e(asset('/assets/images/user/avatar-11.jpg')); ?>"
                          alt="user-image" class="user-avtar wid-35" />
                      </div>
                      <div class="flex-grow-1 ms-3">
                        <h6 class="mb-1"><?php echo e(Auth::user()->name); ?></h6>
                        <span><?php echo e(Auth::user()->email); ?></span>
                      </div>
                    </div>
                    <hr class="border-secondary border-opacity-50" />
                    <!-- <div class="card">
                      <div class="card-body py-3">
                        <div
                          class="d-flex align-items-center justify-content-between">
                          <h5 class="mb-0 d-inline-flex align-items-center"><svg
                              class="pc-icon text-muted me-2">
                              <use
                                xlink:href="#custom-notification-outline"></use>
                            </svg>Notification</h5>
                          <div
                            class="form-check form-switch form-check-reverse m-0">
                            <input class="form-check-input f-18" type="checkbox"
                              role="switch" />
                          </div>
                        </div>
                      </div>
                    </div>
                    <p class="text-span">Manage</p>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-setting-outline"></use>
                        </svg>
                        <span>Settings</span>
                      </span>
                    </a>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-share-bold"></use>
                        </svg>
                        <span>Share</span>
                      </span>
                    </a>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-lock-outline"></use>
                        </svg>
                        <span>Change Password</span>
                      </span>
                    </a>
                    <hr class="border-secondary border-opacity-50" />
                    <p class="text-span">Team</p>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-profile-2user-outline"></use>
                        </svg>
                        <span>UI Design team</span>
                      </span>
                      <div class="user-group">
                        <img src="<?php echo e(asset('/assets/images/user/avatar-1.jpg')); ?>"
                          alt="user-image" class="avtar" />
                        <span class="avtar bg-danger text-white">K</span>
                        <span class="avtar bg-success text-white">
                          <svg class="pc-icon m-0">
                            <use xlink:href="#custom-user"></use>
                          </svg>
                        </span>
                        <span
                          class="avtar bg-light-primary text-primary">+2</span>
                      </div>
                    </a>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-profile-2user-outline"></use>
                        </svg>
                        <span>Friends Groups</span>
                      </span>
                      <div class="user-group">
                        <img src="<?php echo e(asset('/assets/images/user/avatar-1.jpg')); ?>"
                          alt="user-image" class="avtar" />
                        <span class="avtar bg-danger text-white">K</span>
                        <span class="avtar bg-success text-white">
                          <svg class="pc-icon m-0">
                            <use xlink:href="#custom-user"></use>
                          </svg>
                        </span>
                      </div>
                    </a>
                    <a href="#" class="dropdown-item">
                      <span>
                        <svg class="pc-icon text-muted me-2">
                          <use xlink:href="#custom-add-outline"></use>
                        </svg>
                        <span>Add new</span>
                      </span>
                      <div class="user-group">
                        <span class="avtar bg-primary text-white">
                          <svg class="pc-icon m-0">
                            <use xlink:href="#custom-add-outline"></use>
                          </svg>
                        </span>
                      </div>
                    </a>
                    <hr class="border-secondary border-opacity-50" /> -->
                    <div class="d-grid mb-3">
                      <a href="<?php echo e(route('logout')); ?>" class="btn btn-primary">
                        <svg class="pc-icon me-2">
                          <use xlink:href="#custom-logout-1-outline"></use>
                        </svg>Logout
                      </a>
                    </div>
                    <!-- <div
                      class="card border-0 shadow-none drp-upgrade-card mb-0"
                      style="background-image: url(./assets/images/layout/img-profile-card.jpg)">
                      <div class="card-body">
                        <div class="user-group">
                          <img src="<?php echo e(asset('/assets/images/user/avatar-1.jpg')); ?>"
                            alt="user-image" class="avtar" />
                          <img src="<?php echo e(asset('/assets/images/user/avatar-2.jpg')); ?>"
                            alt="user-image" class="avtar" />
                          <img src="<?php echo e(asset('/assets/images/user/avatar-3.jpg')); ?>"
                            alt="user-image" class="avtar" />
                          <img src="<?php echo e(asset('/assets/images/user/avatar-4.jpg')); ?>"
                            alt="user-image" class="avtar" />
                          <img src="<?php echo e(asset('/assets/images/user/avatar-5.jpg')); ?>"
                            alt="user-image" class="avtar" />
                          <span
                            class="avtar bg-light-primary text-primary">+20</span>
                        </div>
                        <h3 class="my-3 text-dark">245.3k <small
                            class="text-muted">Followers</small></h3>
                        <div class="btn btn btn-warning">
                          <svg class="pc-icon me-2">
                            <use xlink:href="#custom-logout-1-outline"></use>
                          </svg>
                          Upgrade to Business
                        </div>
                      </div>
                    </div> -->
                  </div>
                </div>
              </div>
            </li>
          </ul>
        </div>
      </div>
    </header>
    <div class="offcanvas pc-announcement-offcanvas offcanvas-end" tabindex="-1"
      id="announcement" aria-labelledby="announcementLabel">
      <div class="offcanvas-header">
        <h5 class="offcanvas-title" id="announcementLabel">What’s new
          announcement?</h5>
        <button type="button" class="btn-close" data-bs-dismiss="offcanvas"
          aria-label="Close"></button>
      </div>
      <div class="offcanvas-body">
        <p class="text-span">Today</p>
        <div class="card mb-3">
          <div class="card-body">
            <div class="align-items-center d-flex flex-wrap gap-2 mb-3">
              <div class="badge bg-light-success f-12">Big News</div>
              <p class="mb-0 text-muted">2 min ago</p>
              <span class="badge dot bg-warning"></span>
            </div>
            <h5 class="mb-3">Able Pro is Redesigned</h5>
            <p class="text-muted">Able Pro is completely renowed with high
              aesthetics User Interface.</p>
            <img src="<?php echo e(asset('/assets/images/layout/img-announcement-1.png')); ?>" alt="img"
              class="img-fluid mb-3" />
            <div class="row">
              <div class="col-12">
                <div class="d-grid"><a
                    class="btn btn-outline-secondary"
                    href="https://1.envato.market/c/1289604/275988/4415?subId1=phoenixcoded&u=https%3A%2F%2Fthemeforest.net%2Fitem%2Fable-pro-responsive-bootstrap-4-admin-template%2F19300403"
                    target="_blank">Check Now</a></div>
              </div>
            </div>
          </div>
        </div>
        <div class="card mb-3">
          <div class="card-body">
            <div class="align-items-center d-flex flex-wrap gap-2 mb-3">
              <div class="badge bg-light-warning f-12">Offer</div>
              <p class="mb-0 text-muted">2 hour ago</p>
              <span class="badge dot bg-warning"></span>
            </div>
            <h5 class="mb-3">Able Pro is in best offer price</h5>
            <p class="text-muted">Download Able Pro exclusive on themeforest
              with best price. </p>
            <a
              href="https://1.envato.market/c/1289604/275988/4415?subId1=phoenixcoded&u=https%3A%2F%2Fthemeforest.net%2Fitem%2Fable-pro-responsive-bootstrap-4-admin-template%2F19300403"
              target="_blank"><img
                src="<?php echo e(asset('/assets/images/layout/img-announcement-2.png')); ?>" alt="img"
                class="img-fluid" /></a>
          </div>
        </div>

        <p class="text-span mt-4">Yesterday</p>
        <div class="card mb-3">
          <div class="card-body">
            <div class="align-items-center d-flex flex-wrap gap-2 mb-3">
              <div class="badge bg-light-primary f-12">Blog</div>
              <p class="mb-0 text-muted">12 hour ago</p>
              <span class="badge dot bg-warning"></span>
            </div>
            <h5 class="mb-3">Featured Dashboard Template</h5>
            <p class="text-muted">Do you know Able Pro is one of the featured
              dashboard template selected by Themeforest team.?</p>
            <img src="<?php echo e(asset('/assets/images/layout/img-announcement-3.png')); ?>" alt="img"
              class="img-fluid" />
          </div>
        </div>
        <div class="card mb-3">
          <div class="card-body">
            <div class="align-items-center d-flex flex-wrap gap-2 mb-3">
              <div class="badge bg-light-primary f-12">Announcement</div>
              <p class="mb-0 text-muted">12 hour ago</p>
              <span class="badge dot bg-warning"></span>
            </div>
            <h5 class="mb-3">Buy Once - Get Free Updated lifetime</h5>
            <p class="text-muted">Get the lifetime free updates once you
              purchase the Able Pro.</p>
            <img src="<?php echo e(asset('/assets/images/layout/img-announcement-4.png')); ?>" alt="img"
              class="img-fluid" />
          </div>
        </div>
      </div>
    </div>
    <!-- [ Header ] end --><?php /**PATH C:\xampp4\htdocs\aaft_cms\resources\views/layouts/header.blade.php ENDPATH**/ ?>