<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\BrandController;

use App\Http\Controllers\HomeController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\EventController;
use App\Http\Controllers\InvestorController;
use App\Http\Controllers\BannerController;
use App\Http\Controllers\AboutController;
use App\Http\Controllers\NxtController;
use App\Http\Controllers\ProgramController;
use App\Http\Controllers\InfraController;
use App\Http\Controllers\QualityInitiativeController;
use App\Http\Controllers\WorkCultureController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\PolicyController;
use App\Http\Controllers\NewsletterController;
use App\Http\Controllers\SuccessStoryController;
use App\Http\Controllers\MediaController;
use App\Http\Controllers\FrontController;

Route::group(['prefix'=> 'admin' ],function(){
    Route::get('/register', [UserController::class, 'register_view'])->name('register_view');
    Route::post('/register', [UserController::class, 'register'])->name('register');
    Route::get('/', [UserController::class, 'index'])->name('login');
    Route::post('/user_login', [UserController::class, 'user_login'])->name('user_login');

    Route::get('/logout', [UserController::class, 'logout'])->name('logout');

    Route::get('/dashboard', [HomeController::class, 'dashboard'])->name('dashboard');
     Route::get('/leads', [HomeController::class, 'leads'])->name('leads');
    /*Route::get('/enquiry', [HomeController::class, 'enquiry'])->name('enquiry');
    Route::get('/add_blog', [BlogController::class, 'add_blog'])->name('add_blog');
    Route::post('/store_blog', [BlogController::class, 'store_blog'])->name('store_blog');
    Route::get('/view_blog', [BlogController::class, 'view_blog'])->name('view_blog');
    Route::get('/edit_blog/{id}', [BlogController::class, 'edit_blog'])->name('edit_blog');
    Route::post('/update_blog/{id}', [BlogController::class, 'update_blog'])->name('update_blog');
    Route::get('/delete_blog/{id}', [BlogController::class, 'delete_blog'])->name('delete_blog');

    Route::get('/faqs', [FaqController::class, 'get_faqs'])->name('faqs');
    Route::get('/add_faq', [FaqController::class, 'add_faq'])->name('add_faq');
    Route::post('/store_faq', [FaqController::class, 'store_faq'])->name('store_faq');
    Route::get('/edit_faq/{id}', [FaqController::class, 'edit_faq'])->name('edit_faq');
    Route::post('/update_faq/{id?}', [FaqController::class, 'update_faq'])->name('update_faq');
    Route::get('/delete_faq/{id}', [FaqController::class, 'delete_faq'])->name('delete_faq');

    Route::get('/features', [FaqController::class, 'get_features'])->name('features');
    Route::get('/add_feature', [FaqController::class, 'add_feature'])->name('add_feature');
    Route::post('/store_feature', [FaqController::class, 'store_feature'])->name('store_feature');
    Route::get('/edit_feature/{id}', [FaqController::class, 'edit_feature'])->name('edit_feature');
    Route::post('/update_feature/{id?}', [FaqController::class, 'update_feature'])->name('update_feature');
    Route::get('/delete_feature/{id}', [FaqController::class, 'delete_feature'])->name('delete_feature');

    Route::get('/kamdhenu_nxt', [FaqController::class, 'get_kamdhenu_nxt'])->name('kamdhenu_nxt');
    Route::get('/add_kamdhenu_nxt', [FaqController::class, 'add_kamdhenu_nxt'])->name('add_kamdhenu_nxt');
    Route::post('/store_kamdhenu_nxt', [FaqController::class, 'store_kamdhenu_nxt'])->name('store_kamdhenu_nxt');
    Route::get('/edit_kamdhenu_nxt/{id}', [FaqController::class, 'edit_kamdhenu_nxt'])->name('edit_kamdhenu_nxt');
    Route::post('/update_kamdhenu_nxt/{id?}', [FaqController::class, 'update_kamdhenu_nxt'])->name('update_kamdhenu_nxt');
    Route::get('/delete_kamdhenu_nxt/{id}', [FaqController::class, 'delete_kamdhenu_nxt'])->name('delete_kamdhenu_nxt');

    Route::get('/building_dreams', [FaqController::class, 'get_building_dreams'])->name('building_dreams');
    Route::get('/add_building_dreams', [FaqController::class, 'add_building_dreams'])->name('add_building_dreams');
    Route::post('/store_building_dreams', [FaqController::class, 'store_building_dreams'])->name('store_building_dreams');
    Route::get('/edit_building_dreams/{id}', [FaqController::class, 'edit_building_dreams'])->name('edit_building_dreams');
    Route::post('/update_building_dreams/{id?}', [FaqController::class, 'update_building_dreams'])->name('update_building_dreams');
    Route::get('/delete_building_dreams/{id}', [FaqController::class, 'delete_building_dreams'])->name('delete_building_dreams');

    Route::get('/kamdhenu_difference', [FaqController::class, 'get_kamdhenu_difference'])->name('kamdhenu_difference');
    Route::get('/add_kamdhenu_difference', [FaqController::class, 'add_kamdhenu_difference'])->name('add_kamdhenu_difference');
    Route::post('/store_kamdhenu_difference', [FaqController::class, 'store_kamdhenu_difference'])->name('store_kamdhenu_difference');
    Route::get('/edit_kamdhenu_difference/{id}', [FaqController::class, 'edit_kamdhenu_difference'])->name('edit_kamdhenu_difference');
    Route::post('/update_kamdhenu_difference/{id?}', [FaqController::class, 'update_kamdhenu_difference'])->name('update_kamdhenu_difference');
    Route::get('/delete_kamdhenu_difference/{id}', [FaqController::class, 'delete_kamdhenu_difference'])->name('delete_kamdhenu_difference');

    Route::get('/add_event', [EventController::class, 'add_event'])->name('add_event');
    Route::post('/store_event', [EventController::class, 'store_event'])->name('store_event');
    Route::get('/view_event', [EventController::class, 'view_event'])->name('view_event');
    Route::get('/edit_event/{id}', [EventController::class, 'edit_event'])->name('edit_event');
    Route::post('/update_event/{id}', [EventController::class, 'update_event'])->name('update_event');
    Route::get('/delete_event/{id}', [EventController::class, 'delete_event'])->name('delete_event');

    Route::get('/category', [InvestorController::class, 'category'])->name('category');
    Route::get('/add_category', [InvestorController::class, 'add_category'])->name('add_category');
    Route::post('/store_category', [InvestorController::class, 'store_category'])->name('store_category');
    Route::get('/edit_category/{id?}', [InvestorController::class, 'edit_category'])->name('edit_category');
    Route::post('/update_category/{id?}', [InvestorController::class, 'update_category'])->name('update_category');
    Route::get('/delete_category/{id}', [InvestorController::class, 'delete_category'])->name('delete_category');

    Route::get('/sub_category', [InvestorController::class, 'sub_category'])->name('sub_category');
    Route::get('/add_sub_category', [InvestorController::class, 'add_sub_category'])->name('add_sub_category');
    Route::post('/store_sub_category', [InvestorController::class, 'store_sub_category'])->name('store_sub_category');
    Route::get('/edit_sub_category/{id?}', [InvestorController::class, 'edit_sub_category'])->name('edit_sub_category');
    Route::post('/update_sub_category/{id?}', [InvestorController::class, 'update_sub_category'])->name('update_sub_category');
    Route::post('/get_sub_category', [InvestorController::class, 'get_sub_category'])->name('get_sub_category');

    Route::get('/investor', [InvestorController::class, 'investor'])->name('investor');
    Route::get('/add_investor', [InvestorController::class, 'add_investor'])->name('add_investor');
    Route::post('/store_investor', [InvestorController::class, 'store_investor'])->name('store_investor');
    Route::get('/edit_investor/{id}', [InvestorController::class, 'edit_investor'])->name('edit_investor');
    Route::post('/update_investor/{id?}', [InvestorController::class, 'update_investor'])->name('update_investor');
    Route::get('/delete_investor/{id}', [InvestorController::class, 'delete_investor'])->name('delete_investor');
    
    Route::get('/about', [AboutController::class, 'about'])->name('about');
    Route::get('/add_about', [AboutController::class, 'add_about'])->name('add_about');
    Route::post('/store_about', [AboutController::class, 'store_about'])->name('store_about');
    Route::get('/edit_about/{id}', [AboutController::class, 'edit_about'])->name('edit_about');
    Route::post('/update_about/{id?}', [AboutController::class, 'update_about'])->name('update_about');
    Route::get('/delete_about/{id}', [AboutController::class, 'delete_about'])->name('delete_about');

    Route::get('/csr-data', [AboutController::class, 'get_csr_data'])->name('csr-data');
    Route::get('/add_csr', [AboutController::class, 'add_csr'])->name('add_csr');
    Route::post('/store_csr', [AboutController::class, 'store_csr'])->name('store_csr');
    Route::get('/edit_csr/{id}', [AboutController::class, 'edit_csr'])->name('edit_csr');
    Route::post('/update_csr/{id?}', [AboutController::class, 'update_csr'])->name('update_csr');
    Route::get('/delete_csr/{id}', [AboutController::class, 'delete_csr'])->name('delete_csr');
  
    Route::get('/nxt-data', [NxtController::class, 'get_nxt_data'])->name('nxt-data');
    Route::get('/add_nxt', [NxtController::class, 'add_nxt'])->name('add_nxt');
    Route::post('/store_nxt', [NxtController::class, 'store_nxt'])->name('store_nxt');
    Route::get('/edit_nxt/{id}', [NxtController::class, 'edit_nxt'])->name('edit_nxt');
    Route::post('/update_nxt/{id?}', [NxtController::class, 'update_nxt'])->name('update_nxt');
    Route::get('/delete_nxt/{id}', [NxtController::class, 'delete_nxt'])->name('delete_nxt');

    Route::get('/case-study-data', [NxtController::class, 'get_case_study_data'])->name('case-study-data');
    Route::get('/add_case_study', [NxtController::class, 'add_case_study'])->name('add_case_study');
    Route::post('/store_case_study', [NxtController::class, 'store_case_study'])->name('store_case_study');
    Route::get('/edit_case_study/{id}', [NxtController::class, 'edit_case_study'])->name('edit_case_study');
    Route::post('/update_case_study/{id?}', [NxtController::class, 'update_case_study'])->name('update_case_study');
    Route::get('/delete_case_study/{id}', [NxtController::class, 'delete_case_study'])->name('delete_case_study');

    Route::get('/banner', [BannerController::class, 'banner'])->name('banner');
    Route::get('/add_banner', [BannerController::class, 'add_banner'])->name('add_banner');
    Route::post('/store_banner', [BannerController::class, 'store_banner'])->name('store_banner');
    Route::get('/edit_banner/{id?}', [BannerController::class, 'edit_banner'])->name('edit_banner');
    Route::post('/update_banner/{id?}', [BannerController::class, 'update_banner'])->name('update_banner');
    Route::get('/delete_banner/{id}', [BannerController::class, 'delete_banner'])->name('delete_banner');

    Route::get('/brands', [BrandController::class, 'brands'])->name('brands');
    Route::get('/add_brand', [BrandController::class, 'add_brand'])->name('add_brand');
    Route::post('/store_brand', [BrandController::class, 'store_brand'])->name('store_brand');
    Route::get('/edit_brand/{id}', [BrandController::class, 'edit_brand'])->name('edit_brand');
    Route::post('/update_brand/{id?}', [BrandController::class, 'update_brand'])->name('update_brand');
    Route::get('/delete_brand/{id}', [BrandController::class, 'delete_brand'])->name('delete_brand');
    
    Route::get('/partner_program', [ProgramController::class, 'partner_program'])->name('partner_program');
    Route::get('/add_partner_program', [ProgramController::class, 'add_partner_program'])->name('add_partner_program');
    Route::post('/store_partner_program', [ProgramController::class, 'store_partner_program'])->name('store_partner_program');
    Route::get('/edit_partner_program/{id}', [ProgramController::class, 'edit_partner_program'])->name('edit_partner_program');
    Route::post('/update_partner_program/{id?}', [ProgramController::class, 'update_partner_program'])->name('update_partner_program');
    Route::get('/delete_partner_program/{id}', [ProgramController::class, 'delete_partner_program'])->name('delete_partner_program');
    
    Route::get('/infrastructure', [InfraController::class, 'infrastructure'])->name('infrastructure');
    Route::get('/add_infrastructure', [InfraController::class, 'add_infrastructure'])->name('add_infrastructure');
    Route::post('/store_infrastructure', [InfraController::class, 'store_infrastructure'])->name('store_infrastructure');
    Route::get('/edit_infrastructure/{id}', [InfraController::class, 'edit_infrastructure'])->name('edit_infrastructure');
    Route::post('/update_infrastructure/{id?}', [InfraController::class, 'update_infrastructure'])->name('update_infrastructure');
    Route::get('/delete_infrastructure/{id}', [InfraController::class, 'delete_infrastructure'])->name('delete_infrastructure');
    
    Route::get('/quality_initiative', [QualityInitiativeController::class, 'quality_initiative'])->name('quality_initiative');
    Route::get('/add_quality_initiative', [QualityInitiativeController::class, 'add_quality_initiative'])->name('add_quality_initiative');
    Route::post('/store_quality_initiative', [QualityInitiativeController::class, 'store_quality_initiative'])->name('store_quality_initiative');
    Route::get('/edit_quality_initiative/{id}', [QualityInitiativeController::class, 'edit_quality_initiative'])->name('edit_quality_initiative');
    Route::post('/update_quality_initiative/{id?}', [QualityInitiativeController::class, 'update_quality_initiative'])->name('update_quality_initiative');
    Route::get('/delete_quality_initiative/{id}', [QualityInitiativeController::class, 'delete_quality_initiative'])->name('delete_quality_initiative');
    
    Route::get('/work_culture', [WorkCultureController::class, 'work_culture'])->name('work_culture');
    Route::get('/add_work_culture', [WorkCultureController::class, 'add_work_culture'])->name('add_work_culture');
    Route::post('/store_work_culture', [WorkCultureController::class, 'store_work_culture'])->name('store_work_culture');
    Route::get('/edit_work_culture/{id}', [WorkCultureController::class, 'edit_work_culture'])->name('edit_work_culture');
    Route::post('/update_work_culture/{id?}', [WorkCultureController::class, 'update_work_culture'])->name('update_work_culture');
    Route::get('/delete_work_culture/{id}', [WorkCultureController::class, 'delete_work_culture'])->name('delete_work_culture');
    
    Route::get('/policy', [PolicyController::class, 'policy'])->name('policy');
    Route::get('/add_policy', [PolicyController::class, 'add_policy'])->name('add_policy');
    Route::post('/store_policy', [PolicyController::class, 'store_policy'])->name('store_policy');
    Route::get('/edit_policy/{id}', [PolicyController::class, 'edit_policy'])->name('edit_policy');
    Route::post('/update_policy/{id?}', [PolicyController::class, 'update_policy'])->name('update_policy');
    Route::get('/delete_policy/{id}', [PolicyController::class, 'delete_policy'])->name('delete_policy');
    
    Route::get('/award', [HomeController::class, 'award'])->name('award');
    Route::get('/add_award', [HomeController::class, 'add_award'])->name('add_award');
    Route::post('/store_award', [HomeController::class, 'store_award'])->name('store_award');
    Route::get('/edit_award/{id}', [HomeController::class, 'edit_award'])->name('edit_award');
    Route::post('/update_award/{id?}', [HomeController::class, 'update_award'])->name('update_award');
    Route::get('/delete_award/{id}', [HomeController::class, 'delete_award'])->name('delete_award');
    
    Route::get('/testimonial', [HomeController::class, 'testimonial'])->name('testimonial');
    Route::get('/add_testimonial', [HomeController::class, 'add_testimonial'])->name('add_testimonial');
    Route::post('/store_testimonial', [HomeController::class, 'store_testimonial'])->name('store_testimonial');
    Route::get('/edit_testimonial/{id}', [HomeController::class, 'edit_testimonial'])->name('edit_testimonial');
    Route::post('/update_testimonial/{id?}', [HomeController::class, 'update_testimonial'])->name('update_testimonial');
    Route::get('/delete_testimonial/{id}', [HomeController::class, 'delete_testimonial'])->name('delete_testimonial');
    
    Route::get('/business_area', [HomeController::class, 'business_area'])->name('business_area');
    Route::get('/add_business_area', [HomeController::class, 'add_business_area'])->name('add_business_area');
    Route::post('/store_business_area', [HomeController::class, 'store_business_area'])->name('store_business_area');
    Route::get('/edit_business_area/{id}', [HomeController::class, 'edit_business_area'])->name('edit_business_area');
    Route::post('/update_business_area/{id?}', [HomeController::class, 'update_business_area'])->name('update_business_area');
    Route::get('/delete_business_area/{id}', [HomeController::class, 'delete_business_area'])->name('delete_business_area');
    */
    Route::get('/page', [HomeController::class, 'page'])->name('page');
    Route::get('/add_page_content', [HomeController::class, 'add_page_content'])->name('add_page_content');
    Route::post('/store_page_content', [HomeController::class, 'store_page_content'])->name('store_page_content');
    Route::get('/edit_page_content/{id}', [HomeController::class, 'edit_page_content'])->name('edit_page_content');
    Route::post('/update_page_content/{id?}', [HomeController::class, 'update_page_content'])->name('update_page_content');
    Route::get('/delete_page_content/{id}', [HomeController::class, 'delete_page_content'])->name('delete_page_content');
    
   /* Route::get('/newsletter', [NewsletterController::class, 'newsletter'])->name('newsletter');
    Route::get('/add_newsletter', [NewsletterController::class, 'add_newsletter'])->name('add_newsletter');
    Route::post('/store_newsletter', [NewsletterController::class, 'store_newsletter'])->name('store_newsletter');
    Route::get('/edit_newsletter/{id}', [NewsletterController::class, 'edit_newsletter'])->name('edit_newsletter');
    Route::post('/update_newsletter/{id?}', [NewsletterController::class, 'update_newsletter'])->name('update_newsletter');
    Route::get('/delete_newsletter/{id}', [NewsletterController::class, 'delete_newsletter'])->name('delete_newsletter');
     
    Route::get('/contacts', [ContactController::class, 'get_contacts'])->name('contacts');
    Route::get('/add_contacts', [ContactController::class, 'add_contacts'])->name('add_contacts');
    Route::post('/store_contacts', [ContactController::class, 'store_contacts'])->name('store_contacts');
    Route::get('/edit_contacts/{id}', [ContactController::class, 'edit_contacts'])->name('edit_contacts');
    Route::post('/update_contacts/{id?}', [ContactController::class, 'update_contacts'])->name('update_contacts');
    Route::get('/delete_contacts/{id}', [ContactController::class, 'delete_contacts'])->name('delete_contacts');
    
    Route::get('/story', [SuccessStoryController::class, 'get_story'])->name('story');
    Route::get('/add_story', [SuccessStoryController::class, 'add_story'])->name('add_story');
    Route::post('/store_story', [SuccessStoryController::class, 'store_story'])->name('store_story');
    Route::get('/edit_story/{id}', [SuccessStoryController::class, 'edit_story'])->name('edit_story');
    Route::post('/update_story/{id?}', [SuccessStoryController::class, 'update_story'])->name('update_story');
    Route::get('/delete_story/{id}', [SuccessStoryController::class, 'delete_story'])->name('delete_story');

    Route::get('/get_media', [MediaController::class, 'get_media'])->name('get_media');
    Route::get('/add_media', [MediaController::class, 'add_media'])->name('add_media');
    Route::post('/store_media', [MediaController::class, 'store_media'])->name('store_media');
    Route::get('/edit_media/{id}', [MediaController::class, 'edit_media'])->name('edit_media');
    Route::post('/update_media/{id?}', [MediaController::class, 'update_media'])->name('update_media');
    Route::get('/delete_media/{id}', [MediaController::class, 'delete_media'])->name('delete_media');
    */
});


Route::get('/aaft/{id}', [FrontController::class, 'landingpage'])->name('landingpage');
Route::get('/{id}', [FrontController::class, 'landingpage'])->name('landingpage');
Route::post('/store_lead', [FrontController::class, 'store_lead'])->name('store_lead');
Route::view('/page/thankyou', 'front.thankyou')->name('thankyou');
/*
//Forntend
Route::get('/', [FrontController::class, 'index'])->name('home');
Route::get('/brand', [FrontController::class, 'brand'])->name('brand');
Route::get('/partner', [FrontController::class, 'partner'])->name('partner');

Route::get('/investor', [InvestorController::class, 'get_investor'])->name('get_investor');
Route::post('/get_investor_data', [InvestorController::class, 'get_investor_data'])->name('get_investor_data');
Route::get('/career', [WorkCultureController::class, 'get_career_data'])->name('career');
Route::get('/blog/{filter?}', [BlogController::class, 'blog'])->name('blog');
Route::get('/blog-detail/{id}', [BlogController::class, 'blog_detail'])->name('blog-detail');
Route::post('/get-blog-data', [BlogController::class, 'get_blog_data'])->name('get-blog-data');


Route::get('/contact-us', [ContactController::class, 'get_contact_us'])->name('contact-us');
Route::post('/submit-enquiry', [ContactController::class, 'submit_enquiry'])->name('submit-enquiry');
Route::post('/get_city', [ContactController::class, 'get_city'])->name('get_city');

Route::get('/about-us', [AboutController::class, 'get_about_us'])->name('about-us');
Route::get('/csr', [AboutController::class, 'get_csr'])->name('csr');

Route::get('/partner-program', [ProgramController::class, 'get_partner_program'])->name('partner-program');
Route::get('/our-story', [SuccessStoryController::class, 'get_our_story'])->name('our-story');

Route::get('/event/{filter?}', [EventController::class, 'event'])->name('event');
Route::get('/event-detail/{id}', [EventController::class, 'event_detail'])->name('event-detail');
Route::post('/get-event-data', [EventController::class, 'get_event_data'])->name('get-event-data');
Route::get('/nxt', [NxtController::class, 'get_nxt'])->name('nxt');
Route::get('/case-study', [NxtController::class, 'get_case_study'])->name('case-study');
Route::get('/case-study-detail/{id?}', [NxtController::class, 'get_case_study_detail'])->name('case-study-detail');
Route::get('/media/{filter?}', [MediaController::class, 'media'])->name('media');
Route::post('/get-media-data', [MediaController::class, 'get_media_data'])->name('get-media-data');

Route::post('/store-enquiry', [ContactController::class, 'store_enquiry'])->name('store-enquiry');
*/

Route::get('/cache',function(){
    Artisan::call('optimize');
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('view:clear');
    Artisan::call('route:clear');
    return "Success";
});