@extends('front.layouts.main')
@section('main-container')
    <div class="inner-banner">
        <img src="{{ asset('/upload/banner/')}}/{{ $data['banner']['image'] }}" class="img-fluid">
        <div class="banner-text">
            <div class="container">
                <div class="row">
                <h6>{!! $data['banner']['title'] !!}</h6>
                <h1>{!! strip_tags($data['banner']['content'], '<br>') !!}</h1>
                </div>
            </div>
        </div>
    </div>
    <section class="inneroverview">
        <div class="container">
            <div class="row">
                <ul class="breadcrumb">
                    <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                    <li class="active">About</li>
                </ul>
            </div>
        </div>
        @if($data['overview']['title'])
        <div class="container">
            <div class="row">
                <div class="col-md-5">
                    <h6>Overview</h6>
                    <h2>{{ $data['overview']['title'] }}</h2>                   
                </div>
                <div class="offset-md-1 col-md-6">
                {!! $data['overview']['content'] !!}
                     </div>
                <div class="col-md-6 mt-5">
                    <img src="{{ asset('/front/images/timeline.png') }}" class="img-fluid "> 
                </div>                
            </div>
        </div>
        @endif
    </section>
    <section class="business newslider bg-gray ">
       
    @if($data['overview']['image'])

        <div class="container relative">
            <div class="row absolute">
                <div class="col-md-12">
                    <img src="{{ asset('/upload/')}}/{{ $data['overview']['image'] }}" class="img-fluid">
                </div>                
            </div>
        </div>
        @endif
          <div class="col-md-12">
                 <div class="fourslidestagepadding owl-carousel owl-theme mt-3">
                 @if($data['overview_slider'][0]['title'])
                 @foreach($data['overview_slider'] as $os) 
                    <div class="item ">
                        <div class="caltural">        
                            <h2>{{ $os['title'] }}</h2>
                            <p>{!! $os['content']  !!}</p>
                        </div>
                    </div>                              
                @endforeach
                @endif
                </div>
          </div>
    </section>
    @if(isset($data['award']) && !empty($data['award']))
<section class="awardsection">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <h6 class="wow animated fadeInRight" data-wow-duration="2s">AWARDS & ACKNOWLEDGEMENTS</h6>
                <h2 class="wow animated fadeInLeft" data-wow-duration="2s">{!! $data['award']['title'] !!}</h2>
                <p class="wow animated fadeInRight" data-wow-duration="2s">{!! $data['award']['sub_title'] !!}</p>
                <div class="fourslide owl-carousel owl-theme">
                   @if(isset($data['award_slide']) && !empty($data['award_slide']))
                    @foreach($data['award_slide'] as $aslide)
                    <div class="item">
                        <div class="awarddata wow animated fadeInLeft">
                        {!! $aslide['description'] !!}
                        </div>
                    </div>
                    @endforeach
                    @endif
                </div>
            </div>
        </div>
    </div>
</section>
@endif
@endsection
@section("js")
<script type="text/javascript">

     $('.fourslidestagepadding').owlCarousel({
        loop: true,
        margin: 30,
        dots: true,
        autoplay:false,
        autoplayTimeout: 3000,
        nav: false,
        items: 4,
         navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        responsive:{
                0:{
                    items: 1
                },                
                728:{
                    items:2
                },
                960:{
                    items:3
                },
                1300:{
                    items:4.5

                }
            }
    })

    $('.fourslide').owlCarousel({
        loop: true,
        margin: 30,
        dots: true,
        autoplay:true,
        autoplayTimeout: 3000,
        nav: false,
        items: 4,
        responsive:{
                0:{
                    items: 1
                },                
                728:{
                    items:2
                },
                960:{
                    items:3
                },
                1300:{
                    items:4

                }
            }
    })

</script>
@endsection