@extends('front.layouts.main')
@section('main-container')
<?php
// echo "<pre>";
// print_r($about_nxt);
// die;
?>
<div class="inner-banner">
    @if( $data['banner']['id'] > 0 )
    <img src="{{ asset('/upload/banner/')}}/{{ $data['banner']['image'] }}" class="img-fluid">
    <div class="banner-text">
        <div class="container">
            <div class="row">
                <h6>{!! $data['banner']['title'] !!}</h6>
                <h1>{!! strip_tags( $data['banner']['content'], '<br>') !!}</h1>
                <a href="" class="btn-primary rotate"><span class="first-span">Request a</span> <span class="textred">Quote Now <i class="fa-solid fa-arrow-right-long"></i></span></a>
                <a href="" class="btn-primary rotate"><span class="first-span">Download</span><span class="textred">Brochure <i class="fa-solid fa-arrow-right-long"></i></span></a>
            </div>
        </div>
    </div>
    @endif
</div>
    <section class="inneroverview">
        <div class="container">
            <div class="row">
                <ul class="breadcrumb">
                    <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                    <li class="active">KAMDHENU NXT </li>
                </ul>
            </div>
        </div>
        <div class="container">
            <div class="row">

            @if( $data['about_nxt']['title'] )
                <div class="col-md-5 mb-2">
                    <h6>{!! $data['about_nxt']['title'] !!}</h6>
                    <h2>{!! $data['about_nxt']['sub_title'] !!}</h2>
                </div>
                <div class="offset-md-1 col-md-6">
                {!! $data['about_nxt']['content'] !!}
                </div>
            @endif
            </div>
        </div>
    </section>
    <section class="featureandbenefits bg-gray">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h6>What is </h6>
                    <h2 class="mb-3">Features and Benefits</h2>
                </div>
            </div>
        </div>
        <div class="col-md-12">
            <div class="fourslidestagepadding owl-carousel owl-theme mt-3">
            @if( $data['benefits'][0]['title'] )
                @foreach($data['benefits'] as $benefits)
                <div class="item">
                    <div class="caltural">
                        <img src="{{ asset('upload') }}/{{ $benefits['image'] }}" class="img-fluid">
                        <h4>{{ $benefits['title'] }}</h4>
                        <p>{!! $benefits['content'] !!}</p>
                    </div>
                </div>
                @endforeach
            @endif
            </div>
        </div>

    </section>
    <section class="nxtpage bg-gray pt-0">
        <div class="container">
            <div class="row">
                <!-- <div class="col-md-">
                    <h6>What is </h6>
                    <h2 class="mb-3">Technical Specifications</h2>

                    </div> -->
                <div class="col-md-6 ">
                    <div class="nxt-tab">
                        <h6>What is </h6>
                        <h2 class="mb-3">Technical Specifications</h2>
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab"
                                    aria-controls="home" aria-selected="true"><b> Chemical Properties</b> <img
                                        src="{{ asset('front/images/') }}/biglong.png"> </a>
                            </li>
                            <li class="nav-item" role="presentation">
                                <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab"
                                    aria-controls="profile" aria-selected="false"> <b>Physical Properties</b> <img
                                        src="{{ asset('front/images/') }}/biglong.png"> </a>
                            </li>

                        </ul>
                        <a href="" class="btn-primary wow animated fadeInDown rotate" data-wow-duration="2s"><span class="first-span">Download the </span><span
                                class="textred">Technical Sheet <i class="fa-solid fa-arrow-right-long"></i></span></a>
                        <a href="" class="btn-primary wow animated fadeInDown rotate" data-wow-duration="2s"><span class="first-span">Download </span><span
                                class="textred">Brochure <i class="fa-solid fa-arrow-right-long"></i></span></a>
                    </div>
                </div>
                <div class="offset-md-2 col-md-4 justifyend">
                    <div class="tab-content " id="myTabContent">
                        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                            <div class="row">
                                <table>
                                    <tr>
                                        <td><b>Carbon:</b></td>
                                        <td>≤ 0.25%</td>
                                    </tr>
                                    <tr>
                                        <td><b>Manganese:</b></td>
                                        <td> ≤ 0.38%</td>
                                    </tr>
                                    <tr>
                                        <td><b>Nitrogen:</b></td>
                                        <td>≤ 0.010%</td>
                                    </tr>
                                </table>

                            </div>

                        </div>
                        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                            <div class="row">
                                <table>
                                    <tr>
                                        <td><b>Carbon1:</b></td>
                                        <td>≤ 0.25%</td>
                                    </tr>
                                    <tr>
                                        <td><b>Manganese1:</b></td>
                                        <td> ≤ 0.38%</td>
                                    </tr>
                                    <tr>
                                        <td><b>Nitrogen1:</b></td>
                                        <td>≤ 0.010%</td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>

    @if( $data['nxt_suitable'][0]['title'] )
    <section class="suitable">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <h6>{{ $data['nxt_suitable'][0]['title'] }} </h6>
                    <h2 class="mb-4">{{ $data['nxt_suitable'][0]['sub_title'] }}</h2>
                </div>
            </div>
        </div>
        <div class="threelidestagepadding owl-carousel owl-theme">
            @foreach($data['nxt_suitable'] as $nxt_suitable)
            <div class="item ">
            <img src="{{ asset('upload') }}/{{ $nxt_suitable['image'] }}" class="img-fluid">
            {!! $nxt_suitable['content'] !!}
            </div>
            @endforeach
        </div>
    </section>
    @endif

    <section class="become-partner differenceslider m-padg ">
    
    @if( $data['precision']['title'] )
        <div class="container">
            <div class="row pt-4">
                <div class="col-md-6">
                    <h6>{{ $data['precision']['title'] }}</h6>
                    <h2>{!! strip_tags( $data['precision']['sub_title'], '<br>') !!}</h2>
                </div>
                <div class="col-md-6">
                    {!! $data['precision']['content'] !!}
                </div>
            </div>
        </div>
    @endif
    @if( $data['step'][0]['title'] )
        <div class='slider ' id="businessslider">
            <ul class='slider-track'>
            @foreach($data['step'] as $step)
                <li class='slider-slide'>
                    <div class=" row">
                        <div class="col-md-5 justify-d-flex">
                            <h6>{{ $step['title'] }}</h6>
                            <h4>{{ $step['sub_title'] }}</h4>

                            {!! $step['content'] !!}

                        </div>
                        <div class="offset-md-1 col-md-6 col-sm-7">
                            <img src="{{ asset('upload') }}/{{ $step['image'] }}" class="img-fluid">
                        </div>
                    </div>
                </li>
            @endforeach

            </ul>
        </div>
        @endif
        @if( $data['step'][0]['title'] )
        <nav class="slider-interface">
            @foreach($data['step'] as $key=>$step)
            <button class='slider-dot' data-index='{{ $key }}'>
                <div>
                    <span></span>
                    <h6>{{ $step['title'] }}</h6>
                    <p>{{ $step['sub_title'] }}</p>
                </div>
            </button>
            @endforeach
        </nav>
        @endif
    </section>
    
    <section class="become-partner differenceslider m-padg " style="display: none;">
        <div class="container">

            <div class="row pt-4">
                <div class="col-md-6">
                    <h6>Crafted with Precision:aasa </h6>
                    <h2>The Kamdhenu NXT <br>Difference</h2>
                </div>
                <div class="col-md-6">
                    <p>Kamdhenu NXT TMT bars undergo a stringent, science-driven process to achieve their revolutionary
                        strength and reliability. Here’s how we engineer perfection:</p>
                </div>
            </div>

        </div>
        <div id="businessslider" class="oneslide  owl-carousel owl-theme">
            <div class="item row">
                <div class="col-md-5 justify-d-flex">
                    <h6>STEP 01</h6>
                    <h4>Thermex Technology: Quenching, Tempering & Cooling</h4>
                    <p>Water Pressure Optimization: Precision-controlled water jets adjust the pressure to harden the
                        outer surface while maintaining a ductile core, balancing robustness with flexibility.</p>
                    <p><b>Three Critical Stages:</b></p>
                    <ul>
                        <li>Quenching: Rapid cooling to create a hardened outer layer.</li>
                        <li>Tempering: Reheating to stabilize the core’s ductility.</li>
                        <li>Cooling: Natural air-cooling ensures structural integrity.</li>
                    </ul>
                    <p>result: A bar with unmatched tensile strength (585 N/mm²) and elongation (16%+), ready for
                        extreme loads.</p>
                </div>
                <div class="offset-md-1 col-md-6">
                    <img src="images/nxtslider.jpg" alt="" class="img-fluid">
                </div>
            </div>
            <div class="item row">
                <div class="col-md-5 justify-d-flex">
                    <h6>STEP 01</h6>
                    <h4>Thermex Technology: Quenching, Tempering & Cooling</h4>
                    <p>Water Pressure Optimization: Precision-controlled water jets adjust the pressure to harden the
                        outer surface while maintaining a ductile core, balancing robustness with flexibility.</p>
                    <p><b>Three Critical Stages:</b></p>
                    <ul>
                        <li>Quenching: Rapid cooling to create a hardened outer layer.</li>
                        <li>Tempering: Reheating to stabilize the core’s ductility.</li>
                        <li>Cooling: Natural air-cooling ensures structural integrity.</li>
                    </ul>
                    <p>result: A bar with unmatched tensile strength (585 N/mm²) and elongation (16%+), ready for
                        extreme loads.</p>
                </div>
                <div class="offset-md-1 col-md-6">
                    <img src="images/nxtslider.jpg" alt="" class="img-fluid">
                </div>
            </div>
            <div class="item row">
                <div class="col-md-5 justify-d-flex">
                    <h6>STEP 01</h6>
                    <h4>Thermex Technology: Quenching, Tempering & Cooling</h4>
                    <p>Water Pressure Optimization: Precision-controlled water jets adjust the pressure to harden the
                        outer surface while maintaining a ductile core, balancing robustness with flexibility.</p>
                    <p><b>Three Critical Stages:</b></p>
                    <ul>
                        <li>Quenching: Rapid cooling to create a hardened outer layer.</li>
                        <li>Tempering: Reheating to stabilize the core’s ductility.</li>
                        <li>Cooling: Natural air-cooling ensures structural integrity.</li>
                    </ul>
                    <p>result: A bar with unmatched tensile strength (585 N/mm²) and elongation (16%+), ready for
                        extreme loads.</p>
                </div>
                <div class="offset-md-1 col-md-6">
                    <img src="images/nxtslider.jpg" alt="" class="img-fluid">
                </div>
            </div>
            <div class="item row">
                <div class="col-md-5 justify-d-flex">
                    <h6>STEP 01</h6>
                    <h4>Thermex Technology: Quenching, Tempering & Cooling</h4>
                    <p>Water Pressure Optimization: Precision-controlled water jets adjust the pressure to harden the
                        outer surface while maintaining a ductile core, balancing robustness with flexibility.</p>
                    <p><b>Three Critical Stages:</b></p>
                    <ul>
                        <li>Quenching: Rapid cooling to create a hardened outer layer.</li>
                        <li>Tempering: Reheating to stabilize the core’s ductility.</li>
                        <li>Cooling: Natural air-cooling ensures structural integrity.</li>
                    </ul>
                    <p>result: A bar with unmatched tensile strength (585 N/mm²) and elongation (16%+), ready for
                        extreme loads.</p>
                </div>
                <div class="offset-md-1 col-md-6">
                    <img src="images/nxtslider.jpg" alt="" class="img-fluid">
                </div>
            </div>

        </div>
    </section>

    
    <section class="become-partner faqsection m-padg bg-gray">
        <div class="container">

            <div class="row pt-4">
                <div class="col-md-6 col-sm-12">
                    <h6>FAQ’s</h6>
                    <h2>Your Questions, <br>Answered</h2>
                </div>
                <div class="col-md-6 col-sm-12">
                    <div class="accordion accordion-flush pb-3" id="accordionFlushExample">
                    @if(isset($data['faq'][0]['title']))
                        @php
                            $class = "";
                            $area = "true";
                            $display = "show";
                        @endphp
                        @foreach($data['faq'] as $key=>$faq)

                        <div class="accordion-item rounded-3 border-0 shadow mb-2">
                            <h2 class="accordion-header">
                                <button class="accordion-button border-bottom {{ $class }} fw-semibold" type="button"
                                    data-bs-toggle="collapse" data-bs-target="#flush-collapse{{$key}}" aria-expanded="{{ $area }}"
                                    aria-controls="flush-collapse{{$key}}">
                                    {{ $faq['title'] }}
                                </button>
                            </h2>
                            <div id="flush-collapse{{$key}}" class="accordion-collapse collapse {{$display}}"
                                data-bs-parent="#accordionFlushExample">
                                <div class="accordion-body">
                                {!! $faq['content'] !!}
                                </div>
                            </div>
                        </div>
                    @php
                        $class = "collapsed";
                        $area = "false";
                        $display = "";
                    @endphp
            @endforeach
            @endif
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if(isset($data['building_dreams'][0]['title']))
    <section class="dreams">
        <div class="container">
            <div class="row">
                <div class="col-md-12 ">
                    <h6>Case studies</h6>
                    <h2 class="mb-5">Building Dreams, Proving<br> Results, With Trust</h2>
                </div>

                <div class="twoslidestagepadding owl-carousel owl-theme col-md-12">                
                @foreach($data['building_dreams'] as $key=>$building_dreams)
                    <div class="item">
                        <a href="#" class="casestudy">
                            <img src="{{ asset('upload') }}/{{$building_dreams['image']}}" class="img-fluid">
                            <div class="case-detail">
                                <h4>{{ $building_dreams['title'] }}</h4>
                                {!! $building_dreams['content'] !!}
                                <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                            </div>
                        </a>
                    </div>
                @endforeach                
                </div>
            </div>
        </div>
    </section>
    @endif
    <section class="become-partner m-padg">
        <div class="container">
            @if(isset($data['innovation']['title']))
            <div class="row">                
                <div class="col-md-5">
                    <h6>{{ $data['innovation']['title'] }}</h6>
                    <h2>{!! strip_tags( $data['innovation']['sub_title'], '<br>') !!}</h2>
                </div>
                <div class="offset-md-1 col-md-6">
                        {!! $data['innovation']['content'] !!}        
                        <a href="#" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Know </span><span
                            class="textred">More <i class="fa-solid fa-arrow-right-long"></i></span></a>
                </div>
            </div>
            @endif

            <div class="row nxt-counter" id="counter-box">
                @if(isset($data['innovation_grid'][0]['title']))
                    @foreach($data['innovation_grid'] as $innovation_grid)
                    <div class="four col-md-4">
                        <div class="counter_box colored">
                            <img src="{{ asset('upload') }}//{{ $innovation_grid['image'] }}" class="img-fluid">
                            <hr>
                            <h5>{!!  $innovation_grid['title'] !!}</h5>
                        </div>
                    </div>
                    @endforeach
                @endif
            </div>
            <div class="row bg-gray stronger">
                <div class="col-md-6">
                    <h2>Ready to Build Stronger?</h2>
                    <a href="" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Download</span><span
                            class="textred">Brochure <i class="fa-solid fa-arrow-right-long"></i></span></a>
                    <a href="" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Request a</span><span
                            class="textred">Quote Now <i class="fa-solid fa-arrow-right-long"></i></span></a>

                </div>
                <div class="offset-md-1 col-md-5">
                    <p>Contact us today for expert advice and personalized solutions for your construction needs.</p>
                </div>
            </div>
        </div>
    </section>
    <section class="kamdhenusteelbanner relative">
        <img src="{{ asset('front') }}/images/steelbanner.jpg" class="img-fluid">
        <div class="container absolute">
            <div class="row">
                <div class="col-md-12">
                    <div class="sustainabilitydata justifyend">
                        <h2> <a href="#" class="">Kamdhenu Structural Steel <i class="fa-solid fa-arrow-right-long"></i></a></h2>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')
<script type="text/javascript">
    $('.oneslide').owlCarousel({
        loop: true,
        margin: 30,
        dots: true,
        autoplayTimeout: 3000,
        nav: false,
        autoplay: true,
        items: 1,
    })
    $('.fourslidestagepadding').owlCarousel({
        loop: true,
        margin: 25,
        dots: false,
        autoplay: false,
        autoplayTimeout: 3000,
        nav: true,
        items: 4,
        navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        responsive: {
            0: {
                items: 1
            },
            728: {
                items: 2
            },
            960: {
                items: 3
            },
            1200: {
                items: 3.7
            },
            1800: {
                items: 4.2
            }
        }
    })
    $('.twoslidestagepadding').owlCarousel({
        loop: false,
        margin: 30,
        dots: false,
        autoplay: false,
        autoplayTimeout: 3000,
        nav: true,
        items: 4,
        navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        responsive: {
            0: {
                margin: 15,
                items: 1
            },
            728: {
                items: 2
            },
            960: {
                items: 2
            },
            1300: {
                items: 2
            }
        }
    })
    $('.threelidestagepadding').owlCarousel({
        loop: true,
        margin: 30,
        dots: false,
        autoplay: true,
        autoplayTimeout: 3000,
        nav: true,
        items: 4,
        navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        stagePadding: 50,
        responsive: {
            0: {
                items: 1,
                stagePadding: 20
            },
            728: {
                items: 2,
                stagePadding: 30
            },
            960: {
                items: 3,
                stagePadding: 40
            },
            1300: {
                items: 2.1,
                stagePadding: 150
            }
        }
    });
</script>
<script>
    $(document).ready(function() {
        var a = 0;
        $(window).scroll(function() {
            var oTop = $("#counter-box").offset().top - window.innerHeight;
            if (a == 0 && $(window).scrollTop() > oTop) {
                $(".counter").each(function() {
                    var $this = $(this),
                        countTo = $this.attr("data-number");
                    $({
                        countNum: $this.text()
                    }).animate({
                        countNum: countTo
                    }, {
                        duration: 3000,
                        easing: "swing",
                        step: function() {
                            //$this.text(Math.ceil(this.countNum));
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                        },
                        complete: function() {
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                            //alert('finished');
                        }
                    });
                });
                a = 1;
            }
        });
    });
    $(document).ready(function() {
        var a = 0;
        $(window).scroll(function() {
            var oTop = $("#counter-box1").offset().top - window.innerHeight;
            if (a == 0 && $(window).scrollTop() > oTop) {
                $(".counter1").each(function() {
                    var $this = $(this),
                        countTo = $this.attr("data-number");
                    $({
                        countNum: $this.text()
                    }).animate({
                        countNum: countTo
                    }, {
                        duration: 3000,
                        easing: "swing",
                        step: function() {
                            //$this.text(Math.ceil(this.countNum));
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                        },
                        complete: function() {
                            $this.text(
                                Math.ceil(this.countNum).toLocaleString("en")
                            );
                            //alert('finished');
                        }
                    });
                });
                a = 1;
            }
        });
    });
    // $(document).ready(function(){
    // $('.search').on('click', function(){
    // $('.input-box').addClass('open');
    // });
    // $('.close-icon').on('click', function(){
    // $('.input-box').removeClass('open');
    // });
    // });
    /*
    Animated text using 
    Animate.css https://daneden.github.io/animate.css/
    Wow.js  http://mynameismatthieu.com/WOW/

    View in live mode if on an iPad
    new WOW().init();
    */
</script>
<script type="text/javascript">
    const track = document.querySelector('.slider-track');
    const slides = document.querySelectorAll('.slider-slide');
    const dots = document.querySelectorAll('.slider-dot');
    let i;
    const reset = () => dots.forEach((dot) => dot.classList.remove('active'));

    function slideTo(n) {
        track.style.transform = `translateX(-${n * slides[0].offsetWidth}px)`;
        reset();
        dots[n].classList.add('active');
    }

    function activateArrows(direction) {
        direction === 'right' ? i++ : i--;
        if (i < 0) i = 0;
        if (i > slides.length - 1) i = slides.length - 1;
        slideTo(i);
    }

    function activateDots(e) {
        i = e.target.dataset.index;
        slideTo(i);
    }

    function activate(e) {
        e.target.matches('.slider-dot') && activateDots(e);
        e.target.matches('.arrow-right') && activateArrows('right');
        e.target.matches('.arrow-left') && activateArrows();
    }

    function init(n) {
        i = 0;
        slideTo(i);
    }
    document.addEventListener('click', activate, false);
    window.addEventListener('load', init, false);
</script>

@endsection

