@extends('front.layouts.main')
@section('main-container')

<div class="inner-banner">
  <img src="{{ asset('/upload/banner/')}}/{{ $banner['data'][0]['image'] }}" class="img-fluid">
  <div class="banner-text">
    <div class="container">
      <div class="row">
        <h6>{!! $banner['data'][0]['title'] !!}</h6>
        <h1>{!! strip_tags($banner['data'][0]['content'], '<br>') !!}</h1>
      </div>
    </div>
  </div>
</div>
<section class="inneroverview investor">
  <div class="container">
    <div class="row">
      <ul class="breadcrumb">
        <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
        <li class="active">Investor</li>
      </ul>
    </div>
  </div>
  <div class="container">
    <div class="row">
      <div class="col-md-3">

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" id="myTab" role="tablist">
          <li class="nav-item" role="presentation">
            <a href="javascript:void(0)" data-category-name="all" class="nav-link active" data-bs-toggle="tab"
              aria-selected="true"><img src="{{ asset('/front/images/long-arrow.png')}}"> All </a>
          </li>
          @if(isset($category['data']))
          @foreach($category['data'] as $cat)
          <li class="nav-item" role="presentation">
            <a href="javascript:void(0)" data-category-name="{{ $cat['category_name'] }}" class="nav-link" data-bs-toggle="tab"
              aria-selected="true"><img src="{{ asset('/front/images/long-arrow.png')}}"> {{ $cat['category_name'] }}
            </a>
          </li>
          @endforeach
          @endif
        </ul>
      </div>
      <div class="col-md-9">
        <div class="row">
          <div class="col-md-6">
            <h6>Kamdhenu’s</h6>
            <h2 class="page_category"></h2>
          </div>
          <div class="col-md-6 years_drop">
            @php
                $currentYear = date("Y");
                $years = range($currentYear, $currentYear - 9);
                echo '<select name="years" id="years">';
                foreach ($years as $year) {
                    echo '<option value="' . $year . '">' . $year . '</option>';
                }
                echo '</select>';
            @endphp
          </div>
        </div>
        <div class="row aj_filter">
        @foreach($investor['data'] as $inv)
          <div class="col-md-4">
              <a href="{{ asset('/upload/investor')}}/{{ $inv['pdf'] }}" target="_new" class="pdfdiv">
                <img src="{{ asset('/front/images/pdf-icon.png')}}">
                <p>{{ $inv['title'] }}</p>
              </a>
          </div>
        @endforeach
        </div>
      </div>
    </div>
</section>

@endsection

@section("js")
<script type="text/javascript">
  //Investor
$(document).ready(function(){

  function getUrlParams() {
    const params = new URLSearchParams(window.location.search);
    let result = {};
    for (const [key, value] of params.entries()) {
        result[key] = value;
    }
    return result;
  }


    const params = getUrlParams();
    const cat_name = params['category'];
    const year = params['year'] ? params['year'] : '2025';
    $('.nav-link[data-category-name!="' + cat_name + '"]').removeClass('active');
    if (typeof cat_name === "undefined") { 
      console.log('undefined');
    }else if (cat_name == "all"){
      console.log('all');
    }else{
      console.log(cat_name);
      $('.nav-link[data-category-name="' + cat_name + '"]').addClass('active');
      get_investor_data(cat_name, year);
    }

$('.nav-link').on('click', function(){
    var cat_name = $(this).data('category-name');
    
    var year = $('#years').val();

    var paramKey = 'category';
    var paramValue = cat_name;
    var currentUrl = new URL(window.location.href);
    currentUrl.searchParams.set(paramKey, paramValue);
    window.history.pushState({}, '', currentUrl);
    //console.log(currentUrl);
   
    get_investor_data(cat_name, year);
});

// $('.nav-link').on('click', function(){
$('#years').change(function(){ 
    var year = $(this).val();
    var activeMenuItem = $('#myTab .nav-item .nav-link.active');
    var cat_name = activeMenuItem.data('category-name');
    //console.log(cat_name);
    get_investor_data(cat_name, year);
});

function get_investor_data(cat_name=false, year=false) {
    //console.log(cat_name);
    //console.log(year);
    $.ajax({
        url: "{{url('/get_investor_data')}}",
        method: "post",
        data: {
            category_name: cat_name,
            year: year,
            _token: '{{csrf_token()}}'
        },
        success: function(response) {
            //console.log(response);
            if(cat_name != 'all'){
                $('h2').text(cat_name);
            }                
            $(".aj_filter").html(response);
        }
    });

}

});
</script>
@endsection