@extends('front.layouts.main')
@section('main-container')
<style type="text/css">
        .loader-div {
            display: none;
            position: fixed;
            margin: 0px;
            padding: 0px;
            right: 0px;
            top: 0px;
            width: 100%;
            height: 100%;
            background-color: #fff;
            z-index: 30001;
            opacity: 0.8;
        }
        .loader-img {
            position: absolute;
            top: 0;
            bottom: 0;
            left: 0;
            right: 0;
            margin: auto;
        }
    </style>
    <div class="inner-banner">
        <img src="{{ asset('front/images/aboutbanner.png') }}" class="img-fluid">
        <!-- <video autoplay muted loop playsinline preload="metadata">
            <source src="images/kamdhenu.mp4" type="video/mp4">
        </video> -->
        <div class="banner-text">
            <div class="container">
                <div class="row">
                    <h6>Transform Your Vision into Reality</h6>
                    <h1>Your Dreams'<br> Trusted Companion</h1>
                    <!-- <a href="" class="btn-primary wow animated fadeInDown" data-wow-duration="2s">Know <span class="textred">More <i class="fa-solid fa-arrow-right-long"></i></span></a> -->
                </div>
            </div>
        </div>
    </div>
    <section class="inneroverview">
        <div class="container">
            <div class="row">
                <ul class="breadcrumb">
                    <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                    <li class="active">Event</li>
                </ul>
            </div>
        </div>
        <div class="container">
            <div class="row">
                <div class="col-md-5 mb-2">
                    <h2>Latest Event</h2>
                </div>
                <div class="offset-md-1 col-md-6 mb-5">
           

            <select name="years" id="years">
                <option value="">Select Year {{ request()->segment(2) }}</option>
                @foreach(range(date('Y'), date('Y') - 5) as $year)
                    <option value="{{ $year }}" {{ request()->segment(2) == $year ? 'selected' : '' }}>
                        {{ $year }}
                    </option>
                @endforeach
            </select>
                </div>
                <div class="grid-data" id="dynamic_data"></div>
                <p class="text-center">
                    <a type="button" class="btn-primary wow animated fadeInRight" data-wow-duration="2s" onclick="display_data()"><span class="first-span">Load</span><span class="textred"> More <i class="fa-solid fa-arrow-right-long"></i></span></a>
                    <input type="hidden" id="rowcount" name="rowcount" value="0">
                </p>
            </div>
        </div>          
    </section>

    <div class="loader-div text-center">
        <img class="loader-img" src="{{ asset('/front/images/ajax-loader.gif') }}" style="height: 120px;width: auto;" />
    </div>

@endsection
@section('js')
<script type="text/javascript">
    display_data();
    function display_data() {
        var rowcount = $("#rowcount").val();
        var year = $("#years").val();
        if(year.length > 0){
            rowcount = 0;
        }
        // console.log("rowcount=" + rowcount);
        // console.log("year=" + year);
        $(".loader-div").show(); // show loader
        $.ajax({
            url: "{{url('/get-event-data')}}",
            method: "post",
            data: {
                rowcount: rowcount,
                year: year,
                _token: '{{csrf_token()}}'
            },
            dataType: 'json',
            success: function(response) {
                if (response.status == true) {
                    $("#rowcount").val(response.rowcount);
                    $('#dynamic_data').append(response.data);
                    $(".loader-div").hide(); // hide loader
                } else {
                    $(".loader-div").hide(); // hide loader
                    alert(response.msg);
                }
            },
            error: function(xhr, status) {
                $(".loader-div").hide(); // hide loader	
                console.log('ajax error = ' + xhr.statusText);
                alert(response.msg);
            }
        });
    }


$('#years').change(function() {
  window.location = "{{route('event')}}/" + $(this).val();
});
</script>
@endsection

