@extends('front.layouts.main')
@section('main-container')
<div class="inner-banner">
    @if( $data['banner']['id'] > 0 )
    <img src="{{ asset('/upload/banner/')}}/{{ $data['banner']['image'] }}" class="img-fluid">
    <div class="banner-text">
        <div class="container">
            <div class="row">
                <h6>{!! $data['banner']['title'] !!}</h6>
                <h1>{!! strip_tags( $data['banner']['content'], '<br>') !!}</h1>
            </div>
        </div>
    </div>
    @endif
</div>
<section class="inneroverview">
    <div class="container">
        <div class="row">
            <ul class="breadcrumb">
                <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                <li class="active">Contact Us</li>
            </ul>
        </div>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-md-3 col-sm-4">
                <h6>Overview</h6>
                <h2>Get In Touch</h2>
            </div>
            <div class="offset-md-1 col-md-8 col-sm-8">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <!-- <a aria-label="Close " ata-dismiss="alert" class="closed pull-right fa fa-times"></a> -->
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            
                <form method="POST" class="contact-form" id="submit_form_data" action="{{ url('submit-enquiry') }}">
                    @csrf
                <div class="row" id="counter-box">
                        <div class="col-md-4">
                            <input type="text" id="fname" name="fname" placeholder="Enter your Name" onkeypress="return nameValidater(event)">
                        </div>
                        <div class="col-md-4 ">
                            <input type="text" id="email" name="email" placeholder="Enter your Email">
                        </div>
                        <div class="col-md-4 relative">
                            <input type="text" id="phone" name="phone" placeholder="Enter your Phone no.">
                            <!-- <span class="absolute">+91</span> -->
                        </div>                       
                        <div class="col-md-4">
                            <select name="state" id="state">
                            <option value="">Select State</option>
                                @foreach($data['state'] as $states)                                
                                <option value="{{ $states['id'] }}">{{ $states['name'] }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4">
                            <div name=""  class="">
                                <select name="city" id="">
                                    <option value="">Select City</option>
                                    <div id="display_city"></div>                                    
                                </select>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <select name="subject" id="subject">
                                <option value="">Select Enquiry </option>
                                <option value="state">state</option>
                                <option value="subject">subject</option>
                            </select>
                        </div>
                        <div class="col-md-12">
                            <textarea id="message" name="message" rows="4" cols="50"
                                placeholder="Enter your Message"></textarea>
                        </div>
                        <div class="col-md-12">
                            <button type="submit" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Submit</span> <span
                                    class="textred">Now <i class="fa-solid fa-arrow-right-long"></i></span></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
</section>
<section class="reachus bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-3">
                <h6>Overview</h6>
                <h2>Reach us</h2>
            </div>

            <div class="offset-md-1 col-md-8">
                <div class="row">
                @if( $data['reg_add']['id'] > 0 )
                    <div class="col-md-12">
                        <h4>{!! $data['reg_add']['title'] !!}</h4>
                    </div>
                    <div class="col-md-6">
                    <div class="address">
                       {!! $data['reg_add']['content'] !!}
                       <a href="{{ $data['reg_add']['direction'] }}"><b>Get Direction</b> <i class="fa-solid fa-arrow-right-long"></i></a>
                       </div>
                    </div>
                @endif
                @if( $data['plant'][0]['id'] > 0 )
                    <div class="col-md-12">
                        <h4>{{ $data['plant'][0]['title'] }}</h4>
                    </div>
                    @foreach($data['plant'] as $plnt)
                    <div class="col-md-6">
                    <div class="address">
                    {!! $plnt['content'] !!}
                    <a href="{{ $plnt['direction'] }}"><b>Get Direction</b> <i class="fa-solid fa-arrow-right-long"></i></a>
                       </div>
                    </div>
                   @endforeach
                @endif
                </div>
            </div>
        </div>
    </div>
</section>
@if( $data['partner']['id'] > 0 )
<section class="become-partner">
    <div class="container">
        <div class="row bg-gray">
            <div class="col-md-5">
                <h2>{!! $data['partner']['title'] !!}</h2>
                <a href="{{ $data['partner']['direction'] }}" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Become A</span> <span
                        class="textred">Partner <i class="fa-solid fa-arrow-right-long"></i></span></a>
            </div>
            <div class="offset-md-1 col-md-6">
                {!! $data['partner']['content'] !!}
            </div>
        </div>
    </div>
</section>
@endif

@endsection
@section("js")
<!-- <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.4.0/jquery.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.1/jquery.validate.min.js"></script>
<script type="text/javascript" defer>
$(document).ready(function() {
//Get city by state id
$("#state").change(function() {
        let state_id = $('option:selected', this).val();
          if(state_id.length > 0)
          {            
            $.ajax({
                url: "{{ url('/get_city') }}",
                method: "POST",
                data: {
                    state_id: state_id,
                    _token: '{{csrf_token()}}'
                },
                success : function(response) {
                    $('#display_city').append(response);                   
                },error:function(e){
                   alert("error");
                }
            });

          }
    });


   

    

});

$(document).ready(function() {
    $('#name').on('keypress', function(event) {
        // Allow letters and a single space
        var key = event.which || event.keyCode;
        var keyChar = String.fromCharCode(key);

        if (!/[a-zA-Z ]/.test(keyChar) && key !== 8) {
            event.preventDefault();
        }
    });

    $('#phone').keyup(function () {
        if (this.value.length <= 10) {
            this.value = this.value.replace(/[^0-9\.]/g,'');
        } else {
            this.value = this.value.slice(0, -1);
            return false
        }
    });

});



// $("#submit_form_data").validate({
//               rules: {
//                name: {
//               required: true,
//               maxlength: 20,
//               },
//               mobile: {
//               required: true,
//               digits:true,
//               minlength: 10,
//               maxlength:12,
//               },
               
//               },
         
//               messages: {
//               name: {
//               required: "Please enter name",
//               },
//               mobile: {
//               required: "Please enter contact number",
//               digits: "Please enter only numbers",
//               minlength: "The contact number should be 10 digits",
//               maxlength: "The contact number should be 12 digits"
//               },
            
//               },
//               submitHandler: function(form) {
//               $.ajaxSetup({
//               headers: {
//               'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
//               }
//               });
             
//               $.ajax({
//                         url: '{{url('get-call')}}',
//                         method: "post",
//                         dataType:"json",
//                         data: {
//                             _token: '{{ csrf_token() }}',
//                             name:$("#name").val(),
//                             mobile:$("#mobile").val()
//                       },
//                         success: function (response) {
//                            $("#name").val(''),
//                        $("#mobile").val(''),
//                            swal(response.message,"Please click button","success");
//                         }
//                      });
         
         
//               }
//               });




    ////////////////////////
    $('#submit_form_data').validate({
            rules: {
                fname: {
                    required: true,
                },                
                email: {
                    required: true,
                },
                phone: {
                    required: true,
                    maxlength: 10,
                    minlength: 10,
                },
                state: {
                    required: true,
                },                
                city: {
                    required: true,
                },                
                subject: {
                    required: true,
                },                
                message: {
                    required: true,
                },                
            },
            messages: {
                fname: {
                    required: "Please enter name",
                    fname: "Please enter name",
                },                
                email: {
                    required: "Please enter email",
                    email: "Please enter valid email",
                },
                phone: {                   
                    required: "Please enter phone number",
                    maxlength: "Please enter 10 digit mobile number",
                    minlength: "Please enter Valid mobile number",
                },
                pnumber: {
                    required: "Please enter phone number",
                    maxlength: "Please enter 10 digit mobile number",
                    minlength: "Please enter Valid mobile number",
                }, 
                city: {
                    required: "Please select city name",
                    city: "Please select city name",
                }, 
                state: {
                    required: "Please select state name",
                    state: "Please select state name",
                },                
                subject: {
                    required: "Please select subject",
                    subject: "Please select subject",
                }, 
                message: {
                    required: "Please enter message",
                    message: "Please enter message",
                },
            },
            submitHandler: function(form) {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': {{ csrf_token() }}
                    }
                });
                $("#submit_form_data").attr("disabled", true);
                var formData = new FormData($('#submit_form_data')[0]);
                $.ajax({
                    url: "{{ route('submit-enquiry') }}",
                    type: "POST",
                    data: formData,
                    dataType: 'json',
                    //data: $('#add_lab_form').serialize(),
                    contentType: false,
                    cache: false,
                    processData: false,
                    success: function(res) {
                        if (res.status == 'success') {
                            $('#submit_form_data').trigger("reset");
                        } else {
                            

                        }
                    }
                });
            }
        });
    
      </script>
@endsection