@extends('front.layouts.main')
@section('main-container')
<section class="inneroverview positionunset pb-0">
    <div class="container">
        <div class="row">
            <div class="col-md-12">
                <ul class="breadcrumb">
                    <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                    <li><a href="{{ route('case-study') }}">Case Study <span> > </span></a></li>
                    <li class="active">Modern Office Complex, Gurugram</li>
                </ul>
            </div>
        </div>
    </div>
</section>

@if(isset($data['cs']['title']))
<section class="case-study-detail pt-0">
    <div class="container">
        <div class="row">
            <div class="col-md-12 mb-2">
                <img src="{{ asset('/upload/')}}/{{ $data['cs']['image'] }}" class="img-fluid">
                <h2>{{ $data['cs']['title'] }}</h2>
                    {!! $data['cs']['content'] !!}             

            </div>
        </div>
    </div>

</section>
@endif

<section class="pt-0">
    <div class="3lidestagepadding owl-carousel owl-theme">
        <div class="item ">
            <img src="{{ asset('front/images/casestudy-gallery.png') }}">
        </div>
        <div class="item ">
            <img src="{{ asset('front/images/casestudy-gallery.png') }}">
        </div>
        <div class="item ">
            <img src="{{ asset('front/images/casestudy-gallery.png') }}">
        </div>
        <div class="item ">
            <img src="{{ asset('front/images/casestudy-gallery.png') }}">
        </div>
</section>

@if(isset($data['related'][0]['title']))
<section class="pt-0">
    <div class="container">
        <div class="row">
            <div class="col-md-12 ">
                <h2 class="mb-4">Related Case Studies</h2>
            </div>
            <div class="twoslidestagepadding owl-carousel owl-theme ">
            @if(isset($data['related'][0]['title']))
            @foreach($data['related'] as $rel)
                <div class="item">
                    <a href="" class="casestudy">
                        <img src="{{ asset('/upload/')}}/{{ $rel['image'] }}" class="img-fluid">
                        <div class="case-detail">
                            <h4>{{ $rel['title'] }}</h4>
                             {{ $rel['content'] }}
                            <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                        </div>
                    </a>
                </div>              
                @endforeach
                @endif
            </div>
        </div>
    </div>
</section>
@endif

@endsection
@section("js")
<script type="text/javascript">
    $('.twoslidestagepadding').owlCarousel({
        loop: false,
        margin: 30,
        dots: false,
        autoplay:false,
        autoplayTimeout: 3000,
        nav: true,
        items: 4,
         navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        responsive:{
                0:{
                    items: 1
                },                
                728:{
                    items:2
                },
                960:{
                    items:2
                },
                1300:{
                    items:2

                }
            }
    })
$('.3lidestagepadding').owlCarousel({
    loop: true,
    margin: 30,
    dots: false,
    autoplay: true,
    autoplayTimeout: 3000,
    nav: false,
    items: 4,
    navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
    stagePadding: 50,
    responsive: {
        0: {
            items: 1,
            stagePadding: 20 
        },
        728: {
            items: 2,
            stagePadding: 30 
        },
        960: {
            items: 3,
            stagePadding: 40
        },
        1300: {
            items: 1.5,
            stagePadding: 300 
        }
    }
});

</script>
@endsection