@extends('front.layouts.main')
@section('main-container')
<?php
//print_r($data);
?>
@if($data['banner']['title'])
<div class="inner-banner">
    <img src="{{ asset('/upload/banner/')}}/{{ $data['banner']['image'] }}" class="img-fluid">
    <div class="banner-text">
        <div class="container">
            <div class="row">
                <h6>{{ $data['banner']['title'] }}</h6>
                <h1>{!! strip_tags($data['banner']['content'], '<br>') !!}</h1>
            </div>
        </div>
    </div>
</div>
@endif

<section class="inneroverview">
    <div class="container">
        <div class="row">
            <ul class="breadcrumb">
                <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                <li class="active">Case Study</li>
            </ul>
        </div>
    </div>
    <div class="container casestudy-page">
        <div class="row">
            <div class="col-md-4 mb-2">
                <h2>Case Studies</h2>
            </div>
            <div class="offset-md-1 col-md-7 mb-5">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="all-tab" data-bs-toggle="tab" href="#all" role="tab"
                            aria-controls="all" aria-selected="true"> All</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="commercial-tab" data-bs-toggle="tab" href="#commercial" role="tab"
                            aria-controls="commercial" aria-selected="false">Commercial</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="residential-tab" data-bs-toggle="tab" href="#residential" role="tab"
                            aria-controls="residential" aria-selected="false">Residential</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="industrial-tab" data-bs-toggle="tab" href="#industrial" role="tab"
                            aria-controls="industrial" aria-selected="false">Industrial</a>
                    </li>

                </ul>
            </div>
            <div class="tab-content" id="myTabContent">
                <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
                    <div class="row">

                    @if(isset($data['all'][0]['title']))
                            @foreach($data['all'] as $all)
                            <div class="col-md-6">
                                <a href="{{ route('case-study-detail') }}/{{ $all['id'] }}" class="casestudy">
                                    <img src="{{ asset('/upload/')}}/{{ $all['image'] }}" class="img-fluid">
                                    <div class="case-detail">
                                        <h4>{{ $all['title'] }}</h4>
                                        {!! $all['content'] !!}
                                        <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        @endif                       
                        
                    </div>
                </div>
                <div class="tab-pane fade" id="commercial" role="tabpanel" aria-labelledby="commercial-tab">
                    <div class="row">

                        @if(isset($data['commercial'][0]['title']))
                            @foreach($data['commercial'] as $com)
                            <div class="col-md-6">
                                <a href="{{ route('case-study-detail') }}/{{ $com['id'] }}" class="casestudy">
                                    <img src="{{ asset('/upload/')}}/{{ $com['image'] }}" class="img-fluid">
                                    <div class="case-detail">
                                        <h4>{{ $com['title'] }}</h4>
                                        {!! $com['content'] !!}
                                        <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        @endif
                     
                    </div>
                </div>
                <div class="tab-pane fade" id="residential" role="tabpanel" aria-labelledby="residential-tab">
                    <div class="row">

                        @if(isset($data['residential'][0]['title']))
                            @foreach($data['residential'] as $res)
                            <div class="col-md-6">
                                <a href="{{ route('case-study-detail') }}/{{ $res['id'] }}" class="casestudy">
                                    <img src="{{ asset('/upload/')}}/{{ $res['image'] }}" class="img-fluid">
                                    <div class="case-detail">
                                        <h4>{{ $res['title'] }}</h4>
                                        {!! $res['content'] !!}
                                        <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        @endif

                    </div>
                </div>
                <div class="tab-pane fade" id="industrial" role="tabpanel" aria-labelledby="industrial-tab">
                    <div class="row">

                        @if(isset($data['industrial'][0]['title']))
                            @foreach($data['industrial'] as $ind)
                            <div class="col-md-6">
                                <a href="{{ route('case-study-detail') }}/{{ $ind['id'] }}" class="casestudy">
                                    <img src="{{ asset('/upload/')}}/{{ $ind['image'] }}" class="img-fluid">
                                    <div class="case-detail">
                                        <h4>{{ $ind['title'] }}</h4>
                                        {!! $ind['content'] !!}
                                        <span class="textred">View Case Study <i class="fa-solid fa-arrow-right-long"></i></span>
                                    </div>
                                </a>
                            </div>
                            @endforeach
                        @endif
                    
                    </div>
                </div>
          
            </div>
        </div>
    </div>

</section>
@endsection
@section("js")

@endsection