@extends('front.layouts.main')
@section('main-container')




<div class="inner-banner">
    <img src="{{ asset('/upload/banner/')}}/{{ $data['banner']['image'] }}" class="img-fluid">
    <!-- <video autoplay muted loop playsinline preload="metadata">
            <source src="images/kamdhenu.mp4" type="video/mp4">
        </video> -->
    <div class="banner-text">
        <div class="container">
            <div class="row">

                <h6>{!! $data['banner']['title'] !!}</h6>
                <h1>{!! strip_tags($data['banner']['content'], '<br>') !!}</h1>
                <!-- <a href="" class="btn-primary wow animated fadeInDown" data-wow-duration="2s">Know <span class="textred">More <i class="fa-solid fa-arrow-right-long"></i></span></a> -->
            </div>
        </div>
    </div>
</div>
<section class="inneroverview">
    <div class="container">
        <div class="row">
            <ul class="breadcrumb">
                <li><a href="{{ route('home')}}">Home <span> > </span></a></li>
                <li class="active">Career</li>
            </ul>
        </div>
    </div>
    <div class="container">
        @if(isset($data['overview']['title']))
        <div class="row">
            <div class="col-md-5">
                <h6>{!! $data['overview']['title'] !!}</h6>
                <h2>{!! $data['overview']['sub_title'] !!}</h2>

            </div>
            <div class="offset-md-1 col-md-6">
                {{ $data['overview']['content'] }}
            </div>
        </div>
        @endif
        @if(isset($data['suboverview'][0]['title']))
        <div class="row careerdiv" id="counter-box">
            @foreach($data['suboverview'] as $subover)
            <div class="four col-md-4">
                <div class="counter_box colored">
                    <img src="{{ asset('/upload/')}}/{{ $subover['image'] }}" class="img-fluid">
                    <hr>
                    <h5>{!! $subover['title'] !!}</h5>
                    {{ $subover['content'] }}
                </div>
            </div>
            @endforeach
        </div>
        @endif
    </div>

</section>
<section class="culturesection bg-gray">
    <div class="container">
        <div class="row">
            <div class="col-md-5">
                <h6>Kamdhenu’s</h6>
                <h2>Culture & Ethics</h2>
            </div>
            <div class="offset-md-1 col-md-6">
                <ul class="nav nav-tabs" id="myTab" role="tablist">
                    <li class="nav-item" role="presentation">
                        <a class="nav-link active" id="home-tab" data-bs-toggle="tab" href="#home" role="tab"
                            aria-controls="home" aria-selected="true"> Core Values</a>
                    </li>
                    <li class="nav-item" role="presentation">
                        <a class="nav-link" id="profile-tab" data-bs-toggle="tab" href="#profile" role="tab"
                            aria-controls="profile" aria-selected="false">Ethical Practices</a>
                    </li>
                </ul>
            </div>
        </div>
    </div>

    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
            <div class="fourslidestagepadding owl-carousel owl-theme">
             @if(isset($data['coreculture'][0]['title']))
                @foreach($data['coreculture'] as $core)
                <div class="item ">
                    <div class="caltural">
                    <img src="{{ asset('/upload/')}}/{{ $core['image'] }}" class="img-fluid">
                        <h4>{{ $core['title'] }}</h4>
                        {{ $core['content'] }}
                    </div>
                </div>
                @endforeach
            @endif
            </div>
        </div>
        <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
            <div class="fourslidestagepadding owl-carousel owl-theme">

                @if(isset($data['ethicalculture'][0]['title']))
                @foreach($data['ethicalculture'] as $core)
                <div class="item ">
                    <div class="caltural">
                    <img src="{{ asset('/upload/')}}/{{ $core['image'] }}" class="img-fluid">
                        <h4>{{ $core['title'] }}</h4>
                        {{ $core['content'] }}
                    </div>
                </div>
                @endforeach
                @endif
                
            </div>
        </div>
    </div>
    </div>
</section>
<section class="become-partner m-padg">
    <div class="container">
        <div class="row ">
            <div class="col-md-4">
                <h6>Overview</h6>
                <h2>Open Positions</h2>
            </div>
            <!-- <div class="offset-md-1 col-md-7">
                <div class="row">
                    <div class="col-md-4">
                        <input type="text" name="search" class="search-field" placeholder="Search..">
                    </div>
                    <div class="col-md-4">
                        <select name="state" id="state">
                            <option value="Job Division">Job Division</option>
                            <option value="Job Division">Job Division</option>
                        </select>
                    </div>
                    <div class="col-md-4">
                        <select name="state" id="state">
                            <option value="Locations">Locations</option>
                            <option value="Locations">Locations</option>
                        </select>
                    </div>

                </div>
            </div> -->
        </div>
        <div class="row">
            <div class="accordion accordion-flush pb-3" id="accordionFlushExample">
                @if(isset($data['open-position'][0]['title']))
                @php
                    $class = "";
                    $area = "true";
                    $display = "show";
                @endphp
                @foreach($data['open-position'] as $key=>$op)
                <div class="accordion-item rounded-3 border-0 shadow mb-2">
                    <h2 class="accordion-header">
                    <button class="accordion-button border-bottom fw-semibold {{ $class }}" type="button"
                            data-bs-toggle="collapse" data-bs-target="#flush-collapse{{ $key }}" aria-expanded="true"
                            aria-controls="flush-collapse{{ $key }}">
                        {{ $op['title'] }}
                    </button>
                    </h2>
                    <div id="flush-collapse{{ $key }}" class="accordion-collapse collapse {{$display}}" data-bs-parent="#accordionFlushExample">
                        <div class="accordion-body">
                            <div class="row">
                                <div class="col-md-10 col-sm-12">                                 
                                {{ $op['content'] }}
                                </div>
                                <div class="col-md-2 col-sm-12 justify-end">
                                    <a href="" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Apply</span>
                                        <span class="textred">Now <i
                                                class="fa-solid fa-arrow-right-long"></i></span></a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
               
                @php
                    $class = "collapsed";
                    $area = "false";
                    $display = "";
                @endphp
            @endforeach
            @endif
            </div>
        </div>

        @if(isset($data['skills']['title']))
        <div class="row bg-gray mt-5">
            <div class="col-md-5">
                <h2>{{ $data['skills']['title'] }}</h2>
                <a href="#" class="btn-primary wow animated fadeInDown" data-wow-duration="2s"><span class="first-span">Send your</span> <span
                        class="textred">resume <i class="fa-solid fa-arrow-right-long"></i></span></a>
            </div>
            <div class="offset-md-1 col-md-6">
            {{ $data['skills']['content'] }}
            </div>
        </div>
        @endif
    </div>
</section>
@endsection
@section("js")
<script type="text/javascript">

     $('.fourslidestagepadding').owlCarousel({
        loop: true,
        margin: 30,
        dots: false,
        autoplay:false,
        autoplayTimeout: 3000,
        nav: true,
        items: 4,
         navText: ["<i class='fa-solid fa-arrow-left'></i>", "<i class='fa-solid fa-arrow-right'></i>"],
        responsive:{
                0:{
                    items: 1
                },                
                728:{
                    items:2
                },
                960:{
                    items:3
                },
                1300:{
                    items:4.5

                }
            }
    })
</script>
<script>
    $(document).ready(function() {
    var a = 0;
$(window).scroll(function () {
var oTop = $("#counter-box").offset().top - window.innerHeight;
if (a == 0 && $(window).scrollTop() > oTop) {
$(".counter").each(function () {
var $this = $(this),
countTo = $this.attr("data-number");
$({
countNum: $this.text()
}).animate(
{
    countNum: countTo
},

{
    duration: 3000,
    easing: "swing",
    step: function () {
        //$this.text(Math.ceil(this.countNum));
        $this.text(
            Math.ceil(this.countNum).toLocaleString("en")
        );
    },
    complete: function () {
        $this.text(
            Math.ceil(this.countNum).toLocaleString("en")
        );
        //alert('finished');
    }
}
);
});
a = 1;
}
});

    
    });
      $(document).ready(function() {
    var a = 0;
$(window).scroll(function () {
var oTop = $("#counter-box1").offset().top - window.innerHeight;
if (a == 0 && $(window).scrollTop() > oTop) {
$(".counter1").each(function () {
var $this = $(this),
countTo = $this.attr("data-number");
$({
countNum: $this.text()
}).animate(
{
    countNum: countTo
},

{
    duration: 3000,
    easing: "swing",
    step: function () {
        //$this.text(Math.ceil(this.countNum));
        $this.text(
            Math.ceil(this.countNum).toLocaleString("en")
        );
    },
    complete: function () {
        $this.text(
            Math.ceil(this.countNum).toLocaleString("en")
        );
        //alert('finished');
    }
}
);
});
a = 1;
}
});

    
    });

// $(document).ready(function(){
// $('.search').on('click', function(){
// $('.input-box').addClass('open');
// });
// $('.close-icon').on('click', function(){
// $('.input-box').removeClass('open');
// });
// });


/*
Animated text using 
Animate.css https://daneden.github.io/animate.css/
Wow.js  http://mynameismatthieu.com/WOW/

View in live mode if on an iPad
new WOW().init();
*/


</script>
@endsection