@extends('layouts.main')
@section('main-container')
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Edit Sub Category</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('update_sub_category') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row"> 
              <div class="form-group">
                  <label class="form-label" for="inputAddress">Parent Category Name</label>
                  <select name="category_id" class="form-control" required="">
                    <option value="">Select</option>
                    @foreach($category as $cat)
                    <option value="{{$cat->id}}" @if($cat->id == $sub_category->category_id) selected  @endif>{{$cat->category_name}}</option>
                    @endforeach
                  </select>
                </div>                
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Sub Category Name</label>
                  <input type="text" name="name" value="{{$sub_category->sub_category_name}}" class="form-control" required="" />
                </div>       
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Sort Order</label>
                  <input type="number" name="Sorting" value="{{$sub_category->sort_order}}"  value="0" class="form-control" id="number" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                          <option value="2" <?php if($sub_category->status == 2){echo 'selected';} ?>>Draft</option>
                          <option value="1" <?php if($sub_category->status == 1){echo 'selected';} ?>>Enable</option>
                          <option value="0" <?php if($sub_category->status == 0){echo 'selected';} ?>>Disable</option>
                        </select>
                </div>

                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection