@extends('layouts.main')
@section('main-container')
@section('style')
<style>
  canvas {
    max-height: 50px;
  }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Edit Banner</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <!-- <a aria-label="Close " ata-dismiss="alert" class="closed pull-right fa fa-times"></a> -->
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif

            <form action="{{ route('update_banner') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">
              <div class="form-group">
                <label class="form-label" for="inputAddress">Display</label>
                    <select name="display" class="form-control" id="status" required>
                        <option value="">--Select--</option>
                        <option value="home_process" {{ $banner->name == 'home' ? 'selected' : "" }}>Home</option>
                        <option value="home_career" {{ $banner->name == 'about' ? 'selected' : "" }}>About</option>                               
                        <option value="investor" {{ $banner->name == 'investor' ? 'selected' : "" }}>Investor</option>                               
                        <option value="contact" {{ $banner->name == 'contact' ? 'selected' : "" }}>Contact</option>                               
                        <option value="career" {{ $banner->name == 'career' ? 'selected' : "" }}>Career</option>                               
                        <option value="blog" {{ $banner->name == 'blog' ? 'selected' : "" }}>Blog</option>                               
                        <option value="success_story" {{ $banner->name == 'success_story' ? 'selected' : "" }}>Success Story</option>                               
                        <option value="media_coverage" {{ $banner->name == 'media_coverage' ? 'selected' : "" }}>Media Coverage</option>                               
                        <option value="csr" {{ $banner->name == 'csr' ? 'selected' : "" }}>CSR</option>                               
                        <option value="partner_program" {{ $banner->name == 'partner_program' ? 'selected' : "" }}>Partner Program</option>                          
                        <option value="nxt" {{ $banner->name == 'nxt' ? 'selected' : "" }}>NXT</option>                          
                        <option value="case_study" {{ $banner->name == 'case_study' ? 'selected' : "" }}>Case Study</option>                          
                    </select>
                </div>

                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" value="{{ $banner->title }}" class="form-control" required="" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Description</label>
                  <textarea class="form-control" name="description" id="pc-tinymce-4" rows="3"  required="">{{ $banner->content }}</textarea>
                </div>  
 
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="bannerImage">Banner Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control"/>
                  </div>
                  <div class="col-lg-6">
                    <div class="media"><img src="{{asset('/upload/banner')}}/{{$banner->image}}" class="img-responsive" width="50" height="50"></div>
                    <canvas id="canv1"></canvas>             
                  </div>
                  </div>

                  <div class="form-group row">
                  <div class="col-lg-6">
                    <!-- <canvas id="canv1"></canvas> -->
                    <label class="form-label" for="inputAddress">Is Mobile Banner?</label>
                      <select name="banner_for" class="form-control" id="banner_for">
                        <option value="No" <?php if($banner->status == 'No'){echo 'selected';} ?>>No</option>
                        <option value="Yes" <?php if($banner->status == 'Yes'){echo 'selected';} ?>>Yes</option>
                      </select>
                  </div>
                </div>

                <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Sort Order</label>
                  <input type="number" name="sorting" value="{{$banner->sort_order}}" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                      <label class="form-label" for="inputAddress">Status</label>
                        <select name="status" class="form-control" id="status">
                          <option value="2" <?php if($banner->status == 2){echo 'selected';} ?>>Draft</option>
                          <option value="1" <?php if($banner->status == 1){echo 'selected';} ?>>Enable</option>
                          <option value="0" <?php if($banner->status == 0){echo 'selected';} ?>>Disable</option>
                        </select>
                </div>
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" value="{{$banner->meta_title}}" class="form-control" id="slug" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control">{{$banner->meta_descripton}}</textarea>
                </div>
                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Update" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
    function upload(){
      $('.media').hide();
      var imgcanvas = document.getElementById("canv1");
      var fileinput = document.getElementById("finput");
      var image = new SimpleImage(fileinput);
      image.drawTo(imgcanvas);
    }
</script>
@endsection