@extends('layouts.main')
@section('main-container')
<style>
canvas {
      max-height: 50px;
    }
</style>
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ breadcrumb ] start -->
    
    <!-- [ breadcrumb ] end -->

    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Update</h2>
          </div>
          <div class="card-body">
          @if(Session::has('message'))
          <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close " data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
          </div>
          @endif
          <form action="{{ url('admin/update_policy') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
            @csrf
            <div class="form-group">
                    <label class="form-label" for="inputAddress">Type</label>
                    <select name="type" class="form-control" id="type" required>
                      <option value="">select</option>
                      <option value="privacy_policy" <?php if($policy->type == 'privacy_policy'){echo 'selected';} ?>>Privacy Policy</option>
                      <option value="disclaimer" <?php if($policy->type == 'disclaimer'){echo 'selected';} ?>>Disclaimer</option>
                    </select>
                  </div>
              <div class="row">         
                <div class="form-group">
                        <label class="form-label" for="inputAddress">Title</label>
                        <input type="text" name="title" value="{{$policy->title}}" class="form-control" id="" focusout="create_slug(this.value)" required=""/> 
                </div>
                <div class="form-group">
                        <label class="form-label" for="inputAddress">Slug</label>
                        <input type="text" name="slug" value="{{$policy->slug}}" class="form-control" id="slug" required=""/> 
                </div>
 
                  <!-- <div class="form-group">               
                        <label class="form-label" for="content">Content</label>                 
                        <textarea id="" name="content" class="form-control" required=""></textarea>
                  </div> -->
                  <div class="form-group">               
                        <label class="form-label" for="content">Content</label>                 
                        <textarea id="pc-tinymce-4" name="content" class="tox-target">{{$policy->content}}</textarea>
                  </div> 
                    <div class="form-group row">
                      <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Image</label>
                        <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file" class="form-control" />
                      </div>
                      <div class="col-lg-6">
                        <div class="media"><img src="{{asset('/upload')}}/{{$policy->image}}" class="img-responsive" width="50" height="50"></div>
                        <canvas id="canv1"></canvas>
                      </div>
                    </div>


                  
                    <div class="form-group row">
                    
                <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Sorting</label>
                        <input type="number" name="Sorting" value="{{$policy->sort_order}}" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Status</label>
                        <select name="status" class="form-control" id="status">
                          <option value="2" <?php if($policy->status == 2){echo 'selected';} ?>>Draft</option>
                          <option value="1" <?php if($policy->status == 1){echo 'selected';} ?>>Enable</option>
                          <option value="0" <?php if($policy->status == 0){echo 'selected';} ?>>Disable</option>
                        </select>
                </div> 
                </div> 
                
                <div class="form-group">
                        <label class="form-label" for="inputAddress">Meta Title</label>
                        <input type="text" name="m_title" value="{{$policy->meta_title}}" class="form-control" id="" /> 
                </div>
                <div class="form-group">
                        <label class="form-label" for="inputAddress">Meta Description</label>
                        <textarea id="" name="m_desc" class="form-control">{{$policy->meta_description}}</textarea>
                </div>
               
                  <div class="form-group">  
                        <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                        <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                  </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
    function upload(){
      $('.media').hide();
      var imgcanvas = document.getElementById("canv1");
      var fileinput = document.getElementById("finput");
      var image = new SimpleImage(fileinput);
      image.drawTo(imgcanvas);
    }
</script>
@endsection