@extends('layouts.main')
@section('main-container')
<style>
  canvas {
    max-height: 50px;
  }
</style>
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Update</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ url('admin/update_page_content') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">
              <div class="form-group">
                <label class="form-label" for="inputAddress">Display</label>
                    <select name="display" class="form-control" id="status" required>
                        
                        <option value="landingpage" {{ $page_content->name == 'landingpage' ? 'selected' : "" }}>Landing Page One</option>
                        <option value="landingpage2" {{ $page_content->name == 'landingpage2' ? 'selected' : "" }}>Landing Page Two</option>
                        <option value="landingpage3" {{ $page_content->name == 'landingpage3' ? 'selected' : "" }}>Landing Page Three</option>
                         <option value="landingpage4" {{ $page_content->name == 'landingpage4' ? 'selected' : "" }}>Landing Page Four</option>
                    </select>
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" value="{{$page_content->title}}" class="form-control" id="" required="" />
                </div> 
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Sub Title</label>
                  <input type="text" name="sub_title" value="{{$page_content->sub_title}}" class="form-control" id="" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target">{{$page_content->content}}</textarea>
                </div>
                <div class="form-group row">
                      <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Image</label>
                        <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file" class="form-control" />
                      </div>
                      <div class="col-lg-6">
                        <div class="media"><img src="{{asset('/upload')}}/{{$page_content->image}}" class="img-responsive" width="50" height="50"></div>
                        <canvas id="canv1"></canvas>
                      </div>
                    </div>

                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Text One</label>
                    <input type="text" name="tone" class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Text Two</label>
                    <input type="text" name="ttwo" class="form-control" />
                  </div>
                </div>
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Text Three</label>
                    <input type="text" name="tthree" class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Text Four</label>
                    <input type="text" name="tfour" class="form-control" />
                  </div>
                </div>

                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Sorting</label>
                    <input type="number" name="Sorting" value="{{$page_content->sort_order}}" class="form-control"
                      id="number" />
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Status</label>
                    <select name="status" class="form-control" id="status">
                      <option value="2" <?php if($page_content->status == 2){echo 'selected';} ?>>Draft</option>
                      <option value="1" <?php if($page_content->status == 1){echo 'selected';} ?>>Enable</option>
                      <option value="0" <?php if($page_content->status == 0){echo 'selected';} ?>>Disable</option>
                    </select>
                  </div>
                </div>

                <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" class="form-control" value="{{$page_content->meta_title}}" />
                </div>
                </div>
                
                <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control">{{$page_content->meta_description}}</textarea>
                </div>
              </div>

                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Update" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    $('.media').hide();
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection