@extends('layouts.main')
@section('main-container')
@section('style')
<link rel="stylesheet" href="{{asset('/assets/drop/comboTreeStyle.css')}}" />
<style>
    li.ct-item-child span {
      display: list-item;
      margin-left : 2em;
      list-style-type: circle;
    }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Edit Investor</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('update_investor') }}/{{$investor->id}}" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="Parent">Investor Zone</label>
                  <input type="hidden" name="treevalue_hidden" value="{{$investor->category_name}}">
                  <input type="text" name="treevalue" value="{{$investor->category_name}}"
                    class="form-control ct-input-box" id="justAnotherInputBox"
                    placeholder="{{$investor->category_name}}" autocomplete="off" />
                </div>
              </div>

              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="type">Content Type</label>
                  <select name="type_of_content" class="form-control onchangetype" id="status" required>
                    <option value="">Select</option>
                    <option value="text" @if($investor->type_of_content == 'text'){{ 'selected'}} @endif>Text</option>
                    <option value="pdf" @if($investor->type_of_content == 'pdf'){{ 'selected'}}  @endif>PDF</option>
                    <option value="url" @if($investor->type_of_content == 'url'){{ 'selected'}}  @endif>URL</option>
                  </select>
                </div>
              </div>
         
              <div class="form-group row display_Content @if($investor->type_of_content != 'text'){{ 'default_display'}} @endif">
                <div class="col-lg-12">
                  <label class="form-label" for="Content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target">{{$investor->content}}</textarea>
                </div>
              </div>

              <div class="form-group row display_pdf_url @if($investor->type_of_content != 'pdf' && $investor->type_of_content != 'url'){{ 'default_display' }} @endif">
                
                <div class="col-lg-6">
                  <label class="form-label" for="title">Title</label>
                  <input type="text" name="title" value="{{$investor->title}}" class="form-control" />
                </div>
   
                <div class="col-lg-6 display_url @if($investor->type_of_content != 'url'){{ 'default_display' }} @endif">
                  <label class="form-label" for="url">URL</label>
                  <input type="text" name="url" value="{{$investor->url}}" class="form-control" id="number" />
                </div>
      
                <div class="col-lg-6 display_pdf @if($investor->type_of_content != 'pdf'){{ 'default_display' }} @endif">
                  <label class="form-label" for="pdf">PDF</label>
                  <input type="file" name="pdffile" class="form-control" id="number" />
                </div>
             
              </div>
            
              <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="status">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="2" @if($investor->status == '2'){{ 'selected'}} @endif>Draft</option>
                    <option value="1" @if($investor->status == '1'){{ 'selected'}} @endif>Enable</option>
                    <option value="0" @if($investor->status == '0'){{ 'selected'}} @endif>Disable</option>
                  </select>
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="sort order">Sort Order</label>
                  <input type="number" name="sorting" value="{{$investor->sort_order}}" class="form-control"
                    id="number" />
                </div>
              </div>
              <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" value="{{$investor->meta_title}}" class="form-control" id="slug" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control">{{$investor->meta_description}}</textarea>
                </div>
              <div class="form-group">
                <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                <input type="submit" name="submit" value="Update" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="{{asset('/assets/drop/comboTreePlugin.js')}}" type="text/javascript"></script>

<?php
   $cat_json = "";
    if(isset($category_dropdown) && count($category_dropdown) > 0)
    {
        $cat_json = json_encode($category_dropdown);
    }
  ?>

<script type="text/javascript">
  const SampleJSONData = JSON.parse('<?php echo $cat_json; ?>');
  var comboTree1, comboTree2, comboTree3;
  jQuery(document).ready(function($) {
    comboTree1 = $("#justAnInputBox").comboTree({
      source: SampleJSONData,
      isMultiple: true,
      cascadeSelect: false,
      collapse: false,
      selectAll: true,
    });
    comboTree3 = $("#justAnInputBox1").comboTree({
      source: SampleJSONData,
      isMultiple: true,
      cascadeSelect: true,
      collapse: false,
    });
    // comboTree3.setSource(SampleJSONData2);
    comboTree2 = $("#justAnotherInputBox").comboTree({
      source: SampleJSONData,
      isMultiple: false,
    });
    comboTree1.toggleDropDown();
  });


  $(document).ready(function(){
       // $('.display_pdf_url').hide();
        //$(".display_Content").hide();
        $(".default_display").hide();
      $('.onchangetype').on('change', function() {
        let type = $('option:selected', this).val();
    
        if( type == 'text' ){
          $('.display_pdf_url').hide();
          $('.display_pdf').hide();
          $(".display_Content").show();
                    
        }
        if( type == 'pdf' ){
          $(".display_Content").hide();
          $('.display_url').hide(); 
          $('.display_pdf_url').show();        
          $('.display_pdf').show();        
        }
        if( type == 'url' ){
          $(".display_Content").hide();
          $('.display_pdf').hide(); 
          $('.display_pdf_url').show();        
          $('.display_url').show();        
        }
      });
      });
    </script>
@endsection