@extends('layouts.main')
@section('main-container')
@section('style')
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Update</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
                        <form action="{{ route('update_faq') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="title">Question</label>
                  <input type="text" name="question" value="{{ $faq->question }}" class="form-control" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Answer</label>
                  <textarea id="pc-tinymce-4" name="answer" class="tox-target">{{ $faq->answer }}</textarea>
                </div>
              </div>

              <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Image</label>
                  <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                    class="form-control" />
                </div>

                <div class="col-lg-6">
                  <div class="media">
                    @if(!empty($faq->image))
                    <img src="{{asset('/upload')}}/{{$faq->image}}" class="img-responsive" width="50" height="50">
                    @endif
                  </div>
                  <canvas id="canv1"></canvas>
                </div>
              </div>

              <div class="form-group row">
              <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Sorting</label>
                  <input type="number" name="Sorting" value="{{$faq->sort_order}}" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="0" <?php if($faq->status == 0){echo 'selected';} ?>>Disable</option>
                    <option value="1" <?php if($faq->status == 1){echo 'selected';} ?>>Enable</option>
                    <option value="2" <?php if($faq->status == 2){echo 'selected';} ?>>Draft</option>
                  </select>
                </div>    
              </div>

              <div class="form-group text-center">
                <input type="submit" name="submit" value="Update" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection