@extends('layouts.main')
@section('main-container')
<style>
  canvas {
    max-height: 50px;
  }
</style>
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Update</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ url('admin/update_case_study') }}/{{ $id }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="type">Newsletter Type</label>
                  <select name="type_of_newsletter" class="form-control onchangetype" id="type_of_newsletter" required>
                    <option value="">Select</option>
                    <option value="commercial" <?php if($case_study->name == 'commercial'){echo 'selected';} ?>> Commercial </option>
                    <option value="residential" <?php if($case_study->name == 'residential'){echo 'selected';} ?>> Residential </option>
                    <option value="industrial" <?php if($case_study->name == 'industrial'){echo 'selected';} ?>> Industrial</option>
                  </select>
                </div>
              </div>
              <div class="row">
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" value="{{$case_study->title}}" class="form-control" id="" required="" />
                </div>
       

                <div class="form-group">
                  <label class="form-label" for="content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target">{{$case_study->content}}</textarea>
                </div>
                <div class="form-group row">
                      <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Image</label>
                        <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file" class="form-control" />
                      </div>
                      <div class="col-lg-6">
                        <div class="media"><img src="{{asset('/upload')}}/{{$case_study->image}}" class="img-responsive" width="50" height="50"></div>
                        <canvas id="canv1"></canvas>
                      </div>
                    </div>
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Sorting</label>
                    <input type="number" name="Sorting" value="{{$case_study->sort_order}}" class="form-control" id="number" />
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Status</label>
                    <select name="status" class="form-control" id="status">
                      <option value="2" <?php if($case_study->status == 2){echo 'selected';} ?>>Draft</option>
                      <option value="1" <?php if($case_study->status == 1){echo 'selected';} ?>>Enable</option>
                      <option value="0" <?php if($case_study->status == 0){echo 'selected';} ?>>Disable</option>
                    </select>
                  </div>
                </div>

                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    $('.media').hide();
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection