@extends('layouts.main')
@section('main-container')
@section('style')
<link rel="stylesheet" href="{{asset('/assets/drop/comboTreeStyle.css')}}" />
<style>
    li.ct-item-child span {
      display: list-item;
      margin-left : 2em;
      list-style-type: circle;
    }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Update</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('update_about') }}/{{$about->id}}" method="POST" enctype="multipart/form-data">
              @csrf    
              <div class="form-group row">
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Select Page Section</label>
                  <select name="name" class="form-control" required="">
                    <option value="">Select</option>
                    <option value="about" @if($about->name == 'about'){{ 'selected'}} @endif>About</option>
                    <option value="message" @if($about->name == 'message'){{ 'selected'}} @endif>Message</option>
                    <option value="vision" @if($about->name == 'vision'){{ 'selected'}} @endif>Vision</option>
                    <option value="mission" @if($about->name == 'mission'){{ 'selected'}} @endif>Mission</option>
                    <option value="philosophy" @if($about->name == 'philosophy'){{ 'selected'}} @endif>Philosophy</option>
                    <option value="philosophy_bottom" @if($about->name == 'philosophy_bottom'){{ 'selected'}} @endif>Philosophy Bottom Grid</option>
                    <option value="director" @if($about->name == 'director'){{ 'selected'}} @endif>Director</option>
                    <option value="director_grid" @if($about->name == 'director_grid'){{ 'selected'}} @endif>Director Grid</option>
                  </select>
                </div>

                <div class="col-lg-12">
                  <label class="form-label" for="title">Title</label>
                  <input type="text" name="title" value="{{ $about->title }}" class="form-control" />
                </div>
              </div>
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="title">Sub Title</label>
                  <input type="text" name="sub_title" value="{{ $about->sub_title }}" class="form-control" />
                </div>
                
                <div class="col-lg-12">
                  <label class="form-label" for="Content"><br>Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target">{{ $about->content }}</textarea>
                </div>
              </div>

              <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="status">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="1" @if($about->status == '1'){{ 'selected'}} @endif>Enable</option>
                    <option value="0" @if($about->status == '0'){{ 'selected'}} @endif>Disable</option>
                  </select>
                </div>
                <div class="form-group row">
                      <div class="col-lg-6">
                        <label class="form-label" for="inputAddress">Image</label>
                        <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file" class="form-control" />
                      </div>
                      <div class="col-lg-6">
                        <div class="media">@if($about->image)<img src="{{asset('/upload')}}/{{$about->image}}" class="img-responsive" width="50" height="50">@endif</div>
                        <canvas id="canv1"></canvas>
                      </div>
                    </div>
                
              <div class="form-group">
                <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                <input type="submit" name="submit" value="Update" class="btn btn-primary" />
              </div>                
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    $('.media').hide();
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection