@extends('layouts.main')
@section('main-container')
@section('style')
<style>
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Story</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ url('admin/store_story') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">
              <div class="form-group">
                    <label class="form-label" for="inputAddress">Select Option</label>
                    <select name="name" class="form-control" required="">
                      <option value="">Select</option>
                      <option value="overview">Overview</option>
                      <option value="overview_slider">Overview Slider</option>                
                    </select>
                  </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" class="form-control" id="" required="" />
                </div>

                <div class="form-group">
                  <label class="form-label" for="content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target"></textarea>
                </div>
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <canvas id="canv1"></canvas>
                  </div>
                </div>
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Sorting</label>
                    <input type="number" name="Sorting" class="form-control" id="number" />
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Status</label>
                    <select name="status" class="form-control" id="status">
                      <option value="2">Draft</option>
                      <option value="1" selected>Enable</option>
                      <option value="0">Disable</option>
                    </select>
                  </div>
                </div>
              
                <div class="form-group">
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection