@extends('layouts.main')
@section('main-container')
@section('style')
<style>
  canvas {
    max-height: 50px;
  }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Add Banner</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <!-- <a aria-label="Close " ata-dismiss="alert" class="closed pull-right fa fa-times"></a> -->
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif

            <form action="{{ route('store_banner') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">
              <div class="form-group">
                <label class="form-label" for="inputAddress">Display</label>
                    <select name="pagename" class="form-control" id="status" required>
                      <option value="">--Select--</option>
                      <option value="home">Home</option>
                      <option value="about">About</option>           
                      <option value="investor">Investor</option>           
                      <option value="contact">Contact</option>           
                      <option value="career">Career</option>           
                      <option value="blog">Blog</option>           
                      <option value="success_story">Success Story</option>           
                      <option value="media_coverage">Media Coverage</option>
                      <option value="partner_program">Partner Program</option> 
                      <option value="csr">CSR</option>        
                      <option value="nxt">nxt</option>       
                      <option value="case_study">Case Study</option>       
                    </select>
                </div> 
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" class="form-control" required="" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Description</label>
                  <!-- <textarea class="form-control" name="description" id="description" rows="3"  required=""></textarea> -->
                  <textarea id="pc-tinymce-4" name="description" class="tox-target"></textarea>
                </div>  

                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="bannerImage">Banner Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control" required="" />
                  </div>
                  <div class="col-lg-6">
                    <!-- <canvas id="canv1"></canvas> -->
                    <label class="form-label" for="inputAddress">Is Mobile Banner?</label>
                      <select name="banner_for" class="form-control" id="banner_for">
                        <option value="No" selected>No</option>
                        <option value="Yes">Yes</option>
                      </select>
                  </div>
                </div>

                <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Sort Order</label>
                  <input type="number" name="sorting" value="" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="2">Draft</option>
                    <option value="1" selected>Enable</option>
                    <option value="0">Disable</option>
                  </select>
                </div>
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" class="form-control" id="slug" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control"></textarea>
                </div>
                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection