@extends('layouts.main')
@section('main-container')
@section('style')
<style>
  canvas {
    max-height: 50px;
  }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Create</h2>
          </div> 
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ url('admin/store_partner_program') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Select Section</label>
                  <select name="name" class="form-control" required="">
                    <option value="">Select</option>                   
                    <option value="overview_left">Overview Left</option>
                    <option value="overview_right">Overview Right</option>
                    <option value="benefits">Benefits</option>
                  </select>
                </div>

                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" class="form-control" id="title_slug"
                    focusout="create_slug(this.value)" required="" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Sub Title</label>
                  <input type="text" name="sub_title" class="form-control"/>
                </div>

                <div class="form-group" style="display:none">
                  <label class="form-label" for="inputAddress">Slug</label>
                  <input type="text" name="slug" class="form-control" id="slug" readonly required="" />
                </div>

                <!-- <div class="form-group">               
                        <label class="form-label" for="content">Content</label>                 
                        <textarea id="" name="content" class="form-control" required=""></textarea>
                  </div> -->
                <div class="form-group">
                  <label class="form-label" for="content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target"></textarea>
                </div>

                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control"/>
                  </div>
                  <div class="col-lg-6">
                    <canvas id="canv1"></canvas>
                  </div>
                </div>

                <div class="form-group row">
                  <!-- <div class="col-lg-4">
                    <label class="form-label" for="inputAddress">Display Date</label>
                    <input type="date" name="display_date" class="form-control" id="" />
                  </div> -->

                  
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Status</label>
                    <select name="status" class="form-control" id="status">
                      <option value="2">Draft</option>
                      <option value="1" selected>Enable</option>
                      <option value="0">Disable</option>
                    </select>
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Sorting</label>
                    <input type="number" name="Sorting" class="form-control" id="number" />
                  </div>
                </div>

                  <!-- <div class="form-group">
                    <label class="form-label" for="inputAddress">Meta Title</label>
                    <input type="text" name="m_title" class="form-control" id="slug" />
                  </div>
                  <div class="form-group">
                    <label class="form-label" for="inputAddress">Meta Description</label>
                    <textarea id="" name="m_desc" class="form-control"></textarea>
                  </div> -->

                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection