@extends('layouts.main')
@section('main-container')
@section('style')
<link rel="stylesheet" href="{{asset('/assets/drop/comboTreeStyle.css')}}" />
<style>
    li.ct-item-child span {
      display: list-item;
      margin-left : 2em;
      list-style-type: circle;
    }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Create</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('store_newsletter') }}" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="type">Newsletter Type</label>
                  <select name="type_of_newsletter" class="form-control onchangetype" required>
                    <option value="">Select</option>
                    <option value="newsletter"> Newsletter </option>
                    <option value="tv-commercials"> TV Commercials </option>
                    <option value="e-coverage"> e-Coverage</option>
                    <option value="print-coverage">Print Coverage</option>
                    <option value="corporate-film"> Corporate Film </option>
                    <option value="kamdhenu-film">Kamdhenu Film </option>
                  </select>
                </div>
              </div>             

            <div class="form-group display_one">
            <div class="row">
              <div class="col-lg-12">
                <label class="form-label" for="title">Title</label>
                <input type="text" name="title" value="" class="form-control" />
              </div>       
              <div class="col-lg-6">
                <label class="form-label" for="pdf">Image</label>
                <input type="file" name="imagefile" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                <label class="form-label" for="pdf">PDF</label>
                <input type="file" name="pdffile" value="" class="form-control" />
              </div>
            </div>
            </div>

            <div class="form-group row display_two">
              <div class="col-lg-12">
                <label class="form-label" for="url">URL (Image or Video)</label>
                <input type="text" name="url" value="" class="form-control" />
              </div>   
            </div>

            <div class="form-group row display_three">
              <div class="col-lg-12">
                <label class="form-label" for="url">Link</label>
                <input type="text" name="url_link" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                <label class="form-label" for="url">Source</label>
                <input type="text" name="source" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                <label class="form-label" for="url">e-Coverage Image</label>
                <input type="file" name="coverage_img" value="" class="form-control" />
              </div>
            </div>

            <div class="form-group row display_four">
              <div class="col-lg-6">
                <label class="form-label" for="url">Publication</label>
                <input type="text" name="publication_link" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                <label class="form-label" for="url">Edition</label>
                <input type="text" name="edition_source" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                <label class="form-label" for="url">Date</label>
                <input type="date" name="news_date" value="" class="form-control" />
              </div>
              <div class="col-lg-6">
                  <label class="form-label" for="pdf">Image</label>
                  <input type="file" name="cov_image" value="" class="form-control" />
                </div>
            </div>
              <div class="form-group row">
                <div class="col-lg-4">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="2">Draft</option>
                    <option value="1" selected>Enable</option>
                    <option value="0">Disable</option>
                  </select>
                </div>

                <div class="col-lg-8">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" class="form-control" id="" />
                </div>
              </div>
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control"></textarea>
                </div>
              </div>
              <div class="form-group">
                <input type="submit" name="submit" value="Create" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="{{asset('/assets/drop/comboTreePlugin.js')}}" type="text/javascript"></script>

   <?php
   $cat_json = "";
    if(isset($category_dropdown) && count($category_dropdown) > 0)
    {
        $cat_json = json_encode($category_dropdown);
    }
  ?>
   <script type="text/javascript">

      $(document).ready(function(){
            $('.display_one').hide();
            $(".display_two").hide();
            $(".display_three").hide();
            $(".display_four").hide();

          $('.onchangetype').on('change', function() {
            
            let type = $('option:selected', this).val();
          
            if( type == 'newsletter' ){
                $('.display_one').show();
                $(".display_two").hide();
                $(".display_three").hide();
                $(".display_four").hide();
            }
            if( type == 'tv-commercials' || type == 'corporate-film' || type == 'kamdhenu-film'){
                $('.display_one').hide();
                $(".display_two").show();
                $(".display_three").hide();
                $(".display_four").hide();         
            }
            if( type == 'e-coverage' ){
                $('.display_one').hide();
                $(".display_two").hide();
                $(".display_three").show();
                $(".display_four").hide();         
            }
           
            if( type == 'print-coverage' ){
                $('.display_one').hide();
                $(".display_two").hide();
                $(".display_three").hide();
                $(".display_four").show();          
            }
          
          });
      });
    </script>
@endsection