@extends('layouts.main')
@section('main-container')
@section('style')
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Create</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('store_media') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="title">Title</label>
                  <input type="text" name="title" value="" class="form-control" />
                </div>
              </div>
         
              <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <canvas id="canv1"></canvas>
                  </div>
                </div>

                <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="title">URL</label>
                  <input type="text" name="url" value="" class="form-control" />
                </div>               
              </div>
              <div class="form-group row">
              <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Status</label>
                    <select name="status" class="form-control" id="status">
                      <option value="2">Draft</option>
                      <option value="1" selected>Enable</option>
                      <option value="0">Disable</option>
                    </select>
                  </div>
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Sorting</label>
                    <input type="number" name="Sorting" class="form-control" id="number" />
                  </div>

                </div>

              <div class="form-group">
                <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                <input type="submit" name="submit" value="Create" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection