@extends('layouts.main')
@section('main-container')
@section('style')
<style>
  canvas {
    max-height: 50px;
  }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Add Kamdhenu NXT</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif

            <form action="{{ route('store_kamdhenu_nxt') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">              
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Title</label>
                  <input type="text" name="title" class="form-control" required="" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Description</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target"></textarea>
                </div>
                <div class="form-group row">
                <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <canvas id="canv1"></canvas>
                  </div>
                </div>              
                </div>
                <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Sort Order</label>
                  <input type="number" name="sorting" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="0">Disable</option>
                    <option value="1" selected>Enable</option>                    
                    <option value="2">Draft</option>
                  </select>
                </div>
                </div>               
                <div class="form-group text-center">
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection