@extends('layouts.main')
@section('main-container')
@section('style')
<link rel="stylesheet" href="{{asset('/assets/drop/comboTreeStyle.css')}}" />
<style>
    li.ct-item-child span {
      display: list-item;
      margin-left : 2em;
      list-style-type: circle;
    }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Create Investor</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('store_investor') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="Parent">Investor Zone</label>
                  <input type="text" name="treevalue" value="" class="form-control" id="justAnotherInputBox" placeholder="Select Investor Zone" autocomplete="off" required/>                 
                </div>
                </div>
                <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="type">Content Type</label>
                  <select name="type_of_content" class="form-control onchangetype" id="status" required>
                    <option value="">Select</option>
                    <option value="text">Text</option>
                    <option value="pdf">PDF</option>
                    <option value="url">URL</option>
                  </select>
                </div>
              </div>

              <div class="form-group row display_Content">
                <div class="col-lg-12">
                  <label class="form-label" for="Content">Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target"></textarea>
                </div>
              </div>

              <div class="form-group row display_pdf_url">
                <div class="col-lg-6">
                  <label class="form-label" for="title">Title</label>
                  <input type="text" name="title" value="" class="form-control" />
                </div>                

                <div class="col-lg-6 display_url">
                  <label class="form-label" for="url">URL</label>
                  <input type="text" name="url" value="" class="form-control" id="number" />
                </div>

                <div class="col-lg-6 display_pdf">
                  <label class="form-label" for="pdf">PDF</label>
                  <input type="file" name="pdffile" value="" class="form-control" id="number" />
                </div>
              </div>

              <div class="form-group row">
              <div class="col-lg-6">
                  <label class="form-label" for="status">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="2">Draft</option>
                    <option value="1" selected>Enable</option>
                    <option value="0">Disable</option>
                  </select>
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="sort order">Sort Order</label>
                  <input type="number" name="sorting" value="" class="form-control" id="number" />                  
                </div>                
              </div>
              <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Title</label>
                  <input type="text" name="m_title" class="form-control" id="slug" />
                </div>
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Meta Description</label>
                  <textarea id="" name="m_desc" class="form-control"></textarea>
                </div>
              <div class="form-group">
                <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                <input type="submit" name="submit" value="Create Investor" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="{{asset('/assets/drop/comboTreePlugin.js')}}" type="text/javascript"></script>

   <?php
   $cat_json = "";
    if(isset($category_dropdown) && count($category_dropdown) > 0)
    {
        $cat_json = json_encode($category_dropdown);
    }
  ?>
   <script type="text/javascript">
    const SampleJSONData  = JSON.parse('<?php echo $cat_json; ?>');
      var comboTree1, comboTree2, comboTree3;

      jQuery(document).ready(function ($) {
        comboTree1 = $("#justAnInputBox").comboTree({
          source: SampleJSONData,
          isMultiple: true,
          cascadeSelect: false,
          collapse: false,
          selectAll: true,
        });

        comboTree3 = $("#justAnInputBox1").comboTree({
          source: SampleJSONData,
          isMultiple: true,
          cascadeSelect: true,
          collapse: false,
        });

        // comboTree3.setSource(SampleJSONData2);

        comboTree2 = $("#justAnotherInputBox").comboTree({
          source: SampleJSONData,
          isMultiple: false,
        });

        comboTree1.toggleDropDown();
      });
      

      $(document).ready(function(){
        $('.display_pdf_url').hide();
        $(".display_Content").hide();
      $('.onchangetype').on('change', function() {
        let type = $('option:selected', this).val();
        if( type == 'text' ){
          $('.display_pdf_url').hide();
          $(".display_Content").show();          
        }
        if( type == 'pdf' ){
          $(".display_Content").hide();
          $('.display_url').hide(); 
          $('.display_pdf_url').show();        
          $('.display_pdf').show();        
        }
        if( type == 'url' ){
          $(".display_Content").hide();
          $('.display_pdf').hide(); 
          $('.display_pdf_url').show();        
          $('.display_url').show();        
        }
      });
      });
    </script>
@endsection