@extends('layouts.main')
@section('main-container')
@section('style')
<link rel="stylesheet" href="{{asset('/assets/drop/comboTreeStyle.css')}}" />
<style>
  li.ct-item-child span {
    display: list-item;
    margin-left: 2em;
    list-style-type: circle;
  }
</style>
@endsection
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Create</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible"><a aria-label="Close "
                data-dismiss="alert" class="closed pull-right fa fa-times"></a>
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('store_csr') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="form-group row">
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Select Page Section</label>
                  <select name="name" class="form-control" required="">
                    <option value="">Select</option>                   
                    <option value="csr_initiative">CSR Initiative</option>
                    <option value="csr_bottom">CSR Bottom</option>
                  </select>
                </div>
                <div class="col-lg-12">
                  <label class="form-label" for="title">Title</label>
                  <input type="text" name="title" value="" class="form-control" />
                </div>
              </div>
              <div class="form-group row">
                <div class="col-lg-12">
                  <label class="form-label" for="title">Sub Title</label>
                  <input type="text" name="sub_title" value="" class="form-control" />
                </div>
                
                <div class="col-lg-12">
                  <label class="form-label" for="Content"><br>Content</label>
                  <textarea id="pc-tinymce-4" name="content" class="tox-target"></textarea>
                </div>
              </div>

           
              <div class="form-group row">
                  <div class="col-lg-6">
                    <label class="form-label" for="inputAddress">Image</label>
                    <input type="file" onchange="upload()" multiple="false" accept="image/*" id="finput" name="file"
                      class="form-control" />
                  </div>
                  <div class="col-lg-6">
                    <canvas id="canv1"></canvas>
                  </div>
                </div>
              <div class="form-group">
                <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                <input type="submit" name="submit" value="Create" class="btn btn-primary" />
              </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection
@section('script')
<script src="https://www.dukelearntoprogram.com/course1/common/js/image/SimpleImage.js"></script>
<script type="text/javascript">
  function upload() {
    var imgcanvas = document.getElementById("canv1");
    var fileinput = document.getElementById("finput");
    var image = new SimpleImage(fileinput);
    image.drawTo(imgcanvas);
  }
</script>
@endsection