@extends('layouts.main')
@section('main-container')
<!-- [ Main Content ] start -->
<section class="pc-container">
  <div class="pc-content">
    <!-- [ Main Content ] start -->
    <div class="row">
      <div class="col-md-12">
        <div class="card">
          <div class="card-header">
            <h2>Add Category</h2>
          </div>
          <div class="card-body">
            @if(Session::has('message'))
            <div role="alert" class="alert {{ Session::get('alert-class') }} alert-dismissible">
              <!-- <a aria-label="Close " ata-dismiss="alert" class="closed pull-right fa fa-times"></a> -->
              <p>{{ Session::get('message') }}</p>
            </div>
            @endif
            <form action="{{ route('store_category') }}" id="" method="POST" enctype="multipart/form-data">
              @csrf
              <div class="row">              
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Parent Category</label>
                  <select name="parent_category_id" class="form-control get_sub_category" required="">                   
                    <option value="0">root</option>
                    @foreach($category as $cat)
                    <option value="{{$cat->id}}">{{$cat->category_name}}</option>
                    @endforeach
                  </select>
                </div>       
                <div class="form-group">
                  <label class="form-label" for="inputAddress">Category Name</label>
                  <input type="text" name="name" class="form-control" required="" />
                </div>       
                <div class="form-group row">
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Sort Order</label>
                  <input type="number" name="Sorting" value="" class="form-control" id="number" />
                </div>
                <div class="col-lg-6">
                  <label class="form-label" for="inputAddress">Status</label>
                  <select name="status" class="form-control" id="status">
                    <option value="2">Draft</option>
                    <option value="1" selected>Enable</option>
                    <option value="0">Disable</option>
                  </select>
                </div>
                </div>

                <div class="form-group">
                  <!-- <button type="submit" class="btn btn-primary">Create</button> -->
                  <input type="submit" name="submit" value="Create" class="btn btn-primary" />
                </div>
            </form>
          </div>
        </div>
      </div>
      <!-- [ form-element ] end -->
    </div>
  </div>
  <!-- [ Main Content ] end -->
</section>
<!-- [ Main Content ] end -->

@endsection