<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;


class WorkCultureController extends Controller
{

    public function index(){        
       //
    }
    public function add_work_culture(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_work_culture');
    }

    public function store_work_culture(Request $request)
    { 
        
        $getdata = DB::table('work_culture')->where('name', $request->name)->get();         
        if($request->name == 'overview' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('work_culture');
        }
        if($request->name == 'suboverview' && count($getdata) == 3){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('work_culture');
        }
        if($request->name == 'skills' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('work_culture');
        }

        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => $request->name,                    
                "title" => $request->title,                    
                "sub_title" => $request->sub_title,                           
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('work_culture')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('work_culture');
            
    }

    public function work_culture(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['work_culture'] = DB::table('work_culture')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_work_culture', $data);
    }


    public function edit_work_culture($id){
        $data['id'] = $id;
        $data['work_culture'] = DB::table('work_culture')->where('id', $id)->first();
        return view('edit_work_culture', $data);
    }

    public function update_work_culture(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => $request->name,
                "title" => $request->title,
                "sub_title" => $request->sub_title,                               
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('work_culture')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('work_culture');            
    }

    public function delete_work_culture($id){ 
        DB::table('work_culture')->where('id', $id)->delete();       
        return redirect()->route('work_culture');
    }

    //Frontend
        public function get_career_data(Request $request){
          
        $api_url = env('API_URL');
        $response = Http::get($api_url."career", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        
            return view('front.career', $resp);

    }


}
