<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\user;
use Hash;

class UserController extends Controller
{ 
    public function register_view(Request $request){
        return view('register');
    }
    public function register(Request $request){
        $validated = $request->validate([
            'name' => 'required|max:25',
            'email' => 'required|email|unique:users',
            'password' => 'required',
        ],
        [   
            'name.required' => 'Name is required',
            'email.required' => 'Email is required',
            'password.required' => 'Password is required',
        ]);

        $user = DB::table('users')->where('email', $request->email)->first();
        if($user){
            Session::flash('message', 'Email id already exist.');
            return view('register');
        } else if($request->password != $request->confirm_password){
            Session::flash('message', 'Password and confirm password mismatch.');
            return view('register');
        }else{
            $data = [
                'name' => $request->name, 
                'email' => $request->email,
                'password' => \Hash::make($request->password),
                'created_at' => date("Y-m-d H:i:s"),
                'updated_at' => date("Y-m-d H:i:s"),
            ];
        
            if(DB::table('users')->insert($data)){               
              $request->session()->regenerate();
              Session::flash('message', 'Register successfully..');
              return view('register');
            }else{
                Session::flash('message', 'Try again..'); 
                return view('register');
            } 
        }       

    }
    public function index(){
        if (Auth::check()==TRUE) {
            return redirect()->route('dashboard');
        }
        return view('login');
    }

    public function user_login(Request $request){
        // $this->validate(
        //     $request, 
        //     [   
        //         'username'  => 'required|email',
        //         'password'  => 'required'
        //     ],
        //     [   
        //         'username.required' => 'Username is required',
        //         'password.required' => 'Password is required',
        //     ]
        // );

        $validated = $request->validate([
            'username'  => 'required|email',
            'password'  => 'required'
        ],
        [   
            'username.required' => 'Username is required',
            'password.required' => 'Password is required',
        ]);
      
        $remember_me = $request->has('remember_me') ? true : false;
        $username = $request->post('username');
        $password = $request->post('password');

        if (Auth::attempt(['email' => $username, 'password' => $password], $remember_me)) {
            $request->session()->regenerate();
            Session::flash('message', 'Login successfully..'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('dashboard');  

        }else{
            Session::flash('message', 'Invalid credentials');
            Session::flash('alert-class', 'alert-danger');
            return redirect()->route('login'); 
        } 
    }
    public function logout(Request $request){ 	
        Session::flush();
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('login');      
    }

    public function getPassword(){
        return view('password');
    }

}
