<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;

class SuccessStoryController extends Controller
{

    public function index(){        
       //
    }
    public function add_story(){
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        return view('add_story');
    }

    public function store_story(Request $request)
    {
        $getdata = DB::table('policy')->where('type', $request->name)->get();         
        if($request->name == 'overview' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('story');
        }


        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "type" => $request->name,                    
                "title" => $request->title,                         
                "content" => $request->content,
                "image" => $filename, 
                "sort_order" => $request->Sorting,
                "sort_order" => $request->status,  
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('policy')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('story');
            
    }

    public function get_story(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['contacts'] = DB::table('policy')->whereIn('type', ['overview','overview_slider'])->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_story', $data);
    }


    public function edit_story($id){
        $data['id'] = $id;
        $data['story'] = DB::table('policy')->where('id', $id)->first();
        return view('edit_story', $data);
    }

    public function update_story(Request $request, $id)
    { 
  
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "type" => $request->name,                    
                "title" => $request->title,                         
                "content" => $request->content,
                "image" => $filename, 
                "sort_order" => $request->Sorting,
                "sort_order" => $request->status,  
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('policy')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('story');            
    }

    public function delete_story($id){ 
        DB::table('policy')->where('id', $id)->delete();       
        return redirect()->route('story');
    }

    //Frontend
    public function get_our_story(Request $request){
        
    $api_url = env('API_URL');
    $response = Http::get($api_url."get_our_story", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }

        return view('front.our_story', $resp);
    }


    


}
