<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use Hash;


class QualityInitiativeController extends Controller
{

    public function index(){        
       //
    }
    public function add_quality_initiative(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_quality_initiative');
    }

    public function store_quality_initiative(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                 
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('quality_initiative')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('quality_initiative');
            
    }

    public function quality_initiative(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['quality_initiative'] = DB::table('quality_initiative')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_quality_initiative', $data);
    }


    public function edit_quality_initiative($id){
        $data['id'] = $id;
        $data['quality_initiative'] = DB::table('quality_initiative')->where('id', $id)->first();
        return view('edit_quality_initiative', $data);
    }

    public function update_quality_initiative(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                    
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('quality_initiative')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('quality_initiative');            
    }

    public function delete_quality_initiative($id){ 
        DB::table('quality_initiative')->where('id', $id)->delete();       
        return redirect()->route('quality_initiative');
    }


}
