<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\user;
use Hash;


class ProgramController extends Controller
{

    public function index(){        
       //
    }

    public function partner_program(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['partner_program'] = DB::table('about')->whereIn('name', ['overview_left','overview_right','benefits'])->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_partner_program', $data);
    }
    public function add_partner_program(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_partner_program');
    }

    public function store_partner_program(Request $request)
    { 
        
        $getdata = DB::table('about')->where('name', $request->name)->get();         
        if($request->name == 'overview_left' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('partner_program');
        }
        if($request->name == 'overview_right' && count($getdata) == 4){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('partner_program');
        }
 
        
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => $request->name,
                "title" => $request->title, 
                "sub_title" => $request->sub_title, 
                "content" => $request->content,                                        
                "sort_order" => $request->Sorting,                    
                "image" => $filename,               
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('about')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('partner_program');
            
    }

    public function edit_partner_program($id){
        $data['id'] = $id;
        $data['blog'] = DB::table('about')->where('id', $id)->first();
        return view('edit_partner_program', $data);
    }

    public function update_partner_program(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => $request->name,
                "title" => $request->title,
                "sub_title" => $request->sub_title,                                                
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => $request->content,
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('about')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('partner_program');            
    }

    public function delete_partner_program($id){
        DB::table('about')->where('id', $id)->delete();       
        return redirect()->route('partner_program');
    }

    public function get_partner_program(Request $request){        
  
        $api_url = env('API_URL');
        $response = Http::get($api_url."get_partner", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.partner_program_view', $resp);
    }


}
