<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use Hash;


class PolicyController extends Controller
{

    public function index(){        
       //
    }
    public function add_policy(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_policy');
    }

    public function store_policy(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "type" => $request->type,                    
                "title" => $request->title,                    
                "slug" => $request->slug,                 
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('policy')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('policy');
            
    }

    public function policy(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['policy'] = DB::table('policy')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_policy', $data);
    }


    public function edit_policy($id){
        $data['id'] = $id;
        $data['policy'] = DB::table('policy')->where('id', $id)->first();
        return view('edit_policy', $data);
    }

    public function update_policy(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "type" => $request->type,                    
                "title" => $request->title,                    
                "slug" => $request->slug,                    
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('policy')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('policy');            
    }

    public function delete_policy($id){ 
        DB::table('policy')->where('id', $id)->delete();       
        return redirect()->route('policy');
    }


}
