<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;


class NxtController extends Controller
{

    public function get_nxt_data(Request $request){
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['nxt'] = DB::table('about')->whereIn('name', ['about_nxt','benefits','step','nxt_suitable','nxt_difference','building_dreams','faq','innovation','innovation_grid'])->orderBy('id', 'DESC')->get();       
        return view('view_nxt', $data);
    }

    public function add_nxt(Request $request){
        return view('add_nxt');
    }

    public function store_nxt(Request $request){
        $getdata = DB::table('about')->where('name', $request->name)->get();       
         if($request->name == 'nxt_bottom' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('nxt-data');
        }

        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,
            "content" => $request->content,
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename,
            "status" => 1,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('about')->insertGetId(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('nxt-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
         
    }

    public function edit_nxt($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['id'] = $id;
        $data['nxt'] = DB::table('about')->where('id', $id)->first();
        return view('edit_nxt', $data);
    }

    public function update_nxt(Request $request, $id){ 
           
        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,      
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "content" => $request->content,
            "image" => $filename,
            "status" => $request->status,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
        ];


        $respid = DB::table('about')->where('id', $id)->update(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('nxt-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
       
      
    }

    public function delete_nxt($id){ 
        DB::table('about')->where('id', $id)->delete();       
        return redirect()->route('nxt-data');
    }

    public function get_nxt(Request $request){        
  
        $api_url = env('API_URL');
        if(empty($api_url)){
            $api_url = 'https://ks.weaddo.live/api/';
            //$api_url = 'http://localhost/cms/public/api/';
        }
        $response = Http::get($api_url."get_nxt", []); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.nxt', $resp);
    }


    /////////////////////////////////////////////////////////////////////////////////
    public function get_case_study_data(Request $request){
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['case_study'] = DB::table('about')->whereIn('name', ['commercial','residential','industrial'])->orderBy('id', 'DESC')->get();       
        return view('view_case_study', $data);
    }

    public function add_case_study(Request $request){
        return view('add_case_study');
    }

    public function store_case_study(Request $request){

        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename); 
        }
        
        $data = [
            "name" => $request->name,
            "title" => $request->title,
            "content" => $request->content,
            "image" => $filename,
            "status" => $request->status,
            "sort_order" => $request->Sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s")
        ];

        $respid = DB::table('about')->insertGetId(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('case-study-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
         
    }

    public function edit_case_study($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['id'] = $id;
        $data['case_study'] = DB::table('about')->where('id', $id)->first();
        return view('edit_case_study', $data);
    }

    public function update_case_study(Request $request, $id){ 
           
        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,      
            "title" => $request->title,
            "content" => $request->content,
            "image" => $filename,
            "status" => $request->status,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('about')->where('id', $id)->update(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('case-study-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
       
      
    }

    public function delete_case_study($id){ 
        DB::table('about')->where('id', $id)->delete();       
        return redirect()->route('case-study-data');
    }

    public function get_case_study(Request $request){        
  
        $api_url = env('API_URL');
        if(empty($api_url)){
            //$api_url = 'https://ks.weaddo.live/public/api/';
            $api_url = 'http://localhost/cms/public/api/';
        }
        $response = Http::get($api_url."get_cstudy", []); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.case_study', $resp);
    }


    public function get_case_study_detail(Request $request){        
  
        $api_url = env('API_URL');
        if(empty($api_url)){
            //$api_url = 'https://ks.weaddo.live/public/api/';
            $api_url = 'http://localhost/cms/public/api/';
        }  
        $response = Http::get($api_url."get_case_study_detail", ['id'=>$request->id]); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.case_study_detail', $resp);
    }


}
