<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\user;
use Hash;

class NewsletterController extends Controller
{ 
    public function index(){        
        //
     }

     public function newsletter(){  
         
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['newsletter'] = DB::table('newsletter')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_newsletter', $data);
    }

     public function add_newsletter(){  
         if (Auth::check()==FALSE) {
             return redirect()->route('login');
         }     
         return view('add_newsletter');
     }
 
     public function store_newsletter(Request $request)
     { 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
         $filename = "";
         $pdffilename = "";
         $url = "";
         $source = "";
         $news_date = "";
         if($request->hasfile('imagefile')){
             $file = $request->file('imagefile');
             $extension = $file->getClientOriginalExtension();
             $filename = time().'.'.$extension;           
             $file->move('upload/newsletter', $filename);  
         }     
         else if($request->hasfile('coverage_img')){
             $file = $request->file('coverage_img');
             $extension = $file->getClientOriginalExtension();
             $filename = time().'.'.$extension;           
             $file->move('upload/newsletter', $filename);  
         }         
         else if($request->hasfile('cov_image')){
             $file = $request->file('cov_image');
             $extension = $file->getClientOriginalExtension();
             $filename = time().'.'.$extension;           
             $file->move('upload/newsletter', $filename);  
         } 
         else{}        
         if($request->hasfile('pdffile')){
            $pdffile = $request->file('pdffile');
            $pdffileextension = $pdffile->getClientOriginalExtension();
            $pdffilename = time().'.'.$pdffileextension;           
            $pdffile->move('upload/newsletter', $pdffilename);  
        }
          
        if(!empty($request->url)){
            $url = $request->url;
        }else if(!empty($request->url_link)){
            $url = $request->url_link;
        }else if(!empty($request->publication_link)){
            $url = $request->publication_link;
        }else{}

        if(!empty($request->source)){
            $source = $request->source;
        }
        else if(!empty($request->edition_source)){
            $source = $request->edition_source;
        }else{};
        if(!empty($request->news_date))
        {
            $news_date = date('Y-m-d', strtotime($request->news_date));
        }

         $data = [
                 "type_of_newsletter" => $request->type_of_newsletter,                    
                 "title" => $request->title ? $request->title : '',                    
                 "slug" => $request->type_of_newsletter,
                 "url" => $url,
                 "pdf" => $pdffilename,                     
                 "image" => $filename,
                 "source" => $source,
                 "news_date" => $news_date,                    
                 "meta_title" => $request->m_title,                    
                 "meta_description" => $request->m_desc,                                  
                 "updated_at" => date("Y-m-d H:i:s"),
                 "created_at" => date("Y-m-d H:i:s"),
             ];

         DB::table('newsletter')->insertGetId(array_filter($data));
         Session::flash('message', 'Created successfully.'); 
         Session::flash('alert-class', 'alert-success');
         return redirect()->route('newsletter');    
     }
 
     
 
 
     public function edit_newsletter($id){
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }

         $data['id'] = $id;
         $data['newsletter'] = DB::table('newsletter')->where('id', $id)->first();
         return view('edit_newsletter', $data);
     }
 
     public function update_newsletter(Request $request, $id)
     { 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $filename = "";
        $pdffilename = "";
        $url = "";
        $source = "";
        $news_date = "";
        if($request->hasfile('imagefile')){
            $file = $request->file('imagefile');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/newsletter', $filename);  
        }     
        else if($request->hasfile('coverage_img')){
            $file = $request->file('coverage_img');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/newsletter', $filename);  
        }         
        else if($request->hasfile('cov_image')){
            $file = $request->file('cov_image');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/newsletter', $filename);  
        } 
        else{}        
        if($request->hasfile('pdffile')){
           $pdffile = $request->file('pdffile');
           $pdffileextension = $pdffile->getClientOriginalExtension();
           $pdffilename = time().'.'.$pdffileextension;           
           $pdffile->move('upload/newsletter', $pdffilename);  
       }
         
       if(!empty($request->url)){
           $url = $request->url;
       }else if(!empty($request->url_link)){
           $url = $request->url_link;
       }else if(!empty($request->publication_link)){
           $url = $request->publication_link;
       }else{}

       if(!empty($request->source)){
           $source = $request->source;
       }
       else if(!empty($request->edition_source)){
           $source = $request->edition_source;
       }else{};
       if(!empty($request->news_date))
       {
           $news_date = date('Y-m-d', strtotime($request->news_date));
       }

        $data = [
                "type_of_newsletter" => $request->type_of_newsletter,                    
                "title" => $request->title ? $request->title : '',                    
                "slug" => $request->type_of_newsletter,
                "url" => $url,
                "pdf" => $pdffilename,                     
                "image" => $filename,
                "source" => $source,
                "news_date" => $news_date,                    
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('newsletter')->where('id', $id)->update(array_filter($data));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('newsletter');    
    }
 
 
 }
 