<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;


class MediaController extends Controller
{

    public function index(){
       //
    }
    public function add_media(){
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        return view('add_media');
    }

    public function store_media(Request $request)
    {

        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [                    
                "title" => $request->title,           
                "image" => $filename,                        
                "url" => $request->url,                           
                "sort_order" => $request->Sorting,
                "status" => $request->status,
                "display_date" => date("Y-m-d"),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('media')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('get_media');
            
    }

    public function get_media(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['media'] = DB::table('media')->orderBy('id', 'DESC')->get();
        return view('view_media', $data);
    }


    public function edit_media($id){
        $data['id'] = $id;
        $data['media'] = DB::table('media')->where('id', $id)->first();
        return view('edit_media', $data);
    }

    public function update_media(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [         
            "title" => $request->title,           
            "image" => $filename,                        
            "url" => $request->url,                           
            "sort_order" => $request->Sorting,
            "status" => $request->status,
            "updated_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('media')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('get_media');            
    }

    public function delete_media($id){ 
        DB::table('media')->where('id', $id)->delete();       
        return redirect()->route('media');
    }

    //Frontend
    public function media(){          
        return view('front.media_coverage');
    }

    public function get_media_data(Request $request){ 

        $year = $request["year"] ? $request["year"] : '';   
        $last_rowcount = $request["rowcount"];
        $rowcount = $request["rowcount"] + 6; 
  
        $api_url = env('API_URL');
        if(empty($api_url)){
            $api_url = 'https://ks.weaddo.live/api/';
            //$api_url = 'http://localhost/cms/public/api/';
        }
        $response = Http::get($api_url."media", ['last_rowcount' => $last_rowcount, 'year' => $year,]);

        if ($response->successful()) {
            $resp = $response->json(); 
        }
        if($last_rowcount == 0){
            $dynamic_data = "";
        }
        $count = count($resp['data']);
        if($count > 0){
            $dynamic_data = "";
            foreach($resp['data'] as $media) {
                $newDate = date("M d Y", strtotime($media['created_at']));
                $dynamic_data .=
                '<a target="_new" href="'.$media['url'] .'">
                    <img src="'. asset('/upload/').'/'.$media['image'].'" class="img-fluid" >
                    <h5>' . $media['title'] . '</h5>
                    <span>'. $newDate .'</span>
                </a>';       
            }            
       
            $data = [
                "status" => true,
                "rowcount" => $rowcount,
                "msg" => "Successfully!",
                "data" => $dynamic_data,
            ];
        } else {
            $data = [
                "status" => false,
                "msg" => "Error!",
            ];
        }
    echo json_encode($data);
    
    }


}
