<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;

class InvestorController extends Controller
{
    
    public function category(){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['category'] = DB::table('category')->get();       
        return view('category', $data);
    }
    public function add_category(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['category'] = DB::table('category')->where('parent', 0)->get();       
        return view('add_category',  $data);
    }
    public function store_category(Request $request){        
        
            $data = [
                "category_name" => $request->name,                       
                "parent" => $request->parent_category_id,                       
                "status" => $request->status,
                "sort_order" => $request->Sorting,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

            DB::table('category')->insertGetId($data);
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('add_category');

    }
    public function edit_category($id){  
        $data['id'] = $id;
        $data['category'] = DB::table('category')->where('id', $id)->first();

        return view('edit_category', $data);
    }
    public function update_category(Request $request, $id)
    { 
        $data = [
            "category_name" => $request->name,                       
            "status" => $request->status,
            "sort_order" => $request->Sorting,
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('category')->where('id', $id)->update(array_filter($data));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('category');           
    }
    // public function sub_category(){ 
    //     $data['sub_category'] = DB::table('sub_category')->get();        
    //     return view('sub_category', $data);
    // }

//     public function add_sub_category(){ 
//         $data['category'] = DB::table('category')->get();
//         $data['sub_category'] = DB::table('sub_category')->get();
//         return view('add_sub_category', $data);
//     }
//     public function store_sub_category(Request $request){        
        
//             $data = [
//                 "sub_category_name" => $request->name,                       
//                 "category_id" => $request->category_id,
//                 "status" => $request->status,
//                 "sort_order" => $request->Sorting,
//                 "updated_at" => date("Y-m-d H:i:s"),
//                 "created_at" => date("Y-m-d H:i:s"),
//             ];

//             DB::table('sub_category')->insertGetId($data);
//             Session::flash('message', 'Created successfully.'); 
//             Session::flash('alert-class', 'alert-success');
//             return redirect('/add_sub_category');

//     }
//     public function edit_sub_category($id){  
//         $data['id'] = $id;    

//         $data['category'] = DB::table('category')->where('status', 1)->get();
//         $data['sub_category'] = DB::table('sub_category')->where('id', $id)->first();       
 

//         return view('edit_sub_category', $data);
//     }
//     public function update_sub_category(Request $request, $id)
//     { 
//         $data = [
//             "category_id" => $request->category_id,                       
//             "sub_category_name" => $request->name,                       
//             "status" => $request->status,
//             "sort_order" => $request->Sorting,
//             "created_at" => date("Y-m-d H:i:s"),
//         ];

//         DB::table('sub_category')->where('id', $id)->update(array_filter($data));
//         Session::flash('message', 'Updated successfully.'); 
//         Session::flash('alert-class', 'alert-success');
//         return redirect('admin/sub_category');            
//     }

//     public function get_sub_category(Request $request){ 

//         $data = DB::table('sub_category')->select('category_id','id','sub_category_name')->where('category_id', $request->category)->get();  
//          if(count($data) > 0){
//              $html = '<option value="">Select</option>';
//              foreach($data as $c)
//              {
//                  $html .='<option value="'.$c->id.'">'.$c->sub_category_name.'</option>';
//              }
//               //dd($html);
//               echo $html;
//               //return $data;
//          }else{
//              return false;
//          }

//  }


    public function investor(Request $request){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['investor'] = DB::table('investor')->orderBY('id', 'DESC')->get();       
        return view('investor', $data);
    }


    public function add_investor(Request $request){ 
        $data['category'] = DB::table('category')->where('status', 1)->get();
        $list = [];
        $parent_category = DB::table('category')->where('parent', 0)->where('status', 1)->get();
        foreach($parent_category as $pc){            
            $child_category = DB::table('category')->where('parent', $pc->id)->where('status', 1)->get();
                $sub_list = [];
                if($child_category){
                    foreach($child_category as $cc){
                    $sub_list[] = [
                                    "id" => $cc->id, 
                                    "title" => $cc->category_name                                    
                                ];
                    }
                    $list[] = ["id"=>$pc->id, "title"=>$pc->category_name, "subs" => $sub_list];  
                }else{
                    $list[] = ["id"=>$pc->id, "title"=>$pc->category_name];
                }  
        }

        $data['category_dropdown'] = $list;
            
        return view('add_investor', $data);
    }

    public function store_investor(Request $request){ 

        $category = DB::table('category')->where('category_name', $request->treevalue)->first(); 
        
        
        $filename = "";
        if($request->hasfile('pdffile')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('pdffile');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/investor', $filename);  
        }

        $content = '';
        if($request->type_of_content == 'text'){
            $content = $request->content;
        }else if($request->type_of_content == 'pdf'){
            $content = $filename;
        }else if($request->type_of_content == 'url'){
            $content = $request->url;
        }
            

        $data = [
            "category_id" => $category->id,
            "category_name" => $request->treevalue,
            "slug" => str_replace(" ", "-",strtolower($request->treevalue)),
            "type_of_content" => $request->type_of_content,
            "content" => $content,
            "title" => $request->title,
            "url" => $request->url,
            "pdf" => $filename,
            "status" => $request->status,
            "sort_order" => $request->sorting,
            "meta_title" => $request->m_title,                    
            "meta_description" => $request->m_desc, 
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('investor')->insertGetId(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('investor'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
         
    }


    public function edit_investor($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['investor'] = DB::table('investor')->where('id', $id)->first();
        $data['category'] = DB::table('category')->where('status', 1)->get();
        $list = [];
        $parent_category = DB::table('category')->where('parent', 0)->where('status', 1)->get();
        foreach($parent_category as $pc){            
            $child_category = DB::table('category')->where('parent', $pc->id)->where('status', 1)->get();
                $sub_list = [];
                if($child_category){
                    foreach($child_category as $cc){
                    $sub_list[] = [
                                    "id" => $cc->id, 
                                    "title" => $cc->category_name                                    
                                ];
                    }
                    $list[] = ["id"=>$pc->id, "title"=>$pc->category_name, "subs" => $sub_list];  
                }else{
                    $list[] = ["id"=>$pc->id, "title"=>$pc->category_name];
                }  
        }

        $data['category_dropdown'] = $list;            
        return view('edit_investor', $data);
    }

    public function update_investor(Request $request, $id){ 
            if(!empty($request->treevalue)){
                $category = DB::table('category')->where('category_name', $request->treevalue)->first(); 
            }else{
                $category = DB::table('category')->where('category_name', $request->treevalue_hidden)->first();
            }
        
        $filename = "";
        if($request->hasfile('pdffile')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('pdffile');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/investor', $filename);  
        }
 
        $content = '';
        if($request->type_of_content == 'text'){
            $content = $request->content;
        }else if($request->type_of_content == 'pdf'){
            $content = $filename;
        }else if($request->type_of_content == 'url'){
            $content = $request->url;
        }
        
        $data = [
            "category_id" => $category->id,
            "category_name" => $request->treevalue,
            "type_of_content" => $request->type_of_content,
            "content" => $content,
            "title" => $request->title,
            "url" => $request->url,
            "pdf" => $filename,
            "status" => $request->status,
            "meta_title" => $request->m_title,                    
            "meta_description" => $request->m_desc,
            "sort_order" => $request->sorting,
            "updated_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('investor')->where('id', $id)->update(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('investor'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
       
      
    }

    public function delete_investor($id){ 
        $data['investor'] = DB::table('investor')->where('id', $id)->delete();       
        return redirect()->route('investor');
    }
    public function delete_category($id){   
        DB::table('category')->where('id', $id)->delete();       
        DB::table('category')->where('parent', $id)->delete();       
        return redirect()->route('category');
    }


  //Frontend ***********************************
    public function get_investor(Request $request){ 


    $api_url = env('API_URL');
    if(empty($api_url)){
        $api_url = 'https://ks.weaddo.live/api/';
        //$api_url = 'http://localhost/cms/public/api/';
    }
    $response_b = Http::get($api_url."banner", [
        'name' => 'investor',
    ]);
    
    $data['banner'] = [];
    $data['investor'] = [];
    $data['category'] = [];
    if ($response_b->successful()) {
        $data['banner'] = $response_b->json();            
    }

    //Get Category
    $response_c = Http::get($api_url."investor_category", []);
    if ($response_c->successful()) {
        $data['category'] = $response_c->json();            
    }

    //Get Investor data
    $response = Http::get($api_url."investor", [
        'limit' => '50',
        'page' => '1',
        'category' => '',
        'filter' => '',
    ]);  

    if ($response->successful()) {
        $data['investor'] = $response->json();            
    } 

    
    return view('front.investor', $data);
}

    public function get_investor_data(Request $request){
            
            if($request->category_name == 'all'){
                $category_name = '';
            }else{
                $category_name = $request->category_name ? $request->category_name : '';
            }
            
            $year = $request->year ? $request->year : '';            
            
            $api_url = env('API_URL');
            if(empty(trim($api_url))){
                //$api_url = 'https://ks.weaddo.live/public/api/';
                $api_url = 'http://localhost/cms/public/api/';
            }

            $response = Http::get($api_url."investor", [
            'category' => $category_name,
            'year' => $year,
        ]); 

            if ($response->successful()) {
                $resp = $response->json(); 

                

                $pdf = "";
                if(isset($resp['data']))
                {
                    if(($category_name === 'Stock Exchange Disclosures') && empty($fdata['type']))
                    {
                        $class = "";
                        $area = "true";
                        $display = "show";
                        $arr = array("Report on Corporate Governance" =>"corporate-governance","Compliance Certificate for Share Transfer Facility Under Regulation 7(3) of SEBI Listing Regulations"=>"transfer-facility7(3)","Compliance Certificate of Transfer Sub division request(s) under Regulation 40(9)"=>"regulation-40(9)","Reconciliation of Share Capital Audit Report"=>"reconciliation-report","Notice of Board Meeting"=>"notice-board-meeting","Investor Grievances under Regulation 13(3)"=>"regulation-13(3)","Disclosure of Related Party Transactions under Regulation 23(9) of SEBI Listing Regulations"=>"regulation-23(9)","Certificate for Dematerialisation under Regulation 74(5)"=>"regulation-74(5)","Closure of Trading Window"=>"closure-trading-window","Annual Secretarial Compliance Report"=>"annual-report", "Statement of Deviation" => "statement-of-deviation");
                        foreach($arr as $r => $val) {

                    //         $pdf .= '<div class="accordion-item rounded-3 border-0 shadow mb-2">
                    // <h2 class="accordion-header">
                    // <button class="accordion-button border-bottom fw-semibold {{ $class }}" type="button"
                    //         data-bs-toggle="collapse" data-bs-target="#flush-collapse{{ $key }}" aria-expanded="true"
                    //         aria-controls="flush-collapse{{ $key }}">
                    //     {{ $op['title'] }}
                    // </button>
                    // </h2>

                    // </div>';


                            $class = "collapsed";
                            $area = "false";
                            $display = "";

                        }

                    }else{
                        foreach($resp['data'] as $fdata){
                            if(($fdata['type_of_content'] === 'text') && empty($fdata['type']))
                            {
                                $pdf .= $fdata['content'];
                            }
                            if (($fdata['type_of_content'] === 'pdf') && empty($fdata['type'])) 
                            {
                                $pdf .= '<div class="col-md-4">
                                    <a href="'. asset('/upload/investor').'/'. $fdata['pdf'] .'" target="_new" class="pdfdiv">
                                    <img src="'. asset('/front/images/pdf-icon.png').'">
                                    <p>'. $fdata['title'] .'</p>
                                    </a>
                                </div>';
                            }                     
                        }
                    }
                    
                }
                if($pdf){
                    echo $pdf;
                }
            } else {        
                $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
            }


    }

}
