<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use Hash;


class InfraController extends Controller
{

    public function index(){        
       //
    }
    public function add_infrastructure(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_infra');
    }

    public function store_infrastructure(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                 
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('infrastructure')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('infrastructure');
            
    }

    public function infrastructure(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['infrastructure'] = DB::table('infrastructure')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_infra', $data);
    }


    public function edit_infrastructure($id){
        $data['id'] = $id;
        $data['infrastructure'] = DB::table('infrastructure')->where('id', $id)->first();
        return view('edit_infra', $data);
    }

    public function update_infrastructure(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                    
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('infrastructure')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('infrastructure');            
    }

    public function delete_infrastructure($id){ 
        DB::table('infrastructure')->where('id', $id)->delete();       
        return redirect()->route('infrastructure');
    }


}
