<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class HomeController extends Controller
{
    public function index(){        
        //
    }

    public function dashboard(){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }       
        return view('dashboard');
    }

    public function enquiry(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['enquiry'] = DB::table('enquiry')->orderBy('id', 'DESC')->get(); 
        return view('enquiry', $data);
    }

    //Award
    public function award(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['award'] = DB::table('award')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_award', $data);
    }

    public function add_award(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_award');
    }

    public function store_award(Request $request)
    { 

        $head = [
                "title" => $request->title,                    
                "heading" => $request->heading,                 
                "sub_heading" => $request->sub_heading,                    
                "description" => strip_tags($request->content),                                  
                "sort_order" => $request->Sorting,                    
                "status" => $request->status,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('award')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('award');      
    }

    public function edit_award($id){
        $data['id'] = $id;
        $data['award'] = DB::table('award')->where('id', $id)->first();
        return view('edit_award', $data);
    }

    public function update_award(Request $request, $id)
    { 

        $head = [
            "title" => $request->title,                    
            "heading" => $request->heading,                 
            "sub_heading" => $request->sub_heading,                    
            "description" => strip_tags($request->content),                                  
            "sort_order" => $request->Sorting,                    
            "status" => $request->status,
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('award')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('award');            
    }

    public function delete_award($id){ 
        DB::table('award')->where('id', $id)->delete();       
        return redirect()->route('award');
    }

    //Testimonials
    public function testimonial(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['testimonial'] = DB::table('testimonial')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_testimonial', $data);
    }

    public function add_testimonial(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_testimonial');
    }

    public function store_testimonial(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $head = [
                "title" => $request->title, 
                "slug" => str_replace(" ", "-",strtolower($request->title)),                   
                "heading" => $request->heading,                 
                //"sub_heading" => $request->sub_heading,                    
                "description" => $request->content,
                "image" => $filename,                               
                "sort_order" => $request->Sorting??0,                    
                "status" => $request->status,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('testimonial')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('testimonial');      
    }

    public function edit_testimonial($id){
        $data['id'] = $id;
        $data['testimonial'] = DB::table('testimonial')->where('id', $id)->first();
        return view('edit_testimonial', $data);
    }

    public function update_testimonial(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $head = [
            "title" => $request->title,
            "slug" => str_replace(" ", "-",strtolower($request->title)),                    
            "heading" => $request->heading,                 
           // "sub_heading" => $request->sub_heading,                    
            "description" => $request->content,
            "image" => $filename,                                  
            "sort_order" => $request->Sorting,                    
            "status" => $request->status,
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('testimonial')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('testimonial');            
    }

    public function delete_testimonial($id){ 
        DB::table('testimonial')->where('id', $id)->delete();       
        return redirect()->route('testimonial');
    }

    //Business Area
    public function business_area(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['business_area'] = DB::table('business_area')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_business_area', $data);
    }

    public function add_business_area(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_business_area');
    }

    public function store_business_area(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $head = [
                "title" => $request->title,                    
                "heading" => $request->heading,                 
                "sub_heading" => $request->sub_heading,                    
                "description" => strip_tags($request->content),
                "image" => $filename,                                  
                "sort_order" => $request->Sorting,                    
                "status" => $request->status,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('business_area')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('business_area');      
    }

    public function edit_business_area($id){
        $data['id'] = $id;
        $data['business_area'] = DB::table('business_area')->where('id', $id)->first();
        return view('edit_business_area', $data);
    }

    public function update_business_area(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $head = [
            "title" => $request->title,                    
            "heading" => $request->heading,                 
            "sub_heading" => $request->sub_heading,                    
            "description" => strip_tags($request->content),
            "image" => $filename,                                  
            "sort_order" => $request->Sorting,                    
            "status" => $request->status,
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('business_area')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('business_area');            
    }

    public function delete_business_area($id){ 
        DB::table('business_area')->where('id', $id)->delete();       
        return redirect()->route('business_area');
    }

    //-----------------
     //Business Area
     public function page(Request $request){  

        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['page'] = DB::table('page_content')->orderBy('id', 'DESC')->get();
        return view('view_page_content', $data);
    }

    public function add_page_content(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_page_content');
    }

    public function store_page_content(Request $request)
    { 
        
        $check = DB::table('page_content')->where('name', $request->display)->first();
        if(!$check || 1==1)
        {
                $filename = "";
                if($request->hasfile('file')){
                    $file = $request->file('file');
                    $extension = $file->getClientOriginalExtension();
                    $filename = time().'.'.$extension;           
                    $file->move('upload', $filename);  
                }
                $slug = str_replace(" ", "-",strtolower($request->title));
                $slug = str_replace(".", "",strtolower($slug));
                $head = [
                        "name" => $request->display,                    
                        "slug" => $slug,                   
                        "title" => $request->title,
                        "sub_title" => $request->sub_title,
                        "image" => $filename, 
                        "content" => $request->content,
                        "text_one" => $request->tone, 
                        "text_two" => $request->ttwo, 
                        "text_three" => $request->tthree, 
                        "text_four" => $request->tfour,                                
                        "sort_order" => $request->Sorting??0,                    
                        "status" => $request->status,                
                        "meta_title" => $request->m_title,
                        "meta_description" => $request->m_desc,
                        "updated_at" => date("Y-m-d H:i:s"),
                        "created_at" => date("Y-m-d H:i:s"),
                    ];

                DB::table('page_content')->insertGetId($head);
                Session::flash('message', 'Created successfully.'); 
                Session::flash('alert-class', 'alert-success');
                return redirect()->route('page');   
        }else{
            Session::flash('message', 'Already added.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('add_page_content');
        }   
    }

    public function edit_page_content($id){
        $data['id'] = $id;
        $data['page_content'] = DB::table('page_content')->where('id', $id)->first();
        return view('edit_page_content', $data);
    }

    public function update_page_content(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }
        $slug = str_replace(" ", "-",strtolower($request->title));
        $slug = str_replace(".", "",strtolower($slug));
        $head = [
           "name" => $request->display,                    
            "slug" => $slug,                   
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename, 
            "content" => $request->content,
            "text_one" => $request->tone, 
            "text_two" => $request->ttwo, 
            "text_three" => $request->tthree, 
            "text_four" => $request->tfour,                                 
            "sort_order" => $request->Sorting??0,                    
            "status" => $request->status,                
            "meta_title" => $request->m_title,
            "meta_description" => $request->m_desc,
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];


        DB::table('page_content')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('page');            
    }

    public function delete_page_content($id){ 
        DB::table('page_content')->where('id', $id)->delete();       
        return redirect()->route('page');
    }

     public function leads(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['leads'] = DB::table('landingpage_leads')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('landingpage_leads', $data);
    }

    
}
