<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use Hash;



class FaqController extends Controller
{

    public function index(){        
       //
    }

    public function get_faqs(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['faqs'] = DB::table('faq')->orderBy('id', 'DESC')->get(); 
        return view('view_faqs', $data);
    }
    public function add_faq(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_faq');
    }

    public function store_faq(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "question" => $request->question, 
                "answer" => $request->answer,
                "image" => $filename,              
                "status" => $request->status,
                "sort_order" => $request->Sorting,           
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('faq')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('faqs');
            
    }

    public function edit_faq($id){
        $data['id'] = $id;
        $data['faq'] = DB::table('faq')->where('id', $id)->first();
        return view('edit_faq', $data);
    }

    public function update_faq(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
            "question" => $request->question, 
            "answer" => $request->answer,
            "image" => $filename,              
            "status" => $request->status,
            "sort_order" => $request->Sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('faq')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('faqs');            
    }

    public function delete_faq($id){ 
        DB::table('faq')->where('id', $id)->delete();       
        return redirect()->route('faqs');
    }


    //Features & Benifits
    public function get_features(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['features'] = DB::table('slider_content')->where('name', 'feature_benefits')->orderBy('id', 'DESC')->get(); 
        return view('view_features', $data);
    }
    public function add_feature(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_feature');
    }

    public function store_feature(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => 'feature_benefits', 
                "title" => $request->title, 
                "content" => $request->content,
                "image" => $filename,              
                "status" => $request->status,
                "sort_order" => $request->sorting,           
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('slider_content')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('features');
            
    }

    public function edit_feature($id){
        $data['id'] = $id;
        $data['feature'] = DB::table('slider_content')->where('id', $id)->first();
        return view('edit_feature', $data);
    }

    public function update_feature(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
            "title" => $request->title, 
            "content" => $request->content,
            "image" => $filename,              
            "status" => $request->status,
            "sort_order" => $request->sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('slider_content')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('features');            
    }

    public function delete_feature($id){ 
        DB::table('slider_content')->where('id', $id)->delete();       
        return redirect()->route('features');
    }

    //kamdhenu NXT
    public function get_kamdhenu_nxt(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['nxt'] = DB::table('slider_content')->where('name', 'kamdhenu_nxt')->orderBy('id', 'DESC')->get(); 
        return view('view_kamdhenu_nxt', $data);
    }
    public function add_kamdhenu_nxt(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_kamdhenu_nxt');
    }

    public function store_kamdhenu_nxt(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => 'kamdhenu_nxt', 
                "title" => $request->title, 
                "content" => $request->content,
                "image" => $filename,              
                "status" => $request->status,
                "sort_order" => $request->sorting,           
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('slider_content')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('kamdhenu_nxt');
            
    }

    public function edit_kamdhenu_nxt($id){
        $data['id'] = $id;
        $data['nxt'] = DB::table('slider_content')->where('id', $id)->first();
        return view('edit_kamdhenu_nxt', $data);
    }

    public function update_kamdhenu_nxt(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
            "title" => $request->title, 
            "content" => $request->content,
            "image" => $filename,              
            "status" => $request->status,
            "sort_order" => $request->sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('slider_content')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('kamdhenu_nxt');            
    }

    public function delete_kamdhenu_nxt($id){ 
        DB::table('slider_content')->where('id', $id)->delete();       
        return redirect()->route('kamdhenu_nxt');
    }


    //Kamdhenu Difference
    public function get_kamdhenu_difference(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['difference'] = DB::table('slider_content')->where('name', 'kamdhenu_difference')->orderBy('id', 'DESC')->get(); 
        return view('view_kamdhenu_difference', $data);
    }
    public function add_kamdhenu_difference(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_kamdhenu_difference');
    }

    public function store_kamdhenu_difference(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => 'kamdhenu_difference', 
                "title" => $request->title, 
                "content" => $request->content,
                "image" => $filename,              
                "status" => $request->status,
                "sort_order" => $request->sorting,           
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('slider_content')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('kamdhenu_difference');
            
    }

    public function edit_kamdhenu_difference($id){
        $data['id'] = $id;
        $data['difference'] = DB::table('slider_content')->where('id', $id)->first();
        return view('edit_kamdhenu_difference', $data);
    }

    public function update_kamdhenu_difference(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
            "title" => $request->title, 
            "content" => $request->content,
            "image" => $filename,              
            "status" => $request->status,
            "sort_order" => $request->sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('slider_content')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('kamdhenu_difference');            
    }

    public function delete_kamdhenu_difference($id){ 
        DB::table('slider_content')->where('id', $id)->delete();       
        return redirect()->route('kamdhenu_difference');
    }


    //Kamdhenu Building Dreams
    public function get_building_dreams(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['dreams'] = DB::table('slider_content')->where('name', 'building_dreams')->orderBy('id', 'DESC')->get(); 
        return view('view_building_dreams', $data);
    }
    public function add_building_dreams(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_building_dreams');
    }

    public function store_building_dreams(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "name" => 'building_dreams', 
                "title" => $request->title, 
                "content" => $request->content,
                "image" => $filename,              
                "status" => $request->status,
                "sort_order" => $request->sorting,           
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('slider_content')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('building_dreams');
            
    }

    public function edit_building_dreams($id){
        $data['id'] = $id;
        $data['building_dreams'] = DB::table('slider_content')->where('id', $id)->first();
        return view('edit_building_dreams', $data);
    }

    public function update_building_dreams(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
            "title" => $request->title, 
            "content" => $request->content,
            "image" => $filename,              
            "status" => $request->status,
            "sort_order" => $request->sorting,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        DB::table('slider_content')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('building_dreams');            
    }

    public function delete_building_dreams($id){ 
        DB::table('slider_content')->where('id', $id)->delete();       
        return redirect()->route('building_dreams');
    }


}
