<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\user;
use Hash;

class EventController extends Controller
{

    public function index(){        
       //
    }
    public function add_event(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_event');
    }

    public function store_event(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                 
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,  
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('event')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('view_event');
            
    }

    public function view_event(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['event'] = DB::table('event')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_event', $data);
    }


    public function edit_event($id){
        $data['id'] = $id;
        $data['event'] = DB::table('event')->where('id', $id)->first();
        return view('edit_event', $data);
    }

    public function update_event(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                  
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('event')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('view_event');            
    }

    public function delete_event($id){ 
        DB::table('event')->where('id', $id)->delete();       
        return redirect()->route('view_event');
    }

    //Front page
    public function event(){          
        return view('front.event');
    }

    public function get_event_data(Request $request){ 

        $year = $request["year"] ? $request["year"] : '';   
        $last_rowcount = $request["rowcount"];
        $rowcount = $request["rowcount"] + 15; 
  
        // $api_url = "http://localhost/cms/public/api/event";

        // $response = Http::get($api_url, [
        //     'last_rowcount' => $last_rowcount,
        //     'year' => $year,
        // ]);

        $api_url = env('API_URL');
        if(empty($api_url)){
            $api_url = 'https://ks.weaddo.live/api/';
            //$api_url = 'http://localhost/cms/public/api/';
        } 
        $response = Http::get($api_url."event", ['last_rowcount' => $last_rowcount, 'year' => $year,]);


        if ($response->successful()) {
            $resp = $response->json(); 
        }
        if($last_rowcount == 0){
            $dynamic_data = "";
        }
        $count = count($resp['data']);
        if($count > 0){
            $dynamic_data = "";
            foreach($resp['data'] as $event) {
                $newDate = date("M d Y", strtotime($event['created_at']));
                $dynamic_data .=
                '<a href="'. url('/event-detail') .'/'.$event['id'] .'">
                    <img src="'. asset('/upload/').'/'.$event['image'].'" class="img-fluid" >
                    <h5>' . $event['title'] . '</h5>
                    <span>'. $newDate .'</span>
                </a>';       
            }            
       
            $data = [
                "status" => true,
                "rowcount" => $rowcount,
                "msg" => "Successfully!",
                "data" => $dynamic_data,
            ];
        } else {
            $data = [
                "status" => false,
                "msg" => "Error!",
            ];
        }
    echo json_encode($data);
    
    }

    public function event_detail($id){ 
        
        // $api_url = "http://localhost/cms/public/api/event";

        // $response = Http::get($api_url, [
        //     'event_id' => $id
        // ]);

        $api_url = env('API_URL'); 
        $response = Http::get($api_url."event", ['event_id' => $id]);

        if ($response->successful()) {
            $resp = $response->json(); 
            $data['detail'] = $resp['data'][0];
        }

        // $api_url1 = "http://localhost/cms/public/api/latest_event";

        // $latest = Http::get($api_url1, []);

        $latest = Http::get($api_url."latest_event", []);

        if ($latest->successful()) {
            $latest_resp = $latest->json(); 
            $data['latest_event'] = $latest_resp['data'];
        }

        return view('front.event_detail', $data);
    }

}
