<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;


class ContactController extends Controller
{

    public function index(){        
       //
    }
    public function add_contacts(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_contacts');
    }

    public function store_contacts(Request $request)
    { 
        
        $getdata = DB::table('contacts')->where('name', $request->name)->get();         
        if($request->name == 'registered_office' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('contacts');
        }
        if($request->name == 'plants' && count($getdata) == 2){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('contacts');
        }
        if($request->name == 'become_partner' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('contacts');
        } 

        $head = [
                "name" => $request->name,                    
                "title" => $request->title,
                "sort_order" => $request->Sorting,          
                "content" => $request->content,
                "direction" => $request->direction,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('contacts')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('contacts');
            
    }

    public function get_contacts(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['contacts'] = DB::table('contacts')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_contacts', $data);
    }


    public function edit_contacts($id){
        $data['id'] = $id;
        $data['contacts'] = DB::table('contacts')->where('id', $id)->first();
        return view('edit_contacts', $data);
    }

    public function update_contacts(Request $request, $id)
    { 
  
        $head = [
                "name" => $request->name,
                "title" => $request->title,         
                "sort_order" => $request->Sorting,  
                "content" => $request->content,
                "direction" => $request->direction,
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('contacts')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('contacts');            
    }

    public function delete_contacts($id){ 
        DB::table('contacts')->where('id', $id)->delete();       
        return redirect()->route('contacts');
    }

    //Frontend
    public function get_contact_us(Request $request){
        
    $api_url = env('API_URL'); 
    $response = Http::get($api_url."contact", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }

        return view('front.contact', $resp);
    }


    public function get_city(Request $request){ 

        $data = DB::table('cities')->select('id','name')->where('state_id', $request->state_id)->get();  
            if(count($data) > 0){
                $html = '';
                foreach($data as $c)
                {
                    $html .='<option value="'.$c->id.'">'.$c->name.'</option>';
                }
                return $html;
              }else{
                return false;
            }

    }

    public function submit_enquiry(Request $request){        
        
        $data = [
            "type" => $request->subject,
            "name" => $request->fname,
            "email" => $request->email,
            "phone" => $request->phone,
            "subject" => $request->subject,
            "content" => $request->message,
            "city" => $request->city,
            "state" => $request->state,
            "created_at" => date("Y-m-d H:i:s"),
            "updated_at" => date("Y-m-d H:i:s"),
        ];

        $id = DB::table('enquiry')->insertGetId($data);
        if($id > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('contact-us');
        }else{
            Session::flash('message', 'Something went wrong.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('contact-us');
        }

    }
    

    public function store_enquiry(Request $request){        
    

        $data = [
            "name" => $request->name,
            "email" => $request->email,
            "phone" => $request->phone,
            "pincode" => $request->pincode,
            "subject" => $request->subject,
            "content" => $request->message
        ];

        $api_url = env('API_URL');

        $response = Http::post($api_url."enquiry", $data);
        return true;

    }


}
