<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use App\Models\user;
use Hash;



class BrandController extends Controller
{

    public function index(){        
       //
    }

    public function brands(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['blog'] = DB::table('brands')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_brands', $data);
    }
    public function add_brand(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_brand');
    }

    public function store_brand(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title, 
                "content" => strip_tags($request->content),                   
                "slug" => $request->slug,                 
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,               
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('brands')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('brands');
            
    }

    public function edit_brand($id){
        $data['id'] = $id;
        $data['blog'] = DB::table('brands')->where('id', $id)->first();
        return view('edit_brand', $data);
    }

    public function update_brand(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug,                  
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('brands')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('brands');            
    }

    public function delete_brand($id){ 
        DB::table('brands')->where('id', $id)->delete();       
        return redirect()->route('brands');
    }


}
