<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use App\Models\user;
use Hash;

class BlogController extends Controller
{

    public function index(){        
       //
    }
    public function add_blog(){   
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }     
        return view('add_blog');
    }

    public function store_blog(Request $request)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug, 
                "display_date" => date('Y-m-d', strtotime($request->display_date)),                 
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('blog')->insertGetId($head);
        Session::flash('message', 'Created successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('add_blog');
            
    }

    public function view_blog(){  
        
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        
        $data['blog'] = DB::table('blog')->orderBy('id', 'DESC')->get(); //->where('status', 1)
        return view('view_blog', $data);
    }


    public function edit_blog($id){
        $data['id'] = $id;
        $data['blog'] = DB::table('blog')->where('id', $id)->first();
        return view('edit_blog', $data);
    }

    public function update_blog(Request $request, $id)
    { 
        $filename = "";
        if($request->hasfile('file')){
            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload', $filename);  
        }

        $head = [
                "title" => $request->title,                    
                "slug" => $request->slug, 
                "display_date" => date('Y-m-d', strtotime($request->display_date)),                   
                "meta_title" => $request->m_title,                    
                "meta_description" => $request->m_desc,                                  
                "sort_order" => $request->Sorting,                    
                "image" => $filename,                        
                "content" => strip_tags($request->content),
                "updated_at" => date("Y-m-d H:i:s"),
            ];

        DB::table('blog')->where('id', $id)->update(array_filter($head));
        Session::flash('message', 'Updated successfully.'); 
        Session::flash('alert-class', 'alert-success');
        return redirect()->route('view_blog');            
    }

    public function delete_blog($id){ 
        DB::table('blog')->where('id', $id)->delete();       
        return redirect()->route('view_blog');
    }

    //Front page
    public function blog(){          
        return view('front.blog');
    }

    public function get_blog_data(Request $request){ 

        $year = $request["year"] ? $request["year"] : '';   
        $last_rowcount = $request["rowcount"];
        $rowcount = $request["rowcount"] + 6; 
  
        $api_url = env('API_URL');
        if(empty($api_url)){
            $api_url = 'https://ks.weaddo.live/api/';
            //$api_url = 'http://localhost/cms/public/api/';
        } 
        $response = Http::get($api_url."blog", ['last_rowcount' => $last_rowcount, 'year' => $year]);

        if ($response->successful()) {
            $resp = $response->json(); 
        }
        if($last_rowcount == 0){
            $dynamic_data = "";
        }
        $count = count($resp['data']);
        if($count > 0){
            $dynamic_data = "";
            foreach($resp['data'] as $blog) {
                $newDate = date("M d Y", strtotime($blog['created_at']));
                $dynamic_data .=
                '<a href="'. url('/blog-detail') .'/'.$blog['id'] .'">
                    <img src="'. asset('/upload/').'/'.$blog['image'].'" class="img-fluid" >
                    <h5>' . $blog['title'] . '</h5>
                    <span>'. $newDate .'</span>
                </a>';       
            }            
       
            $data = [
                "status" => true,
                "rowcount" => $rowcount,
                "msg" => "Successfully!",
                "data" => $dynamic_data,
            ];
        } else {
            $data = [
                "status" => false,
                "msg" => "Error!",
            ];
        }
    echo json_encode($data);
    
    }

    public function blog_detail($id){         
    

        $api_url = env('API_URL');
        if(empty($api_url)){
            $api_url = 'https://ks.weaddo.live/api/';
           //$api_url = 'http://localhost/cms/public/api/';
        } 
        $response = Http::get($api_url."blog", ['blog_id' => $id]);

        if ($response->successful()) {
            $resp = $response->json(); 
            $data['detail'] = $resp['data'][0];
        }


        $latest = Http::get($api_url."latest_blog", []);

        if ($latest->successful()) {
            $latest_resp = $latest->json(); 
            $data['latest_blog'] = $latest_resp['data'];
        }

        return view('front.blog_detail', $data);
    }

}
