<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Date;

class BannerController extends Controller
{
    public function banner(){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['slider_image'] = DB::table('banner')->get();       
        return view('slider_image', $data);
       
    }

    public function add_banner(){  
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['category'] = DB::table('category')->where('parent', 0)->get();       
        return view('add_slider_image',  $data);
    }
    public function store_banner(Request $request){     
        
        

        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/banner', $filename);  
        }
        
            $data = [
                "name" => $request->pagename,
                "title" => $request->title,                       
                "content" => $request->description,                       
                "image" => $filename,                       
                "banner_for" => $request->banner_for,                       
                "status" => $request->status,
                "sort_order" => $request->sorting,
                "meta_title" => $request->m_title,
                "meta_descripton" => $request->m_desc,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

            DB::table('banner')->insertGetId(array_filter($data));
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('banner');

    }

    public function edit_banner($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['id'] = $id;
        $data['banner'] = DB::table('banner')->where('id', $id)->first();                
        return view('edit_slider_image', $data);
    }

    public function update_banner(Request $request, $id){ 

        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/banner', $filename);  
        }
        
            $data = [
                "name" => $request->pagename,                       
                "title" => $request->title,                       
                "content" => $request->description,                       
                "image" => $filename,                       
                "banner_for" => $request->banner_for,                       
                "status" => $request->status,
                "sort_order" => $request->sorting,
                "meta_title" => $request->m_title,
                "meta_descripton" => $request->m_desc,
                "updated_at" => date("Y-m-d H:i:s"),
                "created_at" => date("Y-m-d H:i:s"),
            ];

        $respid = DB::table('banner')->where('id', $id)->update(array_filter($data));

        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('banner'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }       
      
    }

    public function delete_banner($id){   
        DB::table('banner')->where('id', $id)->delete();
        return redirect()->route('banner');
    }




}
