<?php
namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session; 
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Date;

class AboutController extends Controller
{

    public function about(Request $request){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['about'] = DB::table('about')->get();       
        return view('about', $data);
    }

    public function add_about(Request $request){
        return view('add_about');
    }

    public function store_about(Request $request){ 
        $getdata = DB::table('about')->where('name', $request->name)->get();         
        if(($request->name == 'about' && count($getdata) == 1) || ($request->name == 'message' && count($getdata) == 1) || ($request->name == 'vision' && count($getdata) == 1) || ($request->name == 'mission' && count($getdata) == 1) || ($request->name == 'philosophy' && count($getdata) == 1) || ($request->name == 'director' && count($getdata) == 1)){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('about');
        }
        if($request->name == 'philosophy_bottom' && count($getdata) == 4){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('about');
        }


        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,
            "content" => $request->content,
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename,
            "status" => 1,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('about')->insertGetId(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('about'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
         
    }

    public function edit_about($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['about'] = DB::table('about')->where('id', $id)->first();
        return view('edit_about', $data);
    }

    public function update_about(Request $request, $id){ 
           
        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,
            "content" => $request->content,
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename,
            "status" => $request->status,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
        ];


        $respid = DB::table('about')->where('id', $id)->update(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('about'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
       
      
    }

    public function delete_about($id){ 
        DB::table('about')->where('id', $id)->delete();       
        return redirect()->route('about');
    }

    //Frontend
    public function get_about_us(Request $request){        
  
        $api_url = env('API_URL');

        $response = Http::get($api_url."about", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.about', $resp);

    }


    public function get_csr_data(Request $request){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['about'] = DB::table('about')->whereIN('name', ['csr_initiative','csr_bottom'])->get();       
        return view('get_csr_data', $data);
    }

    public function add_csr(Request $request){
        return view('add_csr');
    }

    public function store_csr(Request $request){ 
        $getdata = DB::table('about')->where('name', $request->name)->get();       
         if($request->name == 'csr_bottom' && count($getdata) == 1){
            Session::flash('message', 'Already exist'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('csr-data');
        }

        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,
            "content" => $request->content,
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename,
            "status" => 1,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
            "created_at" => date("Y-m-d H:i:s"),
        ];

        $respid = DB::table('about')->insertGetId(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('csr-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
         
    }

    public function edit_csr($id){ 
        if (Auth::check()==FALSE) {
            return redirect()->route('login');
        }
        $data['about'] = DB::table('about')->where('id', $id)->first();
        return view('edit_csr', $data);
    }

    public function update_csr(Request $request, $id){ 
           
        $filename = "";
        if($request->hasfile('file')){

            // $request->validate([
            //     'file' => 'required|file|mimes:pdf|max:2048',
            // ]);

            $file = $request->file('file');
            $extension = $file->getClientOriginalExtension();
            $filename = time().'.'.$extension;           
            $file->move('upload/', $filename);  
        }
        
        $data = [
            "name" => $request->name,
            "content" => $request->content,
            "title" => $request->title,
            "sub_title" => $request->sub_title,
            "image" => $filename,
            "status" => $request->status,
            "sort_order" => 1,           
            "updated_at" => date("Y-m-d H:i:s"),
        ];


        $respid = DB::table('about')->where('id', $id)->update(array_filter($data));
        if($respid > 0){
            Session::flash('message', 'Created successfully.'); 
            Session::flash('alert-class', 'alert-success');
            return redirect()->route('csr-data'); 
        }else{
            Session::flash('message', 'Try again!!.'); 
            Session::flash('alert-class', 'alert-danger');
        }
       
      
    }

    public function delete_csr($id){ 
        DB::table('about')->where('id', $id)->delete();       
        return redirect()->route('csr-data');
    }

    public function get_csr(Request $request){        
  
        $api_url = env('API_URL');
        $response = Http::get($api_url."csr", ['limit' => '5000']); 

        if ($response->successful()) {
            $resp = $response->json(); 
        }else {        
            $resp = ['success' => 'false', 'error' => 'Unable to fetch data'];
        }
        return view('front.csr', $resp);
    }


}
